/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.function.Function;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.KlassLayoutHelperNode;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.replacements.InvocationPluginHelper;
import org.graalvm.word.LocationIdentity;

public class HotSpotInvocationPluginHelper
extends InvocationPluginHelper {
    private final GraalHotSpotVMConfig config;

    public HotSpotInvocationPluginHelper(GraphBuilderContext b, ResolvedJavaMethod targetMethod, GraalHotSpotVMConfig config) {
        super(b, targetMethod);
        this.config = config;
    }

    private Stamp getClassStamp(boolean nonNull) {
        ResolvedJavaType toType = this.b.getMetaAccess().lookupJavaType(Class.class);
        return StampFactory.object(TypeReference.createExactTrusted(toType), nonNull);
    }

    public ValueNode readKlassFromClass(ValueNode clazz) {
        return this.b.add(ClassGetHubNode.create(clazz, this.b.getMetaAccess(), this.b.getConstantReflection()));
    }

    private ValueNode readLocation(ValueNode base, HotSpotVMConfigField field) {
        return this.readLocation(base, field.getOffset(this.config), field.location, field.getStamp(this.getWordKind()), null);
    }

    private ValueNode readLocation(ValueNode base, HotSpotVMConfigField field, Stamp stamp) {
        assert (field.getStamp(this.getWordKind()) == null);
        return this.readLocation(base, field.getOffset(this.config), field.location, stamp, null);
    }

    private ValueNode readLocation(ValueNode base, int offset, LocationIdentity location, Stamp stamp, GuardingNode guard) {
        ValueNode returnValue;
        assert (StampTool.isPointerNonNull(base) || base.stamp(NodeView.DEFAULT).getStackKind() == this.getWordKind()) : "must be null guarded";
        AddressNode address = this.makeOffsetAddress(base, this.asWord(offset));
        ReadNode value = this.b.add(new ReadNode(address, location, stamp, OnHeapMemoryAccess.BarrierType.NONE));
        if (value == (returnValue = ReadNode.canonicalizeRead(value, value.getAddress(), value.getLocationIdentity(), this.b, NodeView.DEFAULT)) && guard != null) {
            value.setGuard(guard);
        }
        return this.b.add(returnValue);
    }

    public ValueNode readKlassModifierFlags(ValueNode klass) {
        return this.readLocation(klass, HotSpotVMConfigField.KLASS_MODIFIER_FLAGS_OFFSET);
    }

    public ValueNode readKlassAccessFlags(ValueNode klass) {
        return this.readLocation(klass, HotSpotVMConfigField.KLASS_ACCESS_FLAGS_OFFSET);
    }

    public ValueNode klassLayoutHelper(ValueNode klass) {
        return this.b.add(KlassLayoutHelperNode.create(this.config, klass, this.b.getConstantReflection(), this.b.getMetaAccess()));
    }

    public ValueNode readArrayKlassComponentMirror(ValueNode klass, GuardingNode guard) {
        int offset = this.config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop");
        Stamp stamp = this.getClassStamp(true);
        return this.readLocation(klass, offset, HotSpotReplacementsUtil.ARRAY_KLASS_COMPONENT_MIRROR, stamp, guard);
    }

    public ValueNode readKlassSuperKlass(PiNode klassNonNull) {
        return this.readLocation(klassNonNull, HotSpotVMConfigField.KLASS_SUPER_KLASS_OFFSET);
    }

    public PiNode emitNullReturnGuard(ValueNode klass, ValueNode returnValue, double probability) {
        AbstractBeginNode nonnullGuard = this.emitReturnIf(IsNullNode.create(klass), returnValue, probability);
        return this.piCast(klass, nonnullGuard, KlassPointerStamp.klassNonNull());
    }

    public ValueNode loadArrayKlass(ValueNode componentType) {
        return this.readLocation(componentType, HotSpotVMConfigField.CLASS_ARRAY_KLASS_OFFSET);
    }

    public ValueNode readCurrentThreadObject() {
        return this.readCurrentThreadObject(this.b.add(new CurrentJavaThreadNode(this.getWordKind())));
    }

    public ValueNode readCurrentThreadObject(CurrentJavaThreadNode thread) {
        ObjectStamp threadStamp = StampFactory.objectNonNull(TypeReference.create(this.b.getAssumptions(), this.b.getMetaAccess().lookupJavaType(Thread.class)));
        ObjectStamp fieldStamp = this.config.threadObjectFieldIsHandle ? StampFactory.forKind(this.getWordKind()) : threadStamp;
        ValueNode value = this.readLocation(thread, HotSpotVMConfigField.JAVA_THREAD_THREAD_OBJECT, fieldStamp);
        if (this.config.threadObjectFieldIsHandle) {
            ConstantNode handleOffset = ConstantNode.forIntegerKind(this.getWordKind(), 0L, this.b.getGraph());
            AddressNode handleAddress = this.b.add(new OffsetAddressNode(value, handleOffset));
            value = this.b.add(new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, threadStamp, OnHeapMemoryAccess.BarrierType.NONE));
        }
        return value;
    }

    public ValueNode readOsThread(CurrentJavaThreadNode thread) {
        return this.readLocation(thread, HotSpotVMConfigField.JAVA_THREAD_OSTHREAD_OFFSET);
    }

    public ValueNode readOsThreadInterrupted(ValueNode osThread) {
        return this.readLocation(osThread, HotSpotVMConfigField.OS_THREAD_INTERRUPTED_OFFSET);
    }

    static enum HotSpotVMConfigField {
        KLASS_MODIFIER_FLAGS_OFFSET(config -> config.klassModifierFlagsOffset, HotSpotReplacementsUtil.KLASS_MODIFIER_FLAGS_LOCATION, StampFactory.forKind(JavaKind.Int)),
        KLASS_SUPER_KLASS_OFFSET(config -> config.klassSuperKlassOffset, HotSpotReplacementsUtil.KLASS_SUPER_KLASS_LOCATION, KlassPointerStamp.klass()),
        CLASS_ARRAY_KLASS_OFFSET(config -> config.arrayKlassOffset, HotSpotReplacementsUtil.CLASS_ARRAY_KLASS_LOCATION, KlassPointerStamp.klassNonNull()),
        OS_THREAD_INTERRUPTED_OFFSET(config -> config.osThreadInterruptedOffset, LocationIdentity.any(), StampFactory.forKind(JavaKind.Int)),
        JAVA_THREAD_OSTHREAD_OFFSET(config -> config.osThreadOffset, HotSpotReplacementsUtil.JAVA_THREAD_OSTHREAD_LOCATION),
        JAVA_THREAD_THREAD_OBJECT(config -> config.threadObjectOffset, HotSpotReplacementsUtil.JAVA_THREAD_THREAD_OBJECT_LOCATION, null),
        KLASS_ACCESS_FLAGS_OFFSET(config -> config.klassAccessFlagsOffset, HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION, StampFactory.forKind(JavaKind.Int)),
        HOTSPOT_OOP_HANDLE_VALUE(config -> 0, HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, StampFactory.forKind(JavaKind.Object));

        private final Function<GraalHotSpotVMConfig, Integer> getter;
        private final LocationIdentity location;
        private final Stamp stamp;
        private final boolean isWord;

        private HotSpotVMConfigField(Function<GraalHotSpotVMConfig, Integer> getter, LocationIdentity location, Stamp stamp) {
            this.getter = getter;
            this.location = location;
            this.stamp = stamp;
            this.isWord = false;
        }

        private HotSpotVMConfigField(Function<GraalHotSpotVMConfig, Integer> getter, LocationIdentity location) {
            this.getter = getter;
            this.location = location;
            this.stamp = null;
            this.isWord = true;
        }

        public int getOffset(GraalHotSpotVMConfig config) {
            return this.getter.apply(config);
        }

        public Stamp getStamp(JavaKind wordKind) {
            if (this.isWord) {
                return StampFactory.forKind(wordKind);
            }
            return this.stamp;
        }
    }
}

