/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class UnsafeSnippets
implements Snippets {
    public static final String copyMemoryName = JavaVersionUtil.JAVA_SPEC <= 8 ? "copyMemory" : "copyMemory0";

    @Snippet
    static void copyMemory(Object receiver, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(srcBase, srcOffset));
        Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(destBase, destOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        HotSpotBackend.unsafeArraycopy(srcAddr, dstAddr, size);
    }

    @Snippet
    static void copyMemoryGuarded(Object receiver, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(srcBase, srcOffset));
        Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(destBase, destOffset));
        Word size = (Word)WordFactory.signed((long)bytes);
        Word javaThread = CurrentJavaThreadNode.get();
        int offset = HotSpotReplacementsUtil.doingUnsafeAccessOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        LocationIdentity any = LocationIdentity.any();
        javaThread.writeByte(offset, (byte)1, any);
        HotSpotBackend.unsafeArraycopy(srcAddr, dstAddr, size);
        javaThread.writeByte(offset, (byte)0, any);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo copyMemory = this.snippet(UnsafeSnippets.class, "copyMemory", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo copyMemoryGuarded = this.snippet(UnsafeSnippets.class, "copyMemoryGuarded", new LocationIdentity[0]);

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
        }

        public void lower(UnsafeCopyMemoryNode copyMemoryNode, LoweringTool tool) {
            StructuredGraph graph = copyMemoryNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(copyMemoryNode.isGuarded() ? this.copyMemoryGuarded : this.copyMemory, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("receiver", copyMemoryNode.receiver);
            args.add("srcBase", copyMemoryNode.srcBase);
            args.add("srcOffset", copyMemoryNode.srcOffset);
            args.add("destBase", copyMemoryNode.destBase);
            args.add("destOffset", copyMemoryNode.desOffset);
            args.add("bytes", copyMemoryNode.bytes);
            SnippetTemplate template = this.template(copyMemoryNode, args);
            template.instantiate(this.providers.getMetaAccess(), copyMemoryNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

