/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements.arraycopy;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.arraycopy.CheckcastArrayCopyCallNode;
import org.graalvm.compiler.hotspot.replacements.arraycopy.GenericArrayCopyCallNode;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardedUnsafeLoadNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopySnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public class HotSpotArraycopySnippets
extends ArrayCopySnippets {
    public Pointer loadHub(Object nonNullSrc) {
        return HotSpotReplacementsUtil.loadHub(nonNullSrc).asWord();
    }

    @Override
    public boolean hubsEqual(Object nonNullSrc, Object nonNullDest) {
        Pointer destHub;
        Pointer srcHub = this.loadHub(nonNullSrc);
        return srcHub == (destHub = this.loadHub(nonNullDest));
    }

    public Word getSuperCheckOffset(Pointer destElemKlass) {
        return (Word)WordFactory.signed((int)destElemKlass.readInt(HotSpotReplacementsUtil.superCheckOffsetOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_SUPER_CHECK_OFFSET_LOCATION));
    }

    public int getReadLayoutHelper(Pointer srcHub) {
        return HotSpotReplacementsUtil.readLayoutHelper(KlassPointer.fromWord(srcHub));
    }

    @Override
    public boolean layoutHelpersEqual(Object nonNullSrc, Object nonNullDest) {
        Pointer srcHub = this.loadHub(nonNullSrc);
        Pointer destHub = this.loadHub(nonNullDest);
        return this.getReadLayoutHelper(srcHub) == this.getReadLayoutHelper(destHub);
    }

    public Pointer getDestElemClass(Pointer destKlassPointer) {
        KlassPointer destKlass = KlassPointer.fromWord(destKlassPointer);
        return destKlass.readKlassPointer(HotSpotReplacementsUtil.arrayClassElementOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.OBJ_ARRAY_KLASS_ELEMENT_KLASS_LOCATION).asWord();
    }

    @Override
    protected int heapWordSize() {
        return HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected void doExactArraycopyWithExpandedLoopSnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation, ArrayCopySnippets.Counters counters) {
        int scale = ReplacementsUtil.arrayIndexScale(INJECTED_META_ACCESS, elementKind);
        int arrayBaseOffset = ReplacementsUtil.getArrayBaseOffset(INJECTED_META_ACCESS, elementKind);
        long sourceOffset = (long)arrayBaseOffset + (long)srcPos * (long)scale;
        long destOffset = (long)arrayBaseOffset + (long)destPos * (long)scale;
        GuardingNode anchor = SnippetAnchorNode.anchor();
        if (BranchProbabilityNode.probability(0.09999999999999998, src == dest && srcPos < destPos)) {
            int position = length - 1;
            while (BranchProbabilityNode.probability(0.99, position >= 0)) {
                Object value = GuardedUnsafeLoadNode.guardedLoad(src, sourceOffset + (long)position * (long)scale, elementKind, arrayLocation, anchor);
                RawStoreNode.storeObject(dest, destOffset + (long)position * (long)scale, value, elementKind, arrayLocation, true);
                --position;
            }
        } else {
            int position = 0;
            while (BranchProbabilityNode.probability(0.99, position < length)) {
                Object value = GuardedUnsafeLoadNode.guardedLoad(src, sourceOffset + (long)position * (long)scale, elementKind, arrayLocation, anchor);
                RawStoreNode.storeObject(dest, destOffset + (long)position * (long)scale, value, elementKind, arrayLocation, true);
                ++position;
            }
        }
    }

    @Override
    protected void doCheckcastArraycopySnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation, ArrayCopySnippets.Counters counters) {
        if (BranchProbabilityNode.probability(0.9, length > 0)) {
            Pointer destKlass;
            Class<?> nonNullSrc = PiNode.asNonNullObject(src);
            Class<?> nonNullDest = PiNode.asNonNullObject(dest);
            Pointer srcKlass = this.loadHub(nonNullSrc);
            if (BranchProbabilityNode.probability(0.6, srcKlass == (destKlass = this.loadHub(nonNullDest))) || BranchProbabilityNode.probability(0.6, nonNullDest.getClass() == Object[].class)) {
                counters.objectCheckcastSameTypeCounter.inc();
                counters.objectCheckcastSameTypeCopiedCounter.add(length);
                ArrayCopyCallNode.arraycopyObjectKillsAny(nonNullSrc, srcPos, nonNullDest, destPos, length, this.heapWordSize());
            } else {
                Pointer destElemKlass = this.getDestElemClass(destKlass);
                Word superCheckOffset = this.getSuperCheckOffset(destElemKlass);
                counters.objectCheckcastDifferentTypeCounter.inc();
                counters.objectCheckcastDifferentTypeCopiedCounter.add(length);
                int copiedElements = CheckcastArrayCopyCallNode.checkcastArraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, superCheckOffset, destElemKlass, false);
                if (BranchProbabilityNode.probability(0.010000000000000009, copiedElements != 0)) {
                    System.arraycopy(nonNullSrc, srcPos + (copiedElements ^= 0xFFFFFFFF), nonNullDest, destPos + copiedElements, length - copiedElements);
                }
            }
        }
    }

    @Override
    protected void doGenericArraycopySnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation, ArrayCopySnippets.Counters counters) {
        counters.genericArraycopyDifferentTypeCounter.inc();
        counters.genericArraycopyDifferentTypeCopiedCounter.add(length);
        int copiedElements = GenericArrayCopyCallNode.genericArraycopy(src, srcPos, dest, destPos, length);
        if (BranchProbabilityNode.probability(0.010000000000000009, copiedElements != 0)) {
            System.arraycopy(src, srcPos + (copiedElements ^= 0xFFFFFFFF), dest, destPos + copiedElements, length - copiedElements);
        }
    }
}

