/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCompiledCode;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.hotspot.HotSpotCompiledCodeBuilder;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.StubStartNode;
import org.graalvm.compiler.hotspot.stubs.StubCompilationIdentifier;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.profiling.MoveProfilingPhase;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.util.CollectionsUtil;

public abstract class Stub {
    protected final HotSpotForeignCallLinkage linkage;
    protected InstalledCode code;
    private EconomicSet<Register> destroyedCallerRegisters;
    protected final OptionValues options;
    protected final HotSpotProviders providers;
    private static final AtomicInteger nextStubId = new AtomicInteger();

    private static boolean checkRegisterSetEquivalency(EconomicSet<Register> a, EconomicSet<Register> b) {
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        return CollectionsUtil.allMatch(a, e -> b.contains(e));
    }

    public void initDestroyedCallerRegisters(EconomicSet<Register> registers) {
        assert (registers != null);
        assert (this.destroyedCallerRegisters == null || Stub.checkRegisterSetEquivalency(registers, this.destroyedCallerRegisters)) : "cannot redefine";
        this.destroyedCallerRegisters = registers;
    }

    public EconomicSet<Register> getDestroyedCallerRegisters() {
        assert (this.destroyedCallerRegisters != null) : "not yet initialized";
        return this.destroyedCallerRegisters;
    }

    public boolean shouldSaveRegistersAroundCalls() {
        return this.linkage.getEffect() == HotSpotForeignCallLinkage.RegisterEffect.COMPUTES_REGISTERS_KILLED;
    }

    public Stub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        this.linkage = linkage;
        this.options = new OptionValues(options, GraalOptions.TraceInlining, GraalOptions.TraceInliningForStubsAndSnippets.getValue(options), GraalOptions.RegisterPressure, null);
        this.providers = providers;
    }

    public HotSpotForeignCallLinkage getLinkage() {
        return this.linkage;
    }

    public RegisterConfig getRegisterConfig() {
        return null;
    }

    protected abstract StructuredGraph getGraph(DebugContext var1, CompilationIdentifier var2);

    public String toString() {
        return "Stub<" + this.linkage.getDescriptor().getSignature() + ">";
    }

    protected abstract ResolvedJavaMethod getInstalledCodeOwner();

    protected abstract Object debugScopeContext();

    private DebugContext openDebugContext(DebugContext outer) {
        if (DebugOptions.DebugStubsAndSnippets.getValue(this.options).booleanValue()) {
            DebugContext.Description description = new DebugContext.Description(this.linkage, "Stub_" + nextStubId.incrementAndGet());
            GraalDebugHandlersFactory factory = new GraalDebugHandlersFactory(this.providers.getSnippetReflection());
            return new DebugContext.Builder(this.options, factory).globalMetrics(outer.getGlobalMetrics()).description(description).build();
        }
        return DebugContext.disabled(this.options);
    }

    public synchronized InstalledCode getCode(Backend backend) {
        if (this.code == null) {
            try (DebugContext debug = this.openDebugContext(DebugContext.forCurrentThread());){
                try (DebugContext.Scope d = debug.scope("CompilingStub", this.providers.getCodeCache(), this.debugScopeContext());){
                    HotSpotCodeCacheProvider codeCache = this.providers.getCodeCache();
                    CompilationResult compResult = this.buildCompilationResult(debug, backend);
                    try (DebugContext.Scope s = debug.scope((Object)"CodeInstall", compResult);
                         DebugContext.Activation a = debug.activate();){
                        assert (this.destroyedCallerRegisters != null);
                        HotSpotCompiledCode compiledCode = HotSpotCompiledCodeBuilder.createCompiledCode((CodeCacheProvider)codeCache, null, null, compResult, this.options);
                        this.code = codeCache.installCode(null, (CompiledCode)compiledCode, null, null, false);
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                }
                catch (Throwable e) {
                    throw debug.handle(e);
                }
                assert (this.code != null) : "error installing stub " + this;
            }
        }
        return this.code;
    }

    private CompilationResult buildCompilationResult(DebugContext debug, Backend backend) {
        CompilationIdentifier compilationId = this.getStubCompilationId();
        StructuredGraph graph = this.getGraph(debug, compilationId);
        CompilationResult compResult = new CompilationResult(compilationId, this.toString());
        assert (graph.getAssumptions() == null);
        if (!(graph.start() instanceof StubStartNode)) {
            StubStartNode newStart = graph.add(new StubStartNode(this));
            newStart.setStateAfter(graph.start().stateAfter());
            graph.replaceFixed(graph.start(), newStart);
        }
        try (DebugContext.Scope s0 = debug.scope("StubCompilation", graph, this.providers.getCodeCache());){
            Suites suites = this.createSuites();
            GraalCompiler.emitFrontEnd(this.providers, backend, graph, this.providers.getSuites().getDefaultGraphBuilderSuite(), OptimisticOptimizations.ALL, DefaultProfilingInfo.get((TriState)TriState.UNKNOWN), suites);
            LIRSuites lirSuites = this.createLIRSuites();
            backend.emitBackEnd(graph, this, this.getInstalledCodeOwner(), compResult, CompilationResultBuilderFactory.Default, this.getRegisterConfig(), lirSuites);
            assert (this.checkStubInvariants(compResult));
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return compResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompilationResult getCompilationResult(DebugContext debug, Backend backend) {
        try (DebugContext.Scope d = debug.scope("CompilingStub", this.providers.getCodeCache(), this.debugScopeContext());){
            CompilationResult compilationResult = this.buildCompilationResult(debug, backend);
            return compilationResult;
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    public CompilationIdentifier getStubCompilationId() {
        return new StubCompilationIdentifier(this);
    }

    private boolean checkStubInvariants(CompilationResult compResult) {
        assert (compResult.getExceptionHandlers().isEmpty()) : this;
        assert (compResult.getAssumptions() == null) : "stubs should not use assumptions: " + this;
        for (DataPatch data : compResult.getDataPatches()) {
            HotSpotMetaspaceConstant c;
            ConstantReference ref;
            if (data.reference instanceof ConstantReference && (ref = (ConstantReference)data.reference).getConstant() instanceof HotSpotMetaspaceConstant && (c = (HotSpotMetaspaceConstant)ref.getConstant()).asResolvedJavaType() != null && c.asResolvedJavaType().getName().equals("[I")) continue;
            this.checkSafeDataReference(data);
        }
        for (Infopoint infopoint : compResult.getInfopoints()) {
            assert (infopoint instanceof Call) : this + " cannot have non-call infopoint: " + infopoint;
            Call call = (Call)infopoint;
            assert (call.target instanceof HotSpotForeignCallLinkage) : this + " cannot have non runtime call: " + call.target;
            HotSpotForeignCallLinkage callLinkage = (HotSpotForeignCallLinkage)call.target;
            assert (!callLinkage.isCompiledStub() || callLinkage.getDescriptor().equals(HotSpotHostBackend.DEOPT_BLOB_UNCOMMON_TRAP)) : this + " cannot call compiled stub " + callLinkage;
        }
        return true;
    }

    protected void checkSafeDataReference(DataPatch data) {
        assert (!(data.reference instanceof ConstantReference)) : this + " cannot have embedded object or metadata constant: " + data.reference;
    }

    protected Suites createSuites() {
        Suites defaultSuites = this.providers.getSuites().getDefaultSuites(this.options);
        return new Suites(new PhaseSuite<HighTierContext>(), defaultSuites.getMidTier(), defaultSuites.getLowTier());
    }

    protected LIRSuites createLIRSuites() {
        LIRSuites lirSuites = new LIRSuites(this.providers.getSuites().getDefaultLIRSuites(this.options));
        ListIterator<LIRPhase<PostAllocationOptimizationPhase.PostAllocationOptimizationContext>> moveProfiling = lirSuites.getPostAllocationOptimizationStage().findPhase(MoveProfilingPhase.class);
        if (moveProfiling != null) {
            moveProfiling.remove();
        }
        return lirSuites;
    }
}

