/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.vector.AVX512Support;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AMD64VectorShuffle {

    public static final class ExtractLongOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ExtractLongOp> TYPE = LIRInstructionClass.create(ExtractLongOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue vector;
        private final int selector;

        public ExtractLongOp(AllocatableValue result, AllocatableValue vector, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (result.getPlatformKind() == AMD64Kind.QWORD);
            assert (((AMD64Kind)vector.getPlatformKind()).getScalar() == AMD64Kind.QWORD);
            this.result = result;
            this.vector = vector;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                if (this.selector == 0) {
                    AMD64Assembler.VexMoveOp.VMOVQ.emitReverse(masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector));
                } else {
                    AMD64Assembler.VexMRIOp.VPEXTRQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                if (this.selector == 0) {
                    AMD64Assembler.VexMoveOp.VMOVQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.vector));
                } else {
                    AMD64Assembler.VexMRIOp.VPEXTRQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
                }
            }
        }
    }

    public static final class ExtractIntOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ExtractIntOp> TYPE = LIRInstructionClass.create(ExtractIntOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue vector;
        private final int selector;

        public ExtractIntOp(AllocatableValue result, AllocatableValue vector, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (result.getPlatformKind() == AMD64Kind.DWORD);
            assert (((AMD64Kind)vector.getPlatformKind()).getScalar() == AMD64Kind.DWORD);
            this.result = result;
            this.vector = vector;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                if (this.selector == 0) {
                    AMD64Assembler.VexMoveOp.VMOVD.emitReverse(masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector));
                } else {
                    AMD64Assembler.VexMRIOp.VPEXTRD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                if (this.selector == 0) {
                    AMD64Assembler.VexMoveOp.VMOVD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.vector));
                } else {
                    AMD64Assembler.VexMRIOp.VPEXTRD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
                }
            }
        }
    }

    public static final class ExtractShortOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ExtractShortOp> TYPE = LIRInstructionClass.create(ExtractShortOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue vector;
        private final int selector;

        public ExtractShortOp(AllocatableValue result, AllocatableValue vector, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (result.getPlatformKind() == AMD64Kind.DWORD);
            assert (((AMD64Kind)vector.getPlatformKind()).getScalar() == AMD64Kind.WORD);
            this.result = result;
            this.vector = vector;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexMRIOp.VPEXTRW.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
        }
    }

    public static final class ExtractByteOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ExtractByteOp> TYPE = LIRInstructionClass.create(ExtractByteOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue vector;
        private final int selector;

        public ExtractByteOp(AllocatableValue result, AllocatableValue vector, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (result.getPlatformKind() == AMD64Kind.DWORD);
            assert (((AMD64Kind)vector.getPlatformKind()).getScalar() == AMD64Kind.BYTE);
            this.result = result;
            this.vector = vector;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexMRIOp.VPEXTRB.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.vector), this.selector);
        }
    }

    public static final class Insert256Op
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<Insert256Op> TYPE = LIRInstructionClass.create(Insert256Op.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue source2;
        private final int selector;

        public Insert256Op(AllocatableValue result, AllocatableValue source1, AllocatableValue source2, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source1 = source1;
            this.source2 = source2;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexRVMIOp op;
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            assert (AVXKind.getRegisterSize(kind) == AVXKind.AVXSize.ZMM) : "Can only extract 256 bits from ZMM register";
            switch (kind.getScalar()) {
                case DOUBLE: {
                    op = AMD64Assembler.VexRVMIOp.VINSERTF64X4;
                    break;
                }
                case DWORD: {
                    op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexRVMIOp.VINSERTI32X8 : AMD64Assembler.VexRVMIOp.VINSERTI64X4;
                    break;
                }
                case QWORD: {
                    op = AMD64Assembler.VexRVMIOp.VINSERTI64X4;
                    break;
                }
                default: {
                    AMD64Assembler.VexRVMIOp vexRVMIOp = op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexRVMIOp.VINSERTF32X8 : AMD64Assembler.VexRVMIOp.VINSERTF64X4;
                }
            }
            if (ValueUtil.isRegister((Value)this.source2)) {
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), ValueUtil.asRegister((Value)this.source2), this.selector);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.source2));
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), (AMD64Address)crb.asAddress((Value)this.source2), this.selector);
            }
        }
    }

    public static final class Insert128Op
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<Insert128Op> TYPE = LIRInstructionClass.create(Insert128Op.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue source2;
        private final int selector;

        public Insert128Op(AllocatableValue result, AllocatableValue source1, AllocatableValue source2, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source1 = source1;
            this.source2 = source2;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexRVMIOp op;
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            AVXKind.AVXSize size = AVXKind.getRegisterSize(kind);
            block0 : switch (size) {
                case YMM: {
                    switch (kind.getScalar()) {
                        case SINGLE: 
                        case DOUBLE: {
                            op = AMD64Assembler.VexRVMIOp.VINSERTF128;
                            break block0;
                        }
                    }
                    op = masm.supports(AMD64.CPUFeature.AVX2) ? AMD64Assembler.VexRVMIOp.VINSERTI128 : AMD64Assembler.VexRVMIOp.VINSERTF128;
                    break;
                }
                case ZMM: {
                    switch (kind.getScalar()) {
                        case DOUBLE: {
                            op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexRVMIOp.VINSERTF64X2 : AMD64Assembler.VexRVMIOp.VINSERTF32X4;
                            break block0;
                        }
                        case DWORD: {
                            op = AMD64Assembler.VexRVMIOp.VINSERTI32X4;
                            break block0;
                        }
                        case QWORD: {
                            op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexRVMIOp.VINSERTI64X2 : AMD64Assembler.VexRVMIOp.VINSERTI32X4;
                            break block0;
                        }
                    }
                    op = AMD64Assembler.VexRVMIOp.VINSERTF32X4;
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("Unexpected vector size for extract-128-bits op" + (Object)((Object)size));
                }
            }
            if (ValueUtil.isRegister((Value)this.source2)) {
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), ValueUtil.asRegister((Value)this.source2), this.selector);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.source2));
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), (AMD64Address)crb.asAddress((Value)this.source2), this.selector);
            }
        }
    }

    public static class Extract256Op
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<Extract256Op> TYPE = LIRInstructionClass.create(Extract256Op.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source;
        private final int selector;

        public Extract256Op(AllocatableValue result, AllocatableValue source, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexMRIOp op;
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            assert (AVXKind.getRegisterSize(kind) == AVXKind.AVXSize.ZMM) : "Can only extract 256 bits from ZMM register";
            switch (kind.getScalar()) {
                case DOUBLE: {
                    op = AMD64Assembler.VexMRIOp.VEXTRACTF64X4;
                    break;
                }
                case DWORD: {
                    op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexMRIOp.VEXTRACTI32X8 : AMD64Assembler.VexMRIOp.VEXTRACTI64X4;
                    break;
                }
                case QWORD: {
                    op = AMD64Assembler.VexMRIOp.VEXTRACTI64X4;
                    break;
                }
                default: {
                    AMD64Assembler.VexMRIOp vexMRIOp = op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexMRIOp.VEXTRACTF32X8 : AMD64Assembler.VexMRIOp.VEXTRACTF64X4;
                }
            }
            if (ValueUtil.isRegister((Value)this.result)) {
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector);
            }
        }
    }

    public static final class Extract128Op
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<Extract128Op> TYPE = LIRInstructionClass.create(Extract128Op.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source;
        private final int selector;

        public Extract128Op(AllocatableValue result, AllocatableValue source, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexMRIOp op;
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            AVXKind.AVXSize size = AVXKind.getRegisterSize(kind);
            block0 : switch (size) {
                case YMM: {
                    switch (kind.getScalar()) {
                        case SINGLE: 
                        case DOUBLE: {
                            op = AMD64Assembler.VexMRIOp.VEXTRACTF128;
                            break block0;
                        }
                    }
                    op = masm.supports(AMD64.CPUFeature.AVX2) ? AMD64Assembler.VexMRIOp.VEXTRACTI128 : AMD64Assembler.VexMRIOp.VEXTRACTF128;
                    break;
                }
                case ZMM: {
                    switch (kind.getScalar()) {
                        case DOUBLE: {
                            op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexMRIOp.VEXTRACTF64X2 : AMD64Assembler.VexMRIOp.VEXTRACTF32X4;
                            break block0;
                        }
                        case DWORD: {
                            op = AMD64Assembler.VexMRIOp.VEXTRACTI32X4;
                            break block0;
                        }
                        case QWORD: {
                            op = masm.supports(AMD64.CPUFeature.AVX512DQ) ? AMD64Assembler.VexMRIOp.VEXTRACTI64X2 : AMD64Assembler.VexMRIOp.VEXTRACTI32X4;
                            break block0;
                        }
                    }
                    op = AMD64Assembler.VexMRIOp.VEXTRACTF32X4;
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("Unexpected vector size for extract-128-bits op" + (Object)((Object)size));
                }
            }
            if (ValueUtil.isRegister((Value)this.result)) {
                op.emit((AMD64Assembler)masm, size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                op.emit((AMD64Assembler)masm, size, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector);
            }
        }
    }

    public static class ShuffleFloatOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ShuffleFloatOp> TYPE = LIRInstructionClass.create(ShuffleFloatOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue source2;
        private final int selector;

        public ShuffleFloatOp(AllocatableValue result, AllocatableValue source1, AllocatableValue source2, int selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source1 = source1;
            this.source2 = source2;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexRVMIOp op;
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            switch (kind.getScalar()) {
                case SINGLE: {
                    op = AMD64Assembler.VexRVMIOp.VSHUFPS;
                    break;
                }
                case DOUBLE: {
                    op = AMD64Assembler.VexRVMIOp.VSHUFPD;
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
            if (ValueUtil.isRegister((Value)this.source2)) {
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), ValueUtil.asRegister((Value)this.source2), this.selector);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.source2));
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source1), (AMD64Address)crb.asAddress((Value)this.source2), this.selector);
            }
        }
    }

    public static class ShuffleWordOpWithMask
    extends ShuffleWordOp
    implements AVX512Support {
        public static final LIRInstructionClass<ShuffleWordOpWithMask> TYPE = LIRInstructionClass.create(ShuffleWordOpWithMask.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;

        public ShuffleWordOpWithMask(AMD64Assembler.VexRMIOp op, AllocatableValue result, AllocatableValue source, int selector, AllocatableValue mask) {
            super(TYPE, op, result, source, selector);
            this.mask = mask;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            if (ValueUtil.isRegister((Value)this.source)) {
                this.op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector, ValueUtil.asRegister((Value)this.mask), 1, 0);
            } else {
                this.op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.source), this.selector, ValueUtil.asRegister((Value)this.mask), 1, 0);
            }
        }

        @Override
        public AllocatableValue getOpmask() {
            return this.mask;
        }
    }

    public static class ShuffleWordOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ShuffleWordOp> TYPE = LIRInstructionClass.create(ShuffleWordOp.class);
        protected final AMD64Assembler.VexRMIOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue source;
        protected final int selector;

        public ShuffleWordOp(AMD64Assembler.VexRMIOp op, AllocatableValue result, AllocatableValue source, int selector) {
            this(TYPE, op, result, source, selector);
        }

        protected ShuffleWordOp(LIRInstructionClass<? extends AMD64LIRInstruction> c, AMD64Assembler.VexRMIOp op, AllocatableValue result, AllocatableValue source, int selector) {
            super(c);
            this.op = op;
            this.result = result;
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            if (ValueUtil.isRegister((Value)this.source)) {
                this.op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), this.selector);
            } else {
                this.op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.source), this.selector);
            }
        }
    }

    public static final class ConstShuffleBytesOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ConstShuffleBytesOp> TYPE = LIRInstructionClass.create(ConstShuffleBytesOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source;
        private final byte[] selector;

        public ConstShuffleBytesOp(AllocatableValue result, AllocatableValue source, byte ... selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (AVXKind.getRegisterSize((AMD64Kind)source.getPlatformKind()).getBytes() == selector.length) : " Register size=" + AVXKind.getRegisterSize((AMD64Kind)source.getPlatformKind()).getBytes() + " select length=" + selector.length;
            this.result = result;
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            int alignment = crb.dataBuilder.ensureValidDataAlignment(this.selector.length);
            AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(this.selector, alignment);
            AMD64Assembler.VexRVMOp.VPSHUFB.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), address);
        }
    }

    public static final class ConstPermuteBytesUsingTableOp
    extends AMD64LIRInstruction
    implements AVX512Support {
        public static final LIRInstructionClass<ConstPermuteBytesUsingTableOp> TYPE = LIRInstructionClass.create(ConstPermuteBytesUsingTableOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue source;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue selector;
        byte[] selectorData;

        public ConstPermuteBytesUsingTableOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue source, byte[] selectorData) {
            this(tool, result, source, selectorData, null);
        }

        public ConstPermuteBytesUsingTableOp(LIRGeneratorTool tool, AllocatableValue result, AllocatableValue source, byte[] selectorData, AllocatableValue mask) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source = source;
            this.selectorData = selectorData;
            this.selector = tool.newVariable(LIRKind.value(source.getPlatformKind()));
            this.mask = mask;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.source.getPlatformKind();
            int alignment = crb.dataBuilder.ensureValidDataAlignment(this.selectorData.length);
            AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(this.selectorData, alignment);
            AMD64Assembler.VexMoveOp.VMOVDQU64.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.selector), address);
            if (ValueUtil.isRegister((Value)this.source)) {
                AMD64Assembler.VexRVMOp.VPERMT2B.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.selector), ValueUtil.asRegister((Value)this.source), this.mask != null ? ValueUtil.asRegister((Value)this.mask) : Register.None, 1, 0);
            } else {
                AMD64Assembler.VexRVMOp.VPERMT2B.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.selector), (AMD64Address)crb.asAddress((Value)this.source), this.mask != null ? ValueUtil.asRegister((Value)this.mask) : Register.None, 1, 0);
            }
        }

        @Override
        public AllocatableValue getOpmask() {
            return this.mask;
        }
    }

    public static final class ShuffleBytesOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<ShuffleBytesOp> TYPE = LIRInstructionClass.create(ShuffleBytesOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue source;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue selector;

        public ShuffleBytesOp(AllocatableValue result, AllocatableValue source, AllocatableValue selector) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.source = source;
            this.selector = selector;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            if (ValueUtil.isRegister((Value)this.selector)) {
                AMD64Assembler.VexRVMOp.VPSHUFB.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), ValueUtil.asRegister((Value)this.selector));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.selector));
                AMD64Assembler.VexRVMOp.VPSHUFB.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.source), (AMD64Address)crb.asAddress((Value)this.selector));
            }
        }
    }

    public static final class LongToVectorOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<LongToVectorOp> TYPE = LIRInstructionClass.create(LongToVectorOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue value;

        public LongToVectorOp(AllocatableValue result, AllocatableValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (result.getPlatformKind() == AMD64Kind.V128_QWORD || result.getPlatformKind() == AMD64Kind.V256_QWORD);
            this.result = result;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.value)) {
                AMD64Assembler.VexMoveOp.VMOVQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.value));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.value));
                AMD64Assembler.VexMoveOp.VMOVQ.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.value));
            }
        }
    }

    public static final class IntToVectorOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<IntToVectorOp> TYPE = LIRInstructionClass.create(IntToVectorOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue value;

        public IntToVectorOp(AllocatableValue result, AllocatableValue value) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            assert (((AMD64Kind)result.getPlatformKind()).getScalar().isInteger()) : result.getPlatformKind();
            this.result = result;
            this.value = value;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.value)) {
                AMD64Assembler.VexMoveOp.VMOVD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.value));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.value));
                AMD64Assembler.VexMoveOp.VMOVD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.value));
            }
        }
    }
}

