/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.DeoptBciSupplier;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.StructuredGraph;

public interface Invokable
extends DeoptBciSupplier {
    public ResolvedJavaMethod getTargetMethod();

    public ResolvedJavaMethod getContextMethod();

    default public FixedNode asFixedNodeOrNull() {
        return this instanceof FixedNode ? (FixedNode)((Object)this) : null;
    }

    default public void updateInliningLogAfterRegister(StructuredGraph newGraph) {
        InliningLog log = newGraph.getInliningLog();
        if (log.getUpdateScope() != null) {
            log.getUpdateScope().accept(null, this);
        } else {
            if (!1.$assertionsDisabled && log.containsLeafCallsite(this)) {
                throw new AssertionError();
            }
            log.trackNewCallsite(this);
        }
    }

    default public void updateInliningLogAfterClone(Node other) {
        StructuredGraph graph = this.asFixedNodeOrNull().graph();
        if (GraalOptions.TraceInlining.getValue(graph.getOptions()).booleanValue()) {
            InliningLog log = graph.getInliningLog();
            if (!1.$assertionsDisabled && !(other instanceof Invokable)) {
                throw new AssertionError();
            }
            if (log.getUpdateScope() != null) {
                log.getUpdateScope().accept((Invokable)((Object)other), this);
            } else if (other.graph() == graph) {
                if (!1.$assertionsDisabled && !log.containsLeafCallsite(this)) {
                    throw new AssertionError((Object)("Node " + this + " not contained in the log."));
                }
                if (!1.$assertionsDisabled && !log.containsLeafCallsite((Invokable)((Object)other))) {
                    throw new AssertionError((Object)("Sibling " + other + " not contained in the log."));
                }
                log.removeLeafCallsite(this);
                log.trackDuplicatedCallsite((Invokable)((Object)other), this);
            } else {
                throw GraalError.shouldNotReachHere("No InliningLog.Update scope provided.");
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

