/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Map;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.PluginReplacementInterface;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginInjectionProvider;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

@NodeInfo(nameTemplate="PluginReplacement/{p#pluginName}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class PluginReplacementNode
extends FixedWithNextNode
implements PluginReplacementInterface {
    public static final NodeClass<PluginReplacementNode> TYPE = NodeClass.create(PluginReplacementNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> args;
    private final ReplacementFunction function;
    private final String pluginName;

    public PluginReplacementNode(Stamp stamp, ValueNode[] args, ReplacementFunction function, String pluginName) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.args = new NodeInputList((Node)this, (Node[])args);
        this.function = function;
        this.pluginName = pluginName;
    }

    @Override
    public boolean replace(GraphBuilderContext b, GeneratedPluginInjectionProvider injection) {
        return this.function.replace(b, injection, this.stamp, this.args);
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Short) {
            return super.toString(verbosity) + "/" + this.pluginName;
        }
        return super.toString(verbosity);
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        map.put("name", this.pluginName);
        return super.getDebugProperties(map);
    }

    public static interface ReplacementFunction {
        public boolean replace(GraphBuilderContext var1, GeneratedPluginInjectionProvider var2, Stamp var3, NodeInputList<ValueNode> var4);
    }
}

