/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Arrays;

public abstract class ProfileData {
    protected final ProfileSource profileSource;

    protected ProfileData(ProfileSource profileSource) {
        this.profileSource = profileSource;
    }

    public ProfileSource getProfileSource() {
        return this.profileSource;
    }

    public static final class SwitchProbabilityData
    extends ProfileData {
        private final double[] keyProbabilities;

        private SwitchProbabilityData(double[] keyProbabilities, ProfileSource profileSource) {
            super(profileSource);
            this.keyProbabilities = keyProbabilities;
        }

        public static SwitchProbabilityData create(double[] keyProbabilities, ProfileSource profileSource) {
            return new SwitchProbabilityData(keyProbabilities, profileSource);
        }

        public double[] getKeyProbabilities() {
            return this.keyProbabilities;
        }

        public SwitchProbabilityData copy(double[] newKeyProbabilities) {
            return new SwitchProbabilityData(newKeyProbabilities, this.profileSource);
        }

        public static SwitchProbabilityData profiled(double[] keyProbabilities) {
            return new SwitchProbabilityData(keyProbabilities, ProfileSource.PROFILED);
        }

        public static SwitchProbabilityData unknown(double[] keyProbabilities) {
            return new SwitchProbabilityData(keyProbabilities, ProfileSource.UNKNOWN);
        }

        public String toString() {
            return (Object)((Object)this.profileSource) + " keyProbabilities: " + Arrays.toString(this.keyProbabilities);
        }
    }

    public static final class LoopFrequencyData
    extends ProfileData {
        private final double loopFrequency;
        public static final LoopFrequencyData DEFAULT = new LoopFrequencyData(1.0, ProfileSource.UNKNOWN);

        private LoopFrequencyData(double loopFrequency, ProfileSource profileSource) {
            super(profileSource);
            assert (loopFrequency >= 1.0);
            this.loopFrequency = loopFrequency;
        }

        public static LoopFrequencyData create(double loopFrequency, ProfileSource profileSource) {
            if (loopFrequency == 1.0 && profileSource == ProfileSource.UNKNOWN) {
                return DEFAULT;
            }
            return new LoopFrequencyData(loopFrequency, profileSource);
        }

        public double getLoopFrequency() {
            return this.loopFrequency;
        }

        public static LoopFrequencyData injected(double loopFrequency) {
            return LoopFrequencyData.create(loopFrequency, ProfileSource.INJECTED);
        }

        public static LoopFrequencyData unknown(double loopFrequency) {
            return LoopFrequencyData.create(loopFrequency, ProfileSource.UNKNOWN);
        }

        public LoopFrequencyData copy(double newFrequency) {
            return LoopFrequencyData.create(newFrequency, this.getProfileSource());
        }

        public LoopFrequencyData decrementFrequency(double decrement) {
            double newFrequency = Math.max(1.0, this.getLoopFrequency() - decrement);
            return this.copy(newFrequency);
        }

        public LoopFrequencyData scaleFrequency(double scaleFactor) {
            double newFrequency = Math.max(1.0, this.getLoopFrequency() * scaleFactor);
            return this.copy(newFrequency);
        }

        public String toString() {
            return (Object)((Object)this.profileSource) + " loopFrequency: " + this.loopFrequency;
        }
    }

    public static final class BranchProbabilityData
    extends ProfileData {
        private final double designatedSuccessorProbability;
        private static final BranchProbabilityData UNKNOWN_BRANCH_PROFILE = new BranchProbabilityData(0.5, ProfileSource.UNKNOWN);

        private BranchProbabilityData(double designatedSuccessorProbability, ProfileSource profileSource) {
            super(profileSource);
            this.designatedSuccessorProbability = designatedSuccessorProbability;
        }

        public static BranchProbabilityData create(double designatedSuccessorProbability, ProfileSource profileSource) {
            if (designatedSuccessorProbability == 0.5 && profileSource == ProfileSource.UNKNOWN) {
                return UNKNOWN_BRANCH_PROFILE;
            }
            return new BranchProbabilityData(designatedSuccessorProbability, profileSource);
        }

        public double getDesignatedSuccessorProbability() {
            return this.designatedSuccessorProbability;
        }

        public double getNegatedProbability() {
            return 1.0 - this.designatedSuccessorProbability;
        }

        public BranchProbabilityData copy(double newProbability) {
            if (newProbability == this.designatedSuccessorProbability) {
                return this;
            }
            return BranchProbabilityData.create(newProbability, this.profileSource);
        }

        public BranchProbabilityData negated() {
            return this.copy(this.getNegatedProbability());
        }

        public static BranchProbabilityData injected(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.INJECTED);
        }

        public static BranchProbabilityData injected(double probability, boolean negated) {
            return negated ? BranchProbabilityData.injected(1.0 - probability) : BranchProbabilityData.injected(probability);
        }

        public static BranchProbabilityData profiled(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.PROFILED);
        }

        public static BranchProbabilityData unknown() {
            return UNKNOWN_BRANCH_PROFILE;
        }

        public static BranchProbabilityData unknown(double probability) {
            return BranchProbabilityData.create(probability, ProfileSource.UNKNOWN);
        }

        public static BranchProbabilityData combineShortCircuitOr(BranchProbabilityData a, BranchProbabilityData b) {
            double p1 = a.getDesignatedSuccessorProbability();
            double p2 = b.getDesignatedSuccessorProbability();
            double combinedProbability = p1 + (1.0 - p1) * p2;
            ProfileSource combinedSource = a.getProfileSource().combine(b.getProfileSource());
            return BranchProbabilityData.create(combinedProbability, combinedSource);
        }

        public BranchProbabilityData combineAndWithNegated(BranchProbabilityData other) {
            double p = this.getDesignatedSuccessorProbability() * other.getNegatedProbability();
            return BranchProbabilityData.create(p, this.getProfileSource().combine(other.profileSource));
        }

        public String toString() {
            return (Object)((Object)this.profileSource) + " designatedSuccessorProbability: " + this.designatedSuccessorProbability;
        }
    }

    public static enum ProfileSource {
        INJECTED,
        PROFILED,
        UNKNOWN;


        public ProfileSource combine(ProfileSource other) {
            if (this.ordinal() < other.ordinal()) {
                return this;
            }
            return other;
        }

        public static boolean isTrusted(ProfileSource source) {
            return source == INJECTED || source == PROFILED;
        }
    }
}

