/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.UnaryArithmeticNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8)
public final class FloatConvertNode
extends UnaryArithmeticNode<ArithmeticOpTable.FloatConvertOp>
implements ConvertNode,
Lowerable,
ArithmeticLIRLowerable {
    public static final NodeClass<FloatConvertNode> TYPE = NodeClass.create(FloatConvertNode.class);
    protected final FloatConvert op;

    public FloatConvertNode(FloatConvert op, ValueNode input) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getFloatConvert(op), input);
        this.op = op;
    }

    public static ValueNode create(FloatConvert op, ValueNode input, NodeView view) {
        ValueNode synonym = FloatConvertNode.findSynonym(input, ArithmeticOpTable.forStamp(input.stamp(view)).getFloatConvert(op));
        if (synonym != null) {
            return synonym;
        }
        return new FloatConvertNode(op, input);
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.FloatConvertOp> getOp(ArithmeticOpTable table) {
        return table.getFloatConvert(this.op);
    }

    public FloatConvert getFloatConvert() {
        return this.op;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        return ((ArithmeticOpTable.UnaryOp)this.getArithmeticOp()).foldConstant(c);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        ArithmeticOpTable.FloatConvertOp reverse = ArithmeticOpTable.forStamp(this.stamp(NodeView.DEFAULT)).getFloatConvert(this.op.reverse());
        return reverse.foldConstant(c);
    }

    @Override
    public boolean isLossless() {
        switch (this.getFloatConvert()) {
            case F2D: 
            case I2D: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        FloatConvertNode other;
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        if (forValue instanceof FloatConvertNode && (other = (FloatConvertNode)forValue).isLossless() && other.op == this.op.reverse()) {
            return other.getValue();
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitFloatConvert(this.getFloatConvert(), nodeValueMap.operand(this.getValue())));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }
}

