/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.MaxNode;
import org.graalvm.compiler.nodes.calc.MinNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(shortName="MinMax")
public abstract class MinMaxNode<OP>
extends BinaryArithmeticNode<OP>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<MinMaxNode> TYPE = NodeClass.create(MinMaxNode.class);

    protected MinMaxNode(NodeClass<? extends BinaryArithmeticNode<OP>> c, ArithmeticOpTable.BinaryOp<OP> opForStampComputation, ValueNode x, ValueNode y) {
        super(c, opForStampComputation, x, y);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode result;
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        NodeView view = NodeView.from(tool);
        if (forX.isConstant()) {
            ValueNode result2 = this.tryCanonicalizeWithConstantInput(forX, forY);
            if (result2 != this) {
                return result2;
            }
        } else if (forY.isConstant() && (result = this.tryCanonicalizeWithConstantInput(forY, forX)) != this) {
            return result;
        }
        return MinMaxNode.reassociateMatchedValues(this, ValueNode.isConstantPredicate(), forX, forY, view);
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        Value op1 = nodeValueMap.operand(this.getX());
        assert (op1 != null) : this.getX() + ", this=" + this;
        Value op2 = nodeValueMap.operand(this.getY());
        if (this.shouldSwapInputs(nodeValueMap)) {
            Value tmp = op1;
            op1 = op2;
            op2 = tmp;
        }
        if (this instanceof MaxNode) {
            nodeValueMap.setResult(this, gen.emitMathMax(op1, op2));
        } else if (this instanceof MinNode) {
            nodeValueMap.setResult(this, gen.emitMathMin(op1, op2));
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    private ValueNode tryCanonicalizeWithConstantInput(ValueNode constantValue, ValueNode otherValue) {
        if (constantValue.isJavaConstant()) {
            JavaConstant constant = constantValue.asJavaConstant();
            JavaKind kind = constant.getJavaKind();
            assert (kind == JavaKind.Float || kind == JavaKind.Double);
            if (kind == JavaKind.Float && Float.isNaN(constant.asFloat()) || kind == JavaKind.Double && Double.isNaN(constant.asDouble())) {
                return constantValue;
            }
            if (this instanceof MaxNode ? kind == JavaKind.Float && constant.asFloat() == Float.NEGATIVE_INFINITY || kind == JavaKind.Double && constant.asDouble() == Double.NEGATIVE_INFINITY : this instanceof MinNode && (kind == JavaKind.Float && constant.asFloat() == Float.POSITIVE_INFINITY || kind == JavaKind.Double && constant.asDouble() == Double.POSITIVE_INFINITY)) {
                return otherValue;
            }
        }
        return this;
    }
}

