/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public abstract class AbstractBoxingNode
extends FixedWithNextNode
implements Virtualizable,
Lowerable,
Canonicalizable.Unary<ValueNode>,
MemoryAccess {
    public static final NodeClass<AbstractBoxingNode> TYPE = NodeClass.create(AbstractBoxingNode.class);
    @Node.Input
    protected ValueNode value;
    protected final JavaKind boxingKind;
    protected final LocationIdentity accessedLocation;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill lastLocationAccess;

    public AbstractBoxingNode(NodeClass<? extends AbstractBoxingNode> c, ValueNode value, JavaKind boxingKind, Stamp s, LocationIdentity accessedLocation) {
        super((NodeClass<? extends FixedWithNextNode>)c, s);
        this.value = value;
        this.boxingKind = boxingKind;
        this.accessedLocation = accessedLocation;
    }

    public static ResolvedJavaField getValueField(ResolvedJavaType resultType) {
        for (ResolvedJavaField f : resultType.getInstanceFields(false)) {
            if (!f.getName().equals("value")) continue;
            return f;
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public ValueNode getValue() {
        return this.value;
    }

    public JavaKind getBoxingKind() {
        return this.boxingKind;
    }

    @Override
    public MemoryKill getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryKill newlla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(newlla));
        this.lastLocationAccess = newlla;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.accessedLocation;
    }
}

