/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import java.util.ArrayList;
import java.util.Arrays;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo
public final class TypeSwitchNode
extends SwitchNode
implements LIRLowerable,
Simplifiable {
    public static final NodeClass<TypeSwitchNode> TYPE = NodeClass.create(TypeSwitchNode.class);
    protected final ResolvedJavaType[] keys;
    protected final Constant[] hubs;

    public TypeSwitchNode(ValueNode value, AbstractBeginNode[] successors, ResolvedJavaType[] keys, int[] keySuccessors, ConstantReflectionProvider constantReflection, ProfileData.SwitchProbabilityData profileData) {
        super(TYPE, value, successors, keySuccessors, profileData);
        assert (successors.length <= keys.length + 1);
        assert (keySuccessors.length == profileData.getKeyProbabilities().length);
        this.keys = keys;
        assert (value.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp);
        assert (this.assertKeys());
        this.hubs = new Constant[keys.length];
        for (int i = 0; i < this.hubs.length; ++i) {
            this.hubs[i] = constantReflection.asObjectHub(keys[i]);
        }
    }

    private boolean assertKeys() {
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = 0; j < this.keys.length; ++j) {
                if (i != j) assert (!this.keys[i].equals(this.keys[j]));
            }
        }
        return true;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public int keyCount() {
        return this.keys.length;
    }

    @Override
    public Constant keyAt(int index) {
        return this.hubs[index];
    }

    @Override
    public boolean equalKeys(SwitchNode switchNode) {
        if (!(switchNode instanceof TypeSwitchNode)) {
            return false;
        }
        TypeSwitchNode other = (TypeSwitchNode)switchNode;
        return Arrays.equals(this.keys, other.keys);
    }

    public ResolvedJavaType typeAt(int index) {
        return this.keys[index];
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.emitSwitch(this);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        ObjectStamp objectStamp;
        int i;
        NodeView view = NodeView.from(tool);
        if (this.value() instanceof ConstantNode) {
            Constant constant = this.value().asConstant();
            int survivingEdge = this.keySuccessorIndex(this.keyCount());
            for (i = 0; i < this.keyCount(); ++i) {
                Constant typeHub = this.keyAt(i);
                Boolean equal = tool.getConstantReflection().constantEquals(constant, typeHub);
                if (equal == null) {
                    return;
                }
                if (!equal.booleanValue()) continue;
                survivingEdge = this.keySuccessorIndex(i);
            }
            this.killOtherSuccessors(tool, survivingEdge);
        }
        if (this.value() instanceof LoadHubNode && ((LoadHubNode)this.value()).getValue().stamp(view) instanceof ObjectStamp && (objectStamp = (ObjectStamp)((LoadHubNode)this.value()).getValue().stamp(view)).type() != null) {
            int validKeys = 0;
            for (i = 0; i < this.keyCount(); ++i) {
                if (!objectStamp.type().isAssignableFrom(this.keys[i])) continue;
                ++validKeys;
            }
            if (validKeys == 0) {
                tool.addToWorkList(this.defaultSuccessor());
                this.graph().removeSplitPropagate(this, this.defaultSuccessor());
            } else if (validKeys != this.keys.length) {
                int i2;
                ArrayList<AbstractBeginNode> newSuccessors = new ArrayList<AbstractBeginNode>(this.blockSuccessorCount());
                ResolvedJavaType[] newKeys = new ResolvedJavaType[validKeys];
                int[] newKeySuccessors = new int[validKeys + 1];
                double[] newKeyProbabilities = new double[validKeys + 1];
                double totalProbability = 0.0;
                int current = 0;
                for (i2 = 0; i2 < this.keyCount() + 1; ++i2) {
                    if (i2 != this.keyCount() && !objectStamp.type().isAssignableFrom(this.keys[i2])) continue;
                    int index = newSuccessors.indexOf(this.keySuccessor(i2));
                    if (index == -1) {
                        index = newSuccessors.size();
                        newSuccessors.add(this.keySuccessor(i2));
                    }
                    newKeySuccessors[current] = index;
                    if (i2 < this.keyCount()) {
                        newKeys[current] = this.keys[i2];
                    }
                    newKeyProbabilities[current] = this.keyProbability(i2);
                    totalProbability += this.keyProbability(i2);
                    ++current;
                }
                if (totalProbability > 0.0) {
                    i2 = 0;
                    while (i2 < current) {
                        int n = i2++;
                        newKeyProbabilities[n] = newKeyProbabilities[n] / totalProbability;
                    }
                } else {
                    for (i2 = 0; i2 < current; ++i2) {
                        newKeyProbabilities[i2] = 1.0 / (double)current;
                    }
                }
                ArrayList<AbstractBeginNode> oldSuccessors = new ArrayList<AbstractBeginNode>();
                for (int i3 = 0; i3 < this.blockSuccessorCount(); ++i3) {
                    AbstractBeginNode successor = this.blockSuccessor(i3);
                    oldSuccessors.add(successor);
                    this.setBlockSuccessor(i3, null);
                }
                AbstractBeginNode[] successorsArray = newSuccessors.toArray(new AbstractBeginNode[newSuccessors.size()]);
                TypeSwitchNode newSwitch = this.graph().add(new TypeSwitchNode(this.value(), successorsArray, newKeys, newKeySuccessors, tool.getConstantReflection(), ProfileData.SwitchProbabilityData.create(newKeyProbabilities, this.profileData.getProfileSource())));
                ((FixedWithNextNode)this.predecessor()).setNext(newSwitch);
                GraphUtil.killWithUnusedFloatingInputs(this);
                for (int i4 = 0; i4 < oldSuccessors.size(); ++i4) {
                    AbstractBeginNode successor = (AbstractBeginNode)oldSuccessors.get(i4);
                    if (newSuccessors.contains(successor)) continue;
                    GraphUtil.killCFG(successor);
                }
            }
        }
    }

    @Override
    public Stamp getValueStampForSuccessor(AbstractBeginNode beginNode) {
        Stamp result = null;
        if (beginNode != this.defaultSuccessor()) {
            for (int i = 0; i < this.keyCount(); ++i) {
                if (this.keySuccessor(i) != beginNode) continue;
                result = result == null ? StampFactory.objectNonNull(TypeReference.createExactTrusted(this.typeAt(i))) : ((Stamp)result).meet(StampFactory.objectNonNull(TypeReference.createExactTrusted(this.typeAt(i))));
            }
        }
        return result;
    }
}

