/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="VolatileWrite#{p#location/s}")
public class VolatileWriteNode
extends WriteNode
implements Lowerable,
OrderedMemoryAccess {
    public static final NodeClass<VolatileWriteNode> TYPE = NodeClass.create(VolatileWriteNode.class);

    public VolatileWriteNode(AddressNode address, LocationIdentity location, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, address, location, LocationIdentity.any(), value, barrierType);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitVolatileStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this));
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return MemoryOrderMode.VOLATILE;
    }
}

