/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;

public class OptionKey<T> {
    private final T defaultValue;
    private OptionDescriptor descriptor;

    public OptionKey(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final void setDescriptor(OptionDescriptor descriptor) {
        assert (this.descriptor == null) : "Overwriting existing descriptor";
        this.descriptor = descriptor;
    }

    public final OptionDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected boolean checkDescriptorExists() {
        Lazy.init();
        if (this.descriptor == null) {
            StringBuilder result = new StringBuilder();
            result.append("Could not find a descriptor for an option key. The most likely cause is a dependency on the ");
            result.append(Option.class.getName());
            result.append(" annotation without a dependency on the org.graalvm.compiler.options.processor.OptionProcessor annotation processor.");
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            if (stackTrace.length > 2 && stackTrace[1].getClassName().equals(OptionKey.class.getName()) && stackTrace[1].getMethodName().equals("getValue")) {
                String caller = stackTrace[2].getClassName();
                result.append(" In suite.py, add GRAAL_OPTIONS_PROCESSOR to the \"annotationProcessors\" attribute of the project containing ");
                result.append(caller);
            }
            throw new AssertionError((Object)result.toString());
        }
        return true;
    }

    public final String getName() {
        if (this.descriptor == null) {
            Lazy.init();
        }
        return this.descriptor == null ? super.toString() : this.descriptor.getName();
    }

    public String toString() {
        return this.getName();
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasBeenSet(OptionValues values) {
        return values.containsKey(this);
    }

    public T getValue(OptionValues values) {
        assert (this.checkDescriptorExists());
        return values.get(this);
    }

    public T getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        if (!values.containsKey((Object)this)) {
            return this.defaultValue;
        }
        return (T)values.get((Object)this);
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object v) {
        Object oldValue = values.put((Object)this, v);
        this.onValueUpdate(values, oldValue, v);
    }

    public void putIfAbsent(EconomicMap<OptionKey<?>, Object> values, Object v) {
        if (!values.containsKey((Object)this)) {
            this.update(values, v);
        }
    }

    protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, T oldValue, T newValue) {
    }

    protected void afterValueUpdate() {
    }

    static class Lazy {
        Lazy() {
        }

        static void init() {
        }

        static {
            for (OptionDescriptors opts : OptionsParser.getOptionsLoader()) {
                for (OptionDescriptor desc : opts) {
                    desc.getName();
                }
            }
        }
    }
}

