/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.policy;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.common.inlining.info.InlineInfo;
import org.graalvm.compiler.phases.common.inlining.policy.InlineEverythingPolicy;
import org.graalvm.compiler.phases.common.inlining.policy.InliningPolicy;
import org.graalvm.compiler.phases.common.inlining.walker.MethodInvocation;

public final class InlineMethodSubstitutionsPolicy
extends InlineEverythingPolicy {
    @Override
    public InliningPolicy.Decision isWorthInlining(Replacements replacements, MethodInvocation invocation, InlineInfo calleeInfo, int inliningDepth, boolean fullyProcessed) {
        ResolvedJavaMethod calleeMethod;
        boolean isTracing = GraalOptions.TraceInlining.getValue(calleeInfo.graph().getOptions()) != false || calleeInfo.graph().getDebug().hasCompilationListener();
        CallTargetNode callTarget = invocation.callee().invoke().callTarget();
        if (callTarget instanceof MethodCallTargetNode && replacements.hasSubstitution(calleeMethod = callTarget.targetMethod())) {
            return InliningPolicy.Decision.YES.withReason(isTracing, "has a method subtitution");
        }
        return InliningPolicy.Decision.NO.withReason(isTracing, "does not have a method substitution");
    }
}

