/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.util.JavaConstantFormatter;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.serviceprovider.GraalServices;

interface GraphPrinter
extends Closeable,
JavaConstantFormatter {
    public static final List<Class<?>> TRUSTED_CLASSES;
    public static final int MAX_CONSTANT_TO_STRING_LENGTH = 50;

    public void beginGroup(DebugContext var1, String var2, String var3, ResolvedJavaMethod var4, int var5, Map<Object, Object> var6) throws IOException;

    public void print(DebugContext var1, Graph var2, Map<Object, Object> var3, int var4, String var5, Object ... var6) throws IOException;

    public SnippetReflectionProvider getSnippetReflectionProvider();

    public void endGroup() throws IOException;

    @Override
    public void close();

    public static boolean isToStringTrusted(Class<?> c) {
        if (TRUSTED_CLASSES.contains(c)) {
            return true;
        }
        if (GraalServices.isToStringTrusted(c)) {
            return true;
        }
        return c.getClassLoader() == GraphPrinter.class.getClassLoader();
    }

    @Override
    default public String format(JavaConstant constant) {
        SnippetReflectionProvider snippetReflection = this.getSnippetReflectionProvider();
        if (snippetReflection != null && constant.getJavaKind() == JavaKind.Object) {
            Object obj = null;
            try {
                obj = snippetReflection.asObject(Object.class, constant);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (obj != null) {
                Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
                return GraphPrinter.constantToString(obj, visited);
            }
        }
        return constant.toString();
    }

    default public void updateStringPropertiesForConstant(Map<Object, Object> props, ConstantNode cn) {
        if (cn.isJavaConstant() && cn.getStackKind().isObject()) {
            String toString = this.format(cn.asJavaConstant());
            String rawvalue = GraphPrinter.truncate(toString);
            props.put("rawvalue", rawvalue);
            if (!rawvalue.equals(toString)) {
                props.put("toString", toString);
            }
        }
    }

    default public Object[] simplifyClassArgs(Object ... args) {
        Object[] res = args;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof JavaType) {
                if (args == res) {
                    res = new Object[args.length];
                    for (int a = 0; a < i; ++a) {
                        res[a] = args[a];
                    }
                }
                res[i] = ((JavaType)arg).getUnqualifiedName();
                continue;
            }
            res[i] = arg;
        }
        return res;
    }

    public static String truncate(String s) {
        if (s.length() > 50) {
            return s.substring(0, 47) + "...";
        }
        return s;
    }

    public static String constantToString(Object value, Set<Object> visited) {
        if (!visited.contains(value)) {
            String suffix;
            Class<?> c;
            block8: {
                c = value.getClass();
                suffix = "";
                if (c.isArray()) {
                    return GraphPrinter.constantArrayToString(value, visited);
                }
                visited.add(value);
                if (value instanceof Enum) {
                    return ((Enum)value).name();
                }
                if (GraphPrinter.isToStringTrusted(c)) {
                    try {
                        return value.toString();
                    }
                    catch (Throwable t) {
                        suffix = "[toString error: " + t.getClass().getName() + "]";
                        if (!GraphPrinter.isToStringTrusted(t.getClass())) break block8;
                        try {
                            suffix = "[toString error: " + t + "]";
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            return MetaUtil.getSimpleName(c, (boolean)true) + "@" + Integer.toHexString(System.identityHashCode(value)) + suffix;
        }
        return "...";
    }

    public static String constantArrayToString(Object array, Set<Object> visited) {
        if (!visited.contains(array)) {
            visited.add(array);
            Class<?> componentType = array.getClass().getComponentType();
            if (!1.$assertionsDisabled && componentType == null) {
                throw new AssertionError();
            }
            int arrayLength = Array.getLength(array);
            StringBuilder buf = new StringBuilder(MetaUtil.getSimpleName(componentType, (boolean)true)).append('[').append(arrayLength).append("]{");
            int length = arrayLength;
            boolean primitive = componentType.isPrimitive();
            for (int i = 0; i < length; ++i) {
                if (primitive) {
                    buf.append(Array.get(array, i));
                } else {
                    Object o = ((Object[])array)[i];
                    buf.append(o == null ? "null" : GraphPrinter.constantToString(o, visited));
                }
                if (i == length - 1) continue;
                buf.append(", ");
            }
            return buf.append('}').toString();
        }
        return "...";
    }

    public static StructuredGraph.ScheduleResult getScheduleOrNull(Graph graph) {
        if (graph instanceof StructuredGraph) {
            StructuredGraph sgraph = (StructuredGraph)graph;
            StructuredGraph.ScheduleResult scheduleResult = sgraph.getLastSchedule();
            if (scheduleResult == null) {
                DebugContext debug = graph.getDebug();
                try (DebugContext.Scope scope = debug.disable();){
                    SchedulePhase.runWithoutContextOptimizations(sgraph);
                    scheduleResult = sgraph.getLastSchedule();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return scheduleResult;
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        TRUSTED_CLASSES = Arrays.asList(String.class, Class.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Float.class, Long.class, Double.class);
    }
}

