/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.word.WordTypes;

public class GraphKit
extends CoreProvidersDelegate
implements GraphBuilderTool {
    protected final StructuredGraph graph;
    protected final WordTypes wordTypes;
    protected final GraphBuilderConfiguration.Plugins graphBuilderPlugins;
    protected FixedWithNextNode lastFixedNode;
    private final List<Structure> structures;

    public GraphKit(DebugContext debug, ResolvedJavaMethod stubMethod, Providers providers, WordTypes wordTypes, GraphBuilderConfiguration.Plugins graphBuilderPlugins, CompilationIdentifier compilationId, String name, boolean trackNodeSourcePosition) {
        super(providers);
        StructuredGraph.Builder builder = new StructuredGraph.Builder(debug.getOptions(), debug).compilationId(compilationId);
        if (name != null) {
            builder.name(name);
        } else {
            builder.method(stubMethod);
        }
        this.graph = builder.build();
        this.graph.disableUnsafeAccessTracking();
        if (trackNodeSourcePosition) {
            this.graph.setTrackNodeSourcePosition();
        }
        if (this.graph.trackNodeSourcePosition()) {
            this.graph.withNodeSourcePosition(NodeSourcePosition.substitution(stubMethod));
        }
        this.wordTypes = wordTypes;
        this.graphBuilderPlugins = graphBuilderPlugins;
        this.lastFixedNode = this.graph.start();
        this.structures = new ArrayList<Structure>();
        this.structures.add(new Structure(){});
    }

    @Override
    public StructuredGraph getGraph() {
        return this.graph;
    }

    @Override
    public boolean parsingIntrinsic() {
        return true;
    }

    public <T extends FloatingNode> T unique(T node) {
        return this.graph.unique(this.changeToWord(node));
    }

    public <T extends ValueNode> T add(T node) {
        return this.graph.add(this.changeToWord(node));
    }

    public <T extends ValueNode> T changeToWord(T node) {
        if (this.wordTypes != null && this.wordTypes.isWord(node)) {
            node.setStamp(this.wordTypes.getWordStamp(StampTool.typeOrNull(node)));
        }
        return node;
    }

    public Stamp wordStamp(ResolvedJavaType type) {
        assert (this.wordTypes != null && this.wordTypes.isWord((JavaType)type));
        return this.wordTypes.getWordStamp(type);
    }

    public final JavaKind asKind(JavaType type) {
        return this.wordTypes != null ? this.wordTypes.asKind(type) : type.getJavaKind();
    }

    @Override
    public <T extends ValueNode> T append(T node) {
        if (node.graph() != null) {
            return node;
        }
        T result = this.graph.addOrUniqueWithInputs(this.changeToWord(node));
        if (result instanceof FixedNode) {
            this.updateLastFixed((FixedNode)result);
        }
        return result;
    }

    private void updateLastFixed(FixedNode result) {
        assert (this.lastFixedNode != null);
        assert (result.predecessor() == null) : "Expected the predecessor of " + result + " to be null, but it was " + result.predecessor();
        this.graph.addAfterFixed(this.lastFixedNode, result);
        this.lastFixedNode = result instanceof FixedWithNextNode ? (FixedWithNextNode)result : null;
    }

    public InvokeNode createInvoke(Class<?> declaringClass, String name, ValueNode ... args) {
        return this.createInvoke(declaringClass, name, CallTargetNode.InvokeKind.Static, null, -5, args);
    }

    public InvokeNode createInvoke(Class<?> declaringClass, String name, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder frameStateBuilder, int bci, ValueNode ... args) {
        boolean isStatic = invokeKind == CallTargetNode.InvokeKind.Static;
        ResolvedJavaMethod method = this.findMethod(declaringClass, name, isStatic);
        return this.createInvoke(method, invokeKind, frameStateBuilder, bci, args);
    }

    public ResolvedJavaMethod findMethod(Class<?> declaringClass, String name, boolean isStatic) {
        ResolvedJavaType type = this.getMetaAccess().lookupJavaType(declaringClass);
        ResolvedJavaMethod method = null;
        for (ResolvedJavaMethod m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) != isStatic || !m.getName().equals(name)) continue;
            assert (method == null) : "found more than one method in " + declaringClass + " named " + name;
            method = m;
        }
        GraalError.guarantee(method != null, "Could not find %s.%s (%s)", declaringClass, (Object)name, (Object)(isStatic ? "static" : "non-static"));
        return method;
    }

    public ResolvedJavaMethod findMethod(Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        try {
            Method m = declaringClass.getDeclaredMethod(name, parameterTypes);
            return this.getMetaAccess().lookupJavaMethod((Executable)m);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    public InvokeNode createInvoke(ResolvedJavaMethod method, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder frameStateBuilder, int bci, ValueNode ... args) {
        try (DebugCloseable context = this.graph.withNodeSourcePosition(NodeSourcePosition.substitution(this.graph.currentNodeSourcePosition(), method));){
            assert (method.isStatic() == (invokeKind == CallTargetNode.InvokeKind.Static));
            Signature signature = method.getSignature();
            JavaType returnType = signature.getReturnType(null);
            assert (this.checkArgs(method, args));
            StampPair returnStamp = this.graphBuilderPlugins.getOverridingStamp(this, returnType, false);
            if (returnStamp == null) {
                returnStamp = StampFactory.forDeclaredType(this.graph.getAssumptions(), returnType, false);
            }
            MethodCallTargetNode callTarget = this.graph.add(this.createMethodCallTarget(invokeKind, method, args, returnStamp, bci));
            InvokeNode invoke = this.append(new InvokeNode(callTarget, bci));
            GraphKit.pushForStateSplit(frameStateBuilder, bci, invoke);
            InvokeNode invokeNode = invoke;
            return invokeNode;
        }
    }

    private static void pushForStateSplit(FrameStateBuilder frameStateBuilder, int bci, StateSplit stateSplit) {
        if (frameStateBuilder != null) {
            JavaKind stackKind = stateSplit.asNode().getStackKind();
            if (stackKind != JavaKind.Void) {
                frameStateBuilder.push(stackKind, stateSplit.asNode());
            }
            stateSplit.setStateAfter(frameStateBuilder.create(bci, stateSplit));
            if (stackKind != JavaKind.Void) {
                frameStateBuilder.pop(stackKind);
            }
        }
    }

    public InvokeNode createIntrinsicInvoke(ResolvedJavaMethod method, ValueNode ... args) {
        return this.createInvoke(method, CallTargetNode.InvokeKind.Static, null, -5, args);
    }

    public InvokeWithExceptionNode createInvokeWithExceptionAndUnwind(ResolvedJavaMethod method, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder frameStateBuilder, int invokeBci, ValueNode ... args) {
        try (DebugCloseable context = this.graph.withNodeSourcePosition(NodeSourcePosition.substitution(this.graph.currentNodeSourcePosition(), method));){
            InvokeWithExceptionNode result = this.startInvokeWithException(method, invokeKind, frameStateBuilder, invokeBci, args);
            this.exceptionPart();
            ExceptionObjectNode exception = this.exceptionObject();
            this.append(new UnwindNode(exception));
            this.endInvokeWithException();
            InvokeWithExceptionNode invokeWithExceptionNode = result;
            return invokeWithExceptionNode;
        }
    }

    public InvokeWithExceptionNode createInvokeWithExceptionAndUnwind(MethodCallTargetNode callTarget, FrameStateBuilder frameStateBuilder, int invokeBci) {
        try (DebugCloseable context = this.graph.withNodeSourcePosition(NodeSourcePosition.substitution(this.graph.currentNodeSourcePosition(), callTarget.targetMethod()));){
            InvokeWithExceptionNode result = this.startInvokeWithException(callTarget, frameStateBuilder, invokeBci);
            this.exceptionPart();
            ExceptionObjectNode exception = this.exceptionObject();
            this.append(new UnwindNode(exception));
            this.endInvokeWithException();
            InvokeWithExceptionNode invokeWithExceptionNode = result;
            return invokeWithExceptionNode;
        }
    }

    protected MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        return new MethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, null);
    }

    public boolean checkArgs(ResolvedJavaMethod method, ValueNode ... args) {
        boolean isStatic;
        if (Services.IS_IN_NATIVE_IMAGE) {
            return true;
        }
        Signature signature = method.getSignature();
        if (signature.getParameterCount(!(isStatic = method.isStatic())) != args.length) {
            throw new AssertionError((Object)(this.graph + ": wrong number of arguments to " + method));
        }
        int argIndex = 0;
        if (!isStatic) {
            JavaKind expected = this.asKind((JavaType)method.getDeclaringClass());
            JavaKind actual = args[argIndex++].stamp(NodeView.DEFAULT).getStackKind();
            assert (expected == actual) : this.graph + ": wrong kind of value for receiver argument of call to " + method + " [" + actual + " != " + expected + "]";
        }
        for (int i = 0; i != signature.getParameterCount(false); ++i) {
            JavaKind actual;
            JavaKind expected = this.asKind(signature.getParameterType(i, method.getDeclaringClass())).getStackKind();
            if (expected != (actual = args[argIndex++].stamp(NodeView.DEFAULT).getStackKind())) {
                throw new AssertionError((Object)(this.graph + ": wrong kind of value for argument " + i + " of call to " + method + " [" + actual + " != " + expected + "]"));
            }
        }
        return true;
    }

    public void inlineInvokesAsIntrinsics(String reason, String phase) {
        while (!this.graph.getNodes().filter(InvokeNode.class).isEmpty()) {
            for (InvokeNode invoke : this.graph.getNodes().filter(InvokeNode.class).snapshot()) {
                this.inlineAsIntrinsic(invoke, reason, phase);
            }
        }
        new DeadCodeEliminationPhase().apply(this.graph);
    }

    public void inlineAsIntrinsic(Invoke invoke, String reason, String phase) {
        StructuredGraph calleeGraph;
        assert (invoke instanceof Node);
        Node invokeNode = (Node)((Object)invoke);
        ResolvedJavaMethod method = invoke.callTarget().targetMethod();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.graphBuilderPlugins);
        GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
        if (Services.IS_IN_NATIVE_IMAGE) {
            calleeGraph = this.getReplacements().getSnippet(method, null, null, null, false, null, invokeNode.getOptions());
        } else {
            calleeGraph = new StructuredGraph.Builder(invokeNode.getOptions(), invokeNode.getDebug()).method(method).trackNodeSourcePosition(invokeNode.graph().trackNodeSourcePosition()).setIsSubstitution(true).build();
            IntrinsicContext initialReplacementContext = new IntrinsicContext(method, method, this.getReplacements().getDefaultReplacementBytecodeProvider(), IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
            GraphBuilderPhase.Instance instance = this.createGraphBuilderInstance(config, OptimisticOptimizations.NONE, initialReplacementContext);
            instance.apply(calleeGraph);
        }
        new DeadCodeEliminationPhase().apply(calleeGraph);
        InliningUtil.inline(invoke, calleeGraph, false, method, reason, phase);
    }

    public void inline(Invoke invoke, String reason, String phase) {
        assert (invoke instanceof Node);
        Node invokeNode = (Node)((Object)invoke);
        ResolvedJavaMethod methodToInline = invoke.callTarget().targetMethod();
        GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.graphBuilderPlugins);
        GraphBuilderConfiguration config = GraphBuilderConfiguration.getDefault(plugins);
        StructuredGraph calleeGraph = new StructuredGraph.Builder(invokeNode.getOptions(), invokeNode.getDebug()).method(methodToInline).trackNodeSourcePosition(invokeNode.graph().trackNodeSourcePosition()).setIsSubstitution(false).build();
        GraphBuilderPhase.Instance instance = this.createGraphBuilderInstance(config, OptimisticOptimizations.NONE, null);
        instance.apply(calleeGraph);
        new DeadCodeEliminationPhase().apply(calleeGraph);
        InliningUtil.inline(invoke, calleeGraph, false, methodToInline, reason, phase);
    }

    protected GraphBuilderPhase.Instance createGraphBuilderInstance(GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new GraphBuilderPhase.Instance(this.getProviders(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
    }

    protected void pushStructure(Structure structure) {
        this.structures.add(structure);
    }

    protected <T extends Structure> T getTopStructure(Class<T> expectedClass) {
        return (T)((Structure)expectedClass.cast(this.structures.get(this.structures.size() - 1)));
    }

    protected void popStructure() {
        this.structures.remove(this.structures.size() - 1);
    }

    public IfNode startIf(LogicNode condition, ProfileData.BranchProbabilityData profileData) {
        AbstractBeginNode thenSuccessor = this.graph.add(new BeginNode());
        AbstractBeginNode elseSuccessor = this.graph.add(new BeginNode());
        IfNode node = this.append(new IfNode(condition, thenSuccessor, elseSuccessor, profileData));
        this.lastFixedNode = null;
        IfStructure s = new IfStructure();
        s.state = IfState.CONDITION;
        s.thenPart = thenSuccessor;
        s.elsePart = elseSuccessor;
        this.pushStructure(s);
        return node;
    }

    private IfStructure saveLastIfNode() {
        IfStructure s = this.getTopStructure(IfStructure.class);
        switch (s.state) {
            case CONDITION: {
                assert (this.lastFixedNode == null);
                break;
            }
            case THEN_PART: {
                s.thenPart = this.lastFixedNode;
                break;
            }
            case ELSE_PART: {
                s.elsePart = this.lastFixedNode;
                break;
            }
            case FINISHED: {
                assert (false);
                break;
            }
        }
        this.lastFixedNode = null;
        return s;
    }

    public void thenPart() {
        IfStructure s = this.saveLastIfNode();
        this.lastFixedNode = (FixedWithNextNode)s.thenPart;
        s.state = IfState.THEN_PART;
    }

    public void elsePart() {
        IfStructure s = this.saveLastIfNode();
        this.lastFixedNode = (FixedWithNextNode)s.elsePart;
        s.state = IfState.ELSE_PART;
    }

    public AbstractMergeNode endIf() {
        IfStructure s = this.saveLastIfNode();
        FixedWithNextNode thenPart = s.thenPart instanceof FixedWithNextNode ? (FixedWithNextNode)s.thenPart : null;
        FixedWithNextNode elsePart = s.elsePart instanceof FixedWithNextNode ? (FixedWithNextNode)s.elsePart : null;
        AbstractMergeNode merge = this.mergeControlSplitBranches(thenPart, elsePart);
        s.state = IfState.FINISHED;
        this.popStructure();
        return merge;
    }

    private AbstractMergeNode mergeControlSplitBranches(FixedWithNextNode x, FixedWithNextNode y) {
        AbstractMergeNode merge = null;
        if (x != null && y != null) {
            EndNode xEnd = this.graph.add(new EndNode());
            this.graph.addAfterFixed(x, xEnd);
            EndNode yEnd = this.graph.add(new EndNode());
            this.graph.addAfterFixed(y, yEnd);
            merge = this.graph.add(new MergeNode());
            merge.addForwardEnd(xEnd);
            merge.addForwardEnd(yEnd);
            this.lastFixedNode = merge;
        } else if (x != null) {
            this.lastFixedNode = x;
        } else if (y != null) {
            this.lastFixedNode = y;
        } else assert (this.lastFixedNode == null);
        return merge;
    }

    public InvokeWithExceptionNode startInvokeWithException(ResolvedJavaMethod method, CallTargetNode.InvokeKind invokeKind, FrameStateBuilder frameStateBuilder, int invokeBci, ValueNode ... args) {
        assert (method.isStatic() == (invokeKind == CallTargetNode.InvokeKind.Static));
        Signature signature = method.getSignature();
        JavaType returnType = signature.getReturnType(null);
        assert (this.checkArgs(method, args));
        StampPair returnStamp = this.graphBuilderPlugins.getOverridingStamp(this, returnType, false);
        if (returnStamp == null) {
            returnStamp = StampFactory.forDeclaredType(this.graph.getAssumptions(), returnType, false);
        }
        MethodCallTargetNode callTarget = this.graph.add(this.createMethodCallTarget(invokeKind, method, args, returnStamp, invokeBci));
        return this.startInvokeWithException(callTarget, frameStateBuilder, invokeBci);
    }

    public InvokeWithExceptionNode startInvokeWithException(MethodCallTargetNode callTarget, FrameStateBuilder frameStateBuilder, int invokeBci) {
        ExceptionObjectNode exceptionObject = this.createExceptionObjectNode(frameStateBuilder, invokeBci);
        InvokeWithExceptionNode invoke = this.append(new InvokeWithExceptionNode(callTarget, exceptionObject, invokeBci));
        AbstractBeginNode noExceptionEdge = this.graph.add(new BeginNode());
        invoke.setNext(noExceptionEdge);
        GraphKit.pushForStateSplit(frameStateBuilder, invokeBci, invoke);
        this.lastFixedNode = null;
        InvokeWithExceptionStructure s = new InvokeWithExceptionStructure();
        s.state = InvokeWithExceptionStructure.State.INVOKE;
        s.noExceptionEdge = noExceptionEdge;
        s.exceptionEdge = exceptionObject;
        s.exceptionObject = exceptionObject;
        this.pushStructure(s);
        return invoke;
    }

    protected ExceptionObjectNode createExceptionObjectNode(FrameStateBuilder frameStateBuilder, int exceptionEdgeBci) {
        ExceptionObjectNode exceptionObject = this.add(new ExceptionObjectNode(this.getMetaAccess()));
        this.setStateAfterException(frameStateBuilder, exceptionEdgeBci, exceptionObject, true);
        return exceptionObject;
    }

    protected void setStateAfterException(FrameStateBuilder frameStateBuilder, int exceptionEdgeBci, StateSplit exceptionObject, boolean rethrow) {
        if (frameStateBuilder != null) {
            FrameStateBuilder exceptionState = frameStateBuilder.copy();
            if (rethrow) {
                exceptionState.clearStack();
                exceptionState.setRethrowException(true);
            }
            exceptionState.push(JavaKind.Object, exceptionObject.asNode());
            exceptionObject.setStateAfter(exceptionState.create(exceptionEdgeBci, exceptionObject));
        }
    }

    private InvokeWithExceptionStructure saveLastInvokeWithExceptionNode() {
        InvokeWithExceptionStructure s = this.getTopStructure(InvokeWithExceptionStructure.class);
        switch (s.state) {
            case INVOKE: {
                assert (this.lastFixedNode == null);
                break;
            }
            case NO_EXCEPTION_EDGE: {
                s.noExceptionEdge = this.lastFixedNode;
                break;
            }
            case EXCEPTION_EDGE: {
                s.exceptionEdge = this.lastFixedNode;
                break;
            }
            case FINISHED: {
                assert (false);
                break;
            }
        }
        this.lastFixedNode = null;
        return s;
    }

    public void noExceptionPart() {
        InvokeWithExceptionStructure s = this.saveLastInvokeWithExceptionNode();
        this.lastFixedNode = (FixedWithNextNode)s.noExceptionEdge;
        s.state = InvokeWithExceptionStructure.State.NO_EXCEPTION_EDGE;
    }

    public void exceptionPart() {
        InvokeWithExceptionStructure s = this.saveLastInvokeWithExceptionNode();
        this.lastFixedNode = (FixedWithNextNode)s.exceptionEdge;
        s.state = InvokeWithExceptionStructure.State.EXCEPTION_EDGE;
    }

    public ExceptionObjectNode exceptionObject() {
        InvokeWithExceptionStructure s = this.getTopStructure(InvokeWithExceptionStructure.class);
        return s.exceptionObject;
    }

    public AbstractMergeNode endInvokeWithException() {
        InvokeWithExceptionStructure s = this.saveLastInvokeWithExceptionNode();
        FixedWithNextNode noExceptionEdge = s.noExceptionEdge instanceof FixedWithNextNode ? (FixedWithNextNode)s.noExceptionEdge : null;
        FixedWithNextNode exceptionEdge = s.exceptionEdge instanceof FixedWithNextNode ? (FixedWithNextNode)s.exceptionEdge : null;
        AbstractMergeNode merge = this.mergeControlSplitBranches(noExceptionEdge, exceptionEdge);
        s.state = InvokeWithExceptionStructure.State.FINISHED;
        this.popStructure();
        return merge;
    }

    static class InvokeWithExceptionStructure
    extends Structure {
        protected State state;
        protected ExceptionObjectNode exceptionObject;
        protected FixedNode noExceptionEdge;
        protected FixedNode exceptionEdge;

        InvokeWithExceptionStructure() {
        }

        protected static enum State {
            INVOKE,
            NO_EXCEPTION_EDGE,
            EXCEPTION_EDGE,
            FINISHED;

        }
    }

    static class IfStructure
    extends Structure {
        protected IfState state;
        protected FixedNode thenPart;
        protected FixedNode elsePart;

        IfStructure() {
        }
    }

    protected static enum IfState {
        CONDITION,
        THEN_PART,
        ELSE_PART,
        FINISHED;

    }

    protected static abstract class Structure {
        protected Structure() {
        }
    }
}

