/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.gc;

import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public abstract class WriteBarrierSnippets {
    public static final LocationIdentity GC_CARD_LOCATION = NamedLocationIdentity.mutable("GC-Card");

    protected static void verifyNotArray(Object object) {
        if (object != null) {
            AssertionNode.dynamicAssert(!PiNode.piCastNonNull(object, SnippetAnchorNode.anchor()).getClass().isArray(), "imprecise card mark used with array");
        }
    }

    protected static Word getPointerToFirstArrayElement(AddressNode.Address address, long length, int elementStride) {
        long result = Word.fromAddress(address).rawValue();
        if (elementStride < 0) {
            result += (long)elementStride * length;
        }
        return (Word)WordFactory.unsigned((long)result);
    }

    protected static Word getPointerToLastArrayElement(AddressNode.Address address, long length, int elementStride) {
        long result = Word.fromAddress(address).rawValue();
        result = elementStride < 0 ? (result += (long)elementStride) : (result += (length - 1L) * (long)elementStride);
        return (Word)WordFactory.unsigned((long)result);
    }
}

