/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class VirtualFrameAccessorNode
extends FixedWithNextNode
implements ControlFlowAnchored {
    public static final NodeClass<VirtualFrameAccessorNode> TYPE = NodeClass.create(VirtualFrameAccessorNode.class);
    @Node.Input
    protected NewFrameNode frame;
    protected final int frameSlotIndex;
    protected final int accessTag;
    protected final VirtualFrameAccessType type;

    protected VirtualFrameAccessorNode(NodeClass<? extends VirtualFrameAccessorNode> c, Stamp stamp, InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type) {
        this(c, stamp, (NewFrameNode)frame.get(), frameSlotIndex, accessTag, type);
    }

    protected VirtualFrameAccessorNode(NodeClass<? extends VirtualFrameAccessorNode> c, Stamp stamp, NewFrameNode frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.type = type;
        this.frame = frame;
        this.frameSlotIndex = frameSlotIndex;
        this.accessTag = accessTag;
    }

    protected final ValueNode getConstant(int n) {
        return (ValueNode)this.frame.smallIntConstants.get(n);
    }

    public final NewFrameNode getFrame() {
        return this.frame;
    }

    public final int getFrameSlotIndex() {
        return this.frameSlotIndex;
    }

    public final int getAccessTag() {
        return this.accessTag;
    }

    public final VirtualFrameAccessType getType() {
        return this.type;
    }

    protected final void insertDeoptimization(VirtualizerTool tool) {
        LogicConstantNode condition = LogicConstantNode.contradiction();
        tool.addNode(condition);
        SpeculationLog.Speculation speculation = this.graph().getSpeculationLog().speculate(this.frame.getIntrinsifyAccessorsSpeculation());
        tool.addNode(new FixedGuardNode((LogicNode)condition, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateReprofile, speculation, false));
        if (this.getStackKind() == JavaKind.Void) {
            tool.delete();
        } else {
            ConstantNode unusedValue = ConstantNode.forConstant(JavaConstant.defaultForKind((JavaKind)this.getStackKind()), tool.getMetaAccess());
            tool.addNode(unusedValue);
            tool.replaceWith(unusedValue);
        }
    }
}

