/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameSetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameSetNode> TYPE = NodeClass.create(VirtualFrameSetNode.class);
    @Node.Input
    private ValueNode value;
    private final boolean setTag;

    public VirtualFrameSetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type);
        this.value = value;
        this.setTag = true;
    }

    public VirtualFrameSetNode(NewFrameNode frame, int frameSlotIndex, int accessTag, ValueNode value, VirtualFrameAccessType type, boolean setTag) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, accessTag, type);
        this.value = value;
        this.setTag = setTag;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        JavaKind valueKind = this.value.getStackKind();
        if (this.type == VirtualFrameAccessType.Auxiliary) {
            VirtualObjectNode dataVirtual;
            ValueNode dataAlias = tool.getAlias(this.frame.getObjectArray(this.type));
            assert (valueKind == JavaKind.Object);
            if (dataAlias instanceof VirtualObjectNode && this.frameSlotIndex < (dataVirtual = (VirtualObjectNode)dataAlias).entryCount() && tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, this.value, valueKind, -1L)) {
                tool.delete();
                return;
            }
        } else {
            ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
            ValueNode dataAlias = tool.getAlias(valueKind == JavaKind.Object ? this.frame.getObjectArray(this.type) : this.frame.getPrimitiveArray(this.type));
            if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
                VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
                VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
                if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                    if (this.setTag) {
                        tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag));
                    }
                    if (tool.setVirtualEntry(dataVirtual, this.frameSlotIndex, this.value, valueKind == JavaKind.Object ? JavaKind.Object : JavaKind.Long, -1L)) {
                        if (valueKind == JavaKind.Object) {
                            ValueNode primitiveAlias = tool.getAlias(this.frame.getPrimitiveArray(this.type));
                            tool.setVirtualEntry((VirtualObjectNode)primitiveAlias, this.frameSlotIndex, ConstantNode.defaultForKind(JavaKind.Long, this.graph()), JavaKind.Long, -1L);
                        }
                        tool.delete();
                        return;
                    }
                }
            }
        }
        this.insertDeoptimization(tool);
    }
}

