/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.compiler.PEAgnosticInlineInvokePlugin;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.phases.inlining.AgnosticInliningPhase;

final class GraphManager {
    public static final int TRIVIAL_NODE_COUNT_LIMIT = 500;
    private final PartialEvaluator partialEvaluator;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining;
    private final EconomicMap<CompilableTruffleAST, Entry> irCache = EconomicMap.create();
    private final PartialEvaluator.Request rootRequest;

    GraphManager(PartialEvaluator partialEvaluator, PartialEvaluator.Request rootRequest) {
        this.partialEvaluator = partialEvaluator;
        this.rootRequest = rootRequest;
        this.graphCacheForInlining = partialEvaluator.getOrCreateEncodedGraphCache();
    }

    Entry pe(CompilableTruffleAST truffleAST) {
        Entry entry = (Entry)this.irCache.get((Object)truffleAST);
        if (entry == null) {
            PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
            PartialEvaluator.Request request = this.newRequest(truffleAST, false);
            request.graph.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(truffleAST.getNodeRewritingAssumptionConstant()));
            this.partialEvaluator.doGraphPE(request, plugin, this.graphCacheForInlining);
            this.partialEvaluator.truffleTier(request);
            entry = new Entry(request.graph, plugin);
            this.irCache.put((Object)truffleAST, (Object)entry);
        }
        return entry;
    }

    private PartialEvaluator.Request newRequest(CompilableTruffleAST truffleAST, boolean finalize) {
        PartialEvaluator partialEvaluator = this.partialEvaluator;
        partialEvaluator.getClass();
        return partialEvaluator.new PartialEvaluator.Request(this.rootRequest.options, this.rootRequest.debug, truffleAST, finalize ? this.partialEvaluator.getCallDirect() : this.partialEvaluator.inlineRootForCallTarget(truffleAST), this.rootRequest.compilationId, this.rootRequest.log, this.rootRequest.task);
    }

    private PEAgnosticInlineInvokePlugin newPlugin() {
        return new PEAgnosticInlineInvokePlugin(this.rootRequest.task.inliningData(), this.partialEvaluator);
    }

    Entry peRoot() {
        PEAgnosticInlineInvokePlugin plugin = this.newPlugin();
        this.partialEvaluator.doGraphPE(this.rootRequest, plugin, this.graphCacheForInlining);
        this.partialEvaluator.truffleTier(this.rootRequest);
        return new Entry(this.rootRequest.graph, plugin);
    }

    UnmodifiableEconomicMap<Node, Node> doInline(Invoke invoke, StructuredGraph ir, CompilableTruffleAST truffleAST, InliningUtil.InlineeReturnAction returnAction) {
        return InliningUtil.inline(invoke, ir, true, this.partialEvaluator.inlineRootForCallTarget(truffleAST), "cost-benefit analysis", AgnosticInliningPhase.class.getName(), returnAction);
    }

    void finalizeGraph(Invoke invoke, CompilableTruffleAST truffleAST) {
        PartialEvaluator.Request request = this.newRequest(truffleAST, true);
        this.partialEvaluator.doGraphPE(request, new InlineInvokePlugin(){

            @Override
            public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
                return PartialEvaluator.asInlineInfo(method);
            }
        }, this.graphCacheForInlining);
        InliningUtil.inline(invoke, request.graph, true, this.partialEvaluator.getCallInlined(), "finalization", AgnosticInliningPhase.class.getName());
    }

    static class Entry {
        final StructuredGraph graph;
        final EconomicMap<Invoke, TruffleCallNode> invokeToTruffleCallNode;
        final List<Invoke> indirectInvokes;
        final boolean trivial;

        Entry(StructuredGraph graph, PEAgnosticInlineInvokePlugin plugin) {
            this.graph = graph;
            this.invokeToTruffleCallNode = plugin.getInvokeToTruffleCallNode();
            this.indirectInvokes = plugin.getIndirectInvokes();
            this.trivial = this.invokeToTruffleCallNode.isEmpty() && this.indirectInvokes.isEmpty() && graph.getNodes(LoopBeginNode.TYPE).count() == 0 && graph.getNodeCount() < 500;
        }
    }
}

