/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.substitutions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConditionAnchorNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DynamicPiNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerMulHighNode;
import org.graalvm.compiler.nodes.calc.RoundNode;
import org.graalvm.compiler.nodes.debug.BlackholeNode;
import org.graalvm.compiler.nodes.extended.BoxNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardedUnsafeLoadNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.EnsureVirtualizedNode;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.nodes.arithmetic.UnsignedMulHighNode;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.nodes.IsCompilationConstantNode;
import org.graalvm.compiler.truffle.compiler.nodes.ObjectLocationIdentity;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.AllowMaterializeNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.ForceMaterializeNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.NewFrameNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameClearNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameCopyNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameGetNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameGetTagNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameIsNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameSetNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameSwapNode;
import org.graalvm.compiler.truffle.compiler.phases.TruffleSafepointInsertionPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.word.LocationIdentity;

public class TruffleGraphBuilderPlugins {
    public static void registerInvocationPlugins(InvocationPlugins plugins, boolean canDelayIntrinsification, Providers providers, KnownTruffleTypes types) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        TruffleGraphBuilderPlugins.registerObjectsPlugins(plugins, metaAccess);
        TruffleGraphBuilderPlugins.registerOptimizedAssumptionPlugins(plugins, metaAccess, types);
        TruffleGraphBuilderPlugins.registerExactMathPlugins(plugins, providers.getReplacements(), providers.getLowerer(), metaAccess);
        TruffleGraphBuilderPlugins.registerCompilerDirectivesPlugins(plugins, metaAccess, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerCompilerAssertsPlugins(plugins, metaAccess, canDelayIntrinsification);
        EconomicSet primitiveBoxTypes = EconomicSet.create();
        for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
            ResolvedJavaType boxingType = metaAccess.lookupJavaType(kind.toBoxedJavaClass());
            assert (boxingType != null);
            primitiveBoxTypes.add((Object)boxingType);
        }
        TruffleGraphBuilderPlugins.registerOptimizedCallTargetPlugins(plugins, metaAccess, canDelayIntrinsification, types, (EconomicSet<ResolvedJavaType>)primitiveBoxTypes);
        TruffleGraphBuilderPlugins.registerFrameWithoutBoxingPlugins(plugins, metaAccess, canDelayIntrinsification, providers.getConstantReflection(), types, (EconomicSet<ResolvedJavaType>)primitiveBoxTypes);
        TruffleGraphBuilderPlugins.registerTruffleSafepointPlugins(plugins, metaAccess, canDelayIntrinsification);
        TruffleGraphBuilderPlugins.registerNodePlugins(plugins, metaAccess, canDelayIntrinsification, providers.getConstantReflection(), types);
    }

    private static void registerTruffleSafepointPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, final boolean canDelayIntrinsification) {
        ResolvedJavaType truffleSafepoint = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.TruffleSafepoint");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(truffleSafepoint));
        r.register1("poll", (Type)((Object)com.oracle.truffle.api.nodes.Node.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                if (arg.isConstant()) {
                    assert (TruffleSafepointInsertionPhase.allowsSafepoints(b.getGraph())) : "TruffleSafepoint.poll only expected to be removed in Truffle compilations.";
                    return true;
                }
                if (canDelayIntrinsification) {
                    return false;
                }
                throw TruffleGraphBuilderPlugins.failPEConstant(b, arg);
            }
        });
    }

    private static void registerObjectsPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess) {
        ResolvedJavaType objectsType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "java.util.Objects");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(objectsType));
        InvocationPlugin requireNonNullPlugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                ValueNode nullChecked = b.nullCheckedValue(arg);
                b.addPush(JavaKind.Object, nullChecked);
                return true;
            }

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode obj, ValueNode msg) {
                return this.apply(b, targetMethod, receiver, obj);
            }
        };
        r.register1("requireNonNull", (Type)((Object)Object.class), requireNonNullPlugin);
        r.register2("requireNonNull", (Type)((Object)Object.class), (Type)((Object)String.class), requireNonNullPlugin);
        r.register2("requireNonNull", (Type)((Object)Object.class), (Type)((Object)Supplier.class), requireNonNullPlugin);
    }

    public static void registerOptimizedAssumptionPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, final KnownTruffleTypes types) {
        ResolvedJavaType optimizedAssumptionType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.OptimizedAssumption");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(optimizedAssumptionType));
        InvocationPlugin plugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (receiver.isConstant() && b.getAssumptions() != null) {
                    JavaConstant assumption = (JavaConstant)receiver.get().asConstant();
                    if (b.getConstantReflection().readFieldValue(types.fieldOptimizedAssumptionIsValid, assumption).asBoolean()) {
                        if (targetMethod.getName().equals("isValid")) {
                            b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                        } else assert (targetMethod.getName().equals("check")) : targetMethod;
                        b.getAssumptions().record((Assumptions.Assumption)new TruffleAssumption(assumption));
                    } else if (targetMethod.getName().equals("isValid")) {
                        b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                    } else {
                        assert (targetMethod.getName().equals("check")) : targetMethod;
                        b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.None));
                    }
                    return true;
                }
                return false;
            }
        };
        r.register1("isValid", (Type)((Object)InvocationPlugin.Receiver.class), plugin);
        r.register1("check", (Type)((Object)InvocationPlugin.Receiver.class), plugin);
    }

    public static void registerExactMathPlugins(InvocationPlugins plugins, Replacements replacements, LoweringProvider lowerer, MetaAccessProvider metaAccess) {
        ResolvedJavaType exactMathType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.ExactMath");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(exactMathType), replacements);
        for (final JavaKind kind : new JavaKind[]{JavaKind.Int, JavaKind.Long}) {
            Class type = kind.toJavaClass();
            r.register2("multiplyHigh", type, type, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.addPush(kind, new IntegerMulHighNode(x, y));
                    return true;
                }
            });
            r.register2("multiplyHighUnsigned", type, type, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode y) {
                    b.addPush(kind, new UnsignedMulHighNode(x, y));
                    return true;
                }
            });
        }
        for (final JavaKind kind : new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            r.registerConditional1(lowerer.supportsRounding(), "truncate", kind.toJavaClass(), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                    b.addPush(kind, new RoundNode(x, ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE));
                    return true;
                }
            });
        }
    }

    public static void registerCompilerDirectivesPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, final boolean canDelayIntrinsification) {
        ResolvedJavaType compilerDirectivesType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.CompilerDirectives");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(compilerDirectivesType));
        r.register0("inInterpreter", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                return true;
            }
        });
        r.register0("hasNextTier", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (!canDelayIntrinsification && b.getGraph().getCancellable() instanceof TruffleCompilationTask) {
                    TruffleCompilationTask task = (TruffleCompilationTask)((Object)b.getGraph().getCancellable());
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(task.hasNextTier()));
                    return true;
                }
                return false;
            }
        });
        r.register0("inCompiledCode", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                return true;
            }
        });
        r.register0("inCompilationRoot", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                GraphBuilderContext.ExternalInliningContext inliningContext = b.getExternalInliningContext();
                if (inliningContext != null) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(inliningContext.getInlinedDepth() == 0));
                    return true;
                }
                return false;
            }
        });
        r.register0("transferToInterpreter", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register0("transferToInterpreterAndInvalidate", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.TransferToInterpreter));
                return true;
            }
        });
        r.register1("interpreterOnly", (Type)((Object)Runnable.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return true;
            }
        });
        r.register1("interpreterOnly", (Type)((Object)Callable.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                return true;
            }
        });
        r.register2("injectBranchProbability", Double.TYPE, Boolean.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode probability, ValueNode condition) {
                b.addPush(JavaKind.Boolean, new BranchProbabilityNode(probability, condition));
                return true;
            }
        });
        r.register1("bailout", (Type)((Object)String.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                if (canDelayIntrinsification) {
                    StampPair returnStamp = b.getInvokeReturnStamp(b.getAssumptions());
                    CallTargetNode callTarget = b.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, targetMethod, new ValueNode[]{message}, returnStamp, null));
                    b.add(new InvokeNode(callTarget, b.bci()));
                    b.add(new NeverPartOfCompilationNode("intrinsification of call to bailout() will abort entire compilation"));
                    return true;
                }
                if (message.isConstant()) {
                    throw b.bailout(message.asConstant().toValueString());
                }
                throw b.bailout("bailout (message is not compile-time constant, so no additional information is available)");
            }
        });
        r.register1("isCompilationConstant", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if ((value instanceof BoxNode ? ((BoxNode)value).getValue() : value).isConstant()) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                } else {
                    b.addPush(JavaKind.Boolean, new IsCompilationConstantNode(value));
                }
                return true;
            }
        });
        r.register1("isPartialEvaluationConstant", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                if ((value instanceof BoxNode ? ((BoxNode)value).getValue() : value).isConstant()) {
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(true));
                } else {
                    if (canDelayIntrinsification) {
                        return false;
                    }
                    b.addPush(JavaKind.Boolean, ConstantNode.forBoolean(false));
                }
                return true;
            }
        });
        r.register1("materialize", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                AllowMaterializeNode materializedValue = b.append(new AllowMaterializeNode(value));
                b.add(new ForceMaterializeNode(materializedValue));
                return true;
            }
        });
        r.register1("ensureVirtualized", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, false));
                return true;
            }
        });
        r.register1("ensureVirtualizedHere", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.add(new EnsureVirtualizedNode(object, true));
                return true;
            }
        });
        for (JavaKind kind : JavaKind.values()) {
            if ((!kind.isPrimitive() || kind == JavaKind.Void) && kind != JavaKind.Object) continue;
            Class<?> javaClass = TruffleGraphBuilderPlugins.getJavaClass(kind);
            r.register1("blackhole", javaClass, new InvocationPlugin(){

                @Override
                public boolean inlineOnly() {
                    return true;
                }

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                    b.add(new BlackholeNode(value));
                    return true;
                }
            });
        }
        r.register2("castExact", (Type)((Object)Object.class), (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.addNonNullCast(javaClass);
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), nullCheckedClass, object, true, true));
                if (condition.isTautology()) {
                    b.addPush(JavaKind.Object, object);
                } else {
                    FixedGuardNode fixedGuard = b.add(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
                    b.addPush(JavaKind.Object, DynamicPiNode.create(b.getAssumptions(), b.getConstantReflection(), object, fixedGuard, nullCheckedClass, true, true));
                }
                return true;
            }
        });
        r.register2("isExact", (Type)((Object)Object.class), (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.addNonNullCast(javaClass);
                LogicNode condition = b.append(InstanceOfDynamicNode.create(b.getAssumptions(), b.getConstantReflection(), nullCheckedClass, object, false, true));
                b.addPush(JavaKind.Boolean, b.append(new ConditionalNode(condition)));
                return true;
            }
        });
    }

    private static Class<?> getJavaClass(JavaKind kind) {
        return kind == JavaKind.Object ? Object.class : kind.toJavaClass();
    }

    public static void registerCompilerAssertsPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, boolean canDelayIntrinsification) {
        ResolvedJavaType compilerAssertsType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.CompilerAsserts");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(compilerAssertsType));
        PEConstantPlugin peConstantPlugin = new PEConstantPlugin(canDelayIntrinsification);
        r.register1("partialEvaluationConstant", (Type)((Object)Object.class), peConstantPlugin);
        r.register1("partialEvaluationConstant", Integer.TYPE, peConstantPlugin);
        r.register1("partialEvaluationConstant", Long.TYPE, peConstantPlugin);
        r.register1("partialEvaluationConstant", Float.TYPE, peConstantPlugin);
        r.register1("partialEvaluationConstant", Double.TYPE, peConstantPlugin);
        r.register1("partialEvaluationConstant", Boolean.TYPE, peConstantPlugin);
        r.register0("neverPartOfCompilation", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add(new NeverPartOfCompilationNode("CompilerAsserts.neverPartOfCompilation()"));
                return true;
            }
        });
        r.register1("neverPartOfCompilation", (Type)((Object)String.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                if (message.isConstant()) {
                    String messageString = message.asConstant().toValueString();
                    b.add(new NeverPartOfCompilationNode(messageString));
                    return true;
                }
                throw b.bailout("message for never part of compilation is non-constant");
            }
        });
    }

    public static void registerOptimizedCallTargetPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, final boolean canDelayIntrinsification, final KnownTruffleTypes types, EconomicSet<ResolvedJavaType> primitiveBoxingTypes) {
        ResolvedJavaType optimizedCallTargetType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "org.graalvm.compiler.truffle.runtime.OptimizedCallTarget");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(optimizedCallTargetType));
        r.register2("createFrame", new InvocationPlugins.ResolvedJavaSymbol(types.classFrameDescriptor), (Type)((Object)Object[].class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode descriptor, ValueNode args) {
                if (canDelayIntrinsification) {
                    return false;
                }
                if (!descriptor.isJavaConstant()) {
                    throw b.bailout("Parameter 'descriptor' is not a compile-time constant");
                }
                ValueNode nonNullArguments = b.add(PiNode.create(args, StampFactory.objectNonNull(StampTool.typeReferenceOrNull(args))));
                b.addPush(JavaKind.Object, new NewFrameNode(b, descriptor, nonNullArguments, types));
                return true;
            }
        });
        r.register2("castArrayFixedLength", (Type)((Object)Object[].class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode args, ValueNode length) {
                if (canDelayIntrinsification) {
                    return false;
                }
                if (args.isConstant()) {
                    b.addPush(JavaKind.Object, args);
                    return true;
                }
                b.addPush(JavaKind.Object, new PiArrayNode(args, length, args.stamp(NodeView.DEFAULT)));
                return true;
            }
        });
        TruffleGraphBuilderPlugins.registerUnsafeCast(r, canDelayIntrinsification, primitiveBoxingTypes);
    }

    public static void registerFrameWithoutBoxingPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, boolean canDelayIntrinsification, ConstantReflectionProvider constantReflection, KnownTruffleTypes types, EconomicSet<ResolvedJavaType> primitiveBoxingTypes) {
        ResolvedJavaType frameWithoutBoxingType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.impl.FrameWithoutBoxing");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(frameWithoutBoxingType));
        TruffleGraphBuilderPlugins.registerFrameMethods(r, constantReflection, types);
        TruffleGraphBuilderPlugins.registerUnsafeCast(r, canDelayIntrinsification, primitiveBoxingTypes);
        TruffleGraphBuilderPlugins.registerUnsafeLoadStorePlugins(r, canDelayIntrinsification, null, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double, JavaKind.Object);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Object, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Long, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Int, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Double, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Float, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Boolean, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameAccessors(r, JavaKind.Byte, constantReflection, types);
        TruffleGraphBuilderPlugins.registerFrameTagAccessor(r);
        TruffleGraphBuilderPlugins.registerFrameAuxiliaryAccessors(r);
    }

    private static void registerFrameAccessors(InvocationPlugins.Registration r, final JavaKind accessKind, final ConstantReflectionProvider constantReflection, final KnownTruffleTypes types) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        final int accessTag = runtime.getFrameSlotKindTagForJavaKind(accessKind);
        String nameSuffix = accessKind.name();
        InvocationPlugins.ResolvedJavaSymbol frameSlotType = new InvocationPlugins.ResolvedJavaSymbol(types.classFrameSlot);
        r.register2("get" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), frameSlotType, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantFrameSlotIndex(frameNode, frameSlotNode, constantReflection, types);
                if (frameSlotIndex >= 0) {
                    b.addPush(accessKind, new VirtualFrameGetNode(frameNode, frameSlotIndex, accessKind, accessTag, VirtualFrameAccessType.Legacy));
                    return true;
                }
                return false;
            }
        });
        r.register3("set" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), frameSlotType, TruffleGraphBuilderPlugins.getJavaClass(accessKind), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantFrameSlotIndex(frameNode, frameSlotNode, constantReflection, types);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, accessTag, value, VirtualFrameAccessType.Legacy));
                    return true;
                }
                return false;
            }
        });
        r.register2("is" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), frameSlotType, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantFrameSlotIndex(frameNode, frameSlotNode, constantReflection, types);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Boolean, new VirtualFrameIsNode(frameNode, frameSlotIndex, accessTag, VirtualFrameAccessType.Legacy));
                    return true;
                }
                return false;
            }
        });
        r.register2("get" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(accessKind, new VirtualFrameGetNode(frameNode, frameSlotIndex, accessKind, accessTag, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
        r.register3("set" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, TruffleGraphBuilderPlugins.getJavaClass(accessKind), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, accessTag, value, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
        r.register2("is" + nameSuffix, (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Boolean, new VirtualFrameIsNode(frameNode, frameSlotIndex, accessTag, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerFrameTagAccessor(InvocationPlugins.Registration r) {
        r.register2("getTag", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Boolean, new VirtualFrameGetTagNode(frameNode, frameSlotIndex));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerFrameAuxiliaryAccessors(InvocationPlugins.Registration r) {
        TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
        final int accessTag = runtime.getFrameSlotKindTagForJavaKind(JavaKind.Object);
        r.register2("getAuxiliarySlot", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.addPush(JavaKind.Object, new VirtualFrameGetNode(frameNode, frameSlotIndex, JavaKind.Object, accessTag, VirtualFrameAccessType.Auxiliary));
                    return true;
                }
                return false;
            }
        });
        r.register3("setAuxiliarySlot", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ValueNode value) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(frameNode, frameSlotNode);
                if (frameSlotIndex >= 0) {
                    b.add(new VirtualFrameSetNode(frameNode, frameSlotIndex, accessTag, value, VirtualFrameAccessType.Auxiliary));
                    return true;
                }
                return false;
            }
        });
    }

    static int maybeGetConstantFrameSlotIndex(InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode, ConstantReflectionProvider constantReflection, KnownTruffleTypes types) {
        int index;
        NewFrameNode newFrameNode;
        ValueNode frameNodeValue;
        if (frameSlotNode.isConstant() && (frameNodeValue = frameNode.get(false)) instanceof NewFrameNode && (newFrameNode = (NewFrameNode)frameNodeValue).getIntrinsifyAccessors() && newFrameNode.isValidSlotIndex(index = constantReflection.readFieldValue(types.fieldFrameSlotIndex, frameSlotNode.asJavaConstant()).asInt())) {
            return index;
        }
        return -1;
    }

    static int maybeGetConstantNumberedFrameSlotIndex(InvocationPlugin.Receiver frameNode, ValueNode frameSlotNode) {
        int index;
        NewFrameNode newFrameNode;
        ValueNode frameNodeValue;
        if (frameSlotNode.isConstant() && (frameNodeValue = frameNode.get(false)) instanceof NewFrameNode && (newFrameNode = (NewFrameNode)frameNodeValue).getIntrinsifyAccessors() && newFrameNode.isValidIndexedSlotIndex(index = frameSlotNode.asJavaConstant().asInt())) {
            return index;
        }
        return -1;
    }

    private static void registerFrameMethods(InvocationPlugins.Registration r, final ConstantReflectionProvider constantReflection, final KnownTruffleTypes types) {
        r.register1("getArguments", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frame) {
                if (frame.get(false) instanceof NewFrameNode) {
                    b.push(JavaKind.Object, ((NewFrameNode)frame.get()).getArguments());
                    return true;
                }
                return false;
            }
        });
        r.register1("getFrameDescriptor", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver frame) {
                if (frame.get(false) instanceof NewFrameNode) {
                    b.push(JavaKind.Object, ((NewFrameNode)frame.get()).getDescriptor());
                    return true;
                }
                return false;
            }
        });
        r.register1("materialize", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode frame = receiver.get();
                if (frame instanceof NewFrameNode && ((NewFrameNode)frame).getIntrinsifyAccessors()) {
                    SpeculationLog.Speculation speculation = b.getGraph().getSpeculationLog().speculate(((NewFrameNode)frame).getIntrinsifyAccessorsSpeculation());
                    b.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint, speculation));
                    return true;
                }
                b.addPush(JavaKind.Object, new AllowMaterializeNode(frame));
                return true;
            }
        });
        r.register2("clear", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugins.ResolvedJavaSymbol(types.classFrameSlot), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantFrameSlotIndex(receiver, frameSlot, constantReflection, types);
                if (frameSlotIndex >= 0) {
                    TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, runtime.getFrameSlotKindTagForJavaKind(JavaKind.Illegal), VirtualFrameAccessType.Legacy));
                    return true;
                }
                return false;
            }
        });
        r.register2("clear", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot) {
                int frameSlotIndex = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot);
                if (frameSlotIndex >= 0) {
                    TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
                    b.add(new VirtualFrameClearNode(receiver, frameSlotIndex, runtime.getFrameSlotKindTagForJavaKind(JavaKind.Illegal), VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
        r.register3("swap", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameSwapNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
        r.register3("copy", (Type)((Object)InvocationPlugin.Receiver.class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode frameSlot1, ValueNode frameSlot2) {
                int frameSlot1Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot1);
                int frameSlot2Index = TruffleGraphBuilderPlugins.maybeGetConstantNumberedFrameSlotIndex(receiver, frameSlot2);
                if (frameSlot1Index >= 0 && frameSlot2Index >= 0) {
                    b.add(new VirtualFrameCopyNode(receiver, frameSlot1Index, frameSlot2Index, VirtualFrameAccessType.Indexed));
                    return true;
                }
                return false;
            }
        });
    }

    public static void registerNodePlugins(InvocationPlugins plugins, final MetaAccessProvider metaAccess, final boolean canDelayIntrinsification, final ConstantReflectionProvider constantReflection, final KnownTruffleTypes types) {
        ResolvedJavaType nodeType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.nodes.Node");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(nodeType));
        r.register1("getRootNodeImpl", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant prevNode;
                if (canDelayIntrinsification) {
                    return false;
                }
                ValueNode thisValue = receiver.get();
                if (!thisValue.isJavaConstant() || thisValue.isNullConstant()) {
                    throw b.bailout("getRootNode() receiver is not a compile-time constant or is null.");
                }
                int parentLimit = PEGraphDecoder.Options.MaximumLoopExplosionCount.getValue(b.getOptions());
                JavaConstant parentNode = thisValue.asJavaConstant();
                int parentsVisited = 0;
                do {
                    if (parentsVisited++ <= parentLimit) continue;
                    throw b.bailout("getRootNode() did not terminate in " + parentLimit + " iterations.");
                } while ((parentNode = constantReflection.readFieldValue(types.fieldNodeParent, prevNode = parentNode)).isNonNull());
                JavaConstant rootNode = prevNode;
                ConstantNode result = ConstantNode.forConstant(rootNode, metaAccess, b.getGraph());
                if (rootNode.isNonNull() && !types.classRootNode.isAssignableFrom(result.stamp(NodeView.DEFAULT).javaType(metaAccess))) {
                    result = ConstantNode.defaultForKind(JavaKind.Object, b.getGraph());
                }
                b.addPush(JavaKind.Object, result);
                return true;
            }
        });
    }

    public static void registerUnsafeCast(InvocationPlugins.Registration r, final boolean canDelayIntrinsification, final EconomicSet<ResolvedJavaType> primitiveBoxTypes) {
        r.register5("unsafeCast", (Type)((Object)Object.class), (Type)((Object)Class.class), Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode clazz, ValueNode condition, ValueNode nonNull, ValueNode isExactType) {
                if (clazz.isConstant() && nonNull.isConstant() && isExactType.isConstant()) {
                    ConstantReflectionProvider constantReflection = b.getConstantReflection();
                    ResolvedJavaType javaType = constantReflection.asJavaType(clazz.asConstant());
                    if (javaType == null) {
                        b.push(JavaKind.Object, object);
                    } else {
                        TypeReference type;
                        if (isExactType.asJavaConstant().asInt() != 0) {
                            assert (javaType.isConcrete() || javaType.isArray()) : "exact type is not a concrete class: " + javaType;
                            type = TypeReference.createExactTrusted(javaType);
                        } else {
                            type = TypeReference.createTrusted(b.getAssumptions(), javaType);
                        }
                        ObjectStamp piStamp = StampFactory.object(type, nonNull.asJavaConstant().asInt() != 0);
                        ConditionAnchorNode valueAnchorNode = null;
                        if (!condition.isConstant() || condition.asJavaConstant().asInt() != 1) {
                            LogicConstantNode logicConstantNode;
                            boolean skipAnchor = false;
                            LogicNode compareNode = CompareNode.createCompareNode(object.graph(), CanonicalCondition.EQ, condition, ConstantNode.forBoolean(true, object.graph()), constantReflection, NodeView.DEFAULT);
                            if (compareNode instanceof LogicConstantNode && (logicConstantNode = (LogicConstantNode)compareNode).getValue()) {
                                skipAnchor = true;
                            }
                            if (!skipAnchor) {
                                valueAnchorNode = b.add(new ConditionAnchorNode(compareNode));
                            }
                        }
                        b.addPush(JavaKind.Object, TruffleGraphBuilderPlugins.trustedBox(type, (EconomicSet<ResolvedJavaType>)primitiveBoxTypes, PiNode.create(object, piStamp, valueAnchorNode)));
                    }
                    return true;
                }
                if (canDelayIntrinsification) {
                    return false;
                }
                TruffleGraphBuilderPlugins.logPerformanceWarningUnsafeCastArgNotConst(targetMethod, clazz, nonNull, isExactType);
                b.push(JavaKind.Object, object);
                return true;
            }
        });
    }

    private static ValueNode trustedBox(TypeReference type, EconomicSet<ResolvedJavaType> primitiveBoxTypes, ValueNode v) {
        if (primitiveBoxTypes.contains((Object)type.getType())) {
            return new BoxNode.TrustedBoxedValue(v);
        }
        return v;
    }

    public static void registerUnsafeLoadStorePlugins(InvocationPlugins.Registration r, boolean canDelayIntrinsification, JavaConstant anyConstant, JavaKind ... kinds) {
        for (JavaKind kind : kinds) {
            String kindName = kind.getJavaName();
            kindName = Character.toUpperCase(kindName.charAt(0)) + kindName.substring(1);
            String getName = "unsafeGet" + kindName;
            String putName = "unsafePut" + kindName;
            r.register4(getName, (Type)((Object)Object.class), Long.TYPE, Boolean.TYPE, (Type)((Object)Object.class), new CustomizedUnsafeLoadPlugin(kind, canDelayIntrinsification));
            r.register4(putName, (Type)((Object)Object.class), Long.TYPE, TruffleGraphBuilderPlugins.getJavaClass(kind), (Type)((Object)Object.class), new CustomizedUnsafeStorePlugin(kind, anyConstant, canDelayIntrinsification));
        }
    }

    static void logPerformanceWarningLocationNotConstant(ValueNode location, ResolvedJavaMethod targetMethod, UnsafeAccessNode access) {
        if (PerformanceInformationHandler.isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE)) {
            StructuredGraph graph = location.graph();
            DebugContext debug = access.getDebug();
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                TruffleDebugJavaMethod truffleMethod = debug.contextLookup(TruffleDebugJavaMethod.class);
                if (truffleMethod != null) {
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    properties.put("location", location);
                    properties.put("method", targetMethod.format("%h.%n"));
                    PerformanceInformationHandler.logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE, truffleMethod.getCompilable(), Collections.singletonList(access), "location argument not PE-constant", properties);
                    debug.dump(3, (Object)graph, "perf warn: Location argument is not a partial evaluation constant: %s", location);
                }
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
    }

    static void logPerformanceWarningUnsafeCastArgNotConst(ResolvedJavaMethod targetMethod, ValueNode type, ValueNode nonNull, ValueNode isExactType) {
        if (PerformanceInformationHandler.isWarningEnabled(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE)) {
            StructuredGraph graph = type.graph();
            DebugContext debug = type.getDebug();
            try (DebugContext.Scope s = debug.scope((Object)"TrufflePerformanceWarnings", graph);){
                TruffleDebugJavaMethod truffleMethod = debug.contextLookup(TruffleDebugJavaMethod.class);
                if (truffleMethod != null) {
                    LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                    ArrayList<ValueNode> nonConstArgs = new ArrayList<ValueNode>();
                    properties.put("type", type);
                    if (!type.isConstant()) {
                        nonConstArgs.add(type);
                    }
                    properties.put("nonNull", nonNull);
                    if (!nonNull.isConstant()) {
                        nonConstArgs.add(nonNull);
                    }
                    properties.put("exactType", isExactType);
                    if (!isExactType.isConstant()) {
                        nonConstArgs.add(isExactType);
                    }
                    properties.put("method", targetMethod.format("%h.%n"));
                    PerformanceInformationHandler.logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind.VIRTUAL_STORE, truffleMethod.getCompilable(), nonConstArgs, "unsafeCast arguments could not reduce to a constant", properties);
                    debug.dump(3, graph, "perf warn: unsafeCast arguments could not reduce to a constant: %s, %s, %s", type, nonNull, isExactType);
                }
            }
            catch (Throwable t) {
                debug.handle(t);
            }
        }
    }

    static BailoutException failPEConstant(GraphBuilderContext b, ValueNode value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (value instanceof ValuePhiNode) {
            ValuePhiNode valuePhi = (ValuePhiNode)value;
            sb.append(" (");
            for (Node n : valuePhi.inputs()) {
                sb.append(n);
                sb.append("; ");
            }
            sb.append(")");
        }
        value.getDebug().dump(3, (Object)value.graph(), "Graph before bailout at node %s", sb);
        throw b.bailout("Partial evaluation did not reduce value to a constant, is a regular compiler node: " + sb);
    }

    private static final class PEConstantPlugin
    implements InvocationPlugin {
        private final boolean canDelayIntrinsification;

        private PEConstantPlugin(boolean canDelayIntrinsification) {
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
            ValueNode curValue = value;
            if (curValue instanceof BoxNode) {
                BoxNode boxNode = (BoxNode)curValue;
                curValue = boxNode.getValue();
            }
            if (curValue.isConstant()) {
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            throw TruffleGraphBuilderPlugins.failPEConstant(b, value);
        }
    }

    static class CustomizedUnsafeStorePlugin
    implements InvocationPlugin {
        private final JavaKind kind;
        private final JavaConstant anyConstant;
        private final boolean canDelayIntrinsification;

        CustomizedUnsafeStorePlugin(JavaKind kind, JavaConstant anyConstant, boolean canDelayIntrinsification) {
            this.kind = kind;
            this.anyConstant = anyConstant;
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode offset, ValueNode value, ValueNode location) {
            ValueNode locationArgument = location;
            if (locationArgument.isConstant()) {
                boolean forceLocation;
                LocationIdentity locationIdentity;
                if (locationArgument.isNullConstant()) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = false;
                } else if (locationArgument.asJavaConstant().equals(this.anyConstant)) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = true;
                } else {
                    locationIdentity = ObjectLocationIdentity.create(locationArgument.asJavaConstant());
                    forceLocation = true;
                }
                b.add(new RawStoreNode(object, offset, value, this.kind, locationIdentity, true, null, forceLocation));
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            RawStoreNode store = b.add(new RawStoreNode(object, offset, value, this.kind, LocationIdentity.any(), true, null, true));
            TruffleGraphBuilderPlugins.logPerformanceWarningLocationNotConstant(location, targetMethod, store);
            return true;
        }
    }

    static class CustomizedUnsafeLoadPlugin
    implements InvocationPlugin {
        private final JavaKind returnKind;
        private final boolean canDelayIntrinsification;

        CustomizedUnsafeLoadPlugin(JavaKind returnKind, boolean canDelayIntrinsification) {
            this.returnKind = returnKind;
            this.canDelayIntrinsification = canDelayIntrinsification;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode offset, ValueNode condition, ValueNode location) {
            if (location.isConstant()) {
                boolean forceLocation;
                LocationIdentity locationIdentity;
                if (location.isNullConstant()) {
                    locationIdentity = LocationIdentity.any();
                    forceLocation = false;
                } else {
                    locationIdentity = ObjectLocationIdentity.create(location.asJavaConstant());
                    forceLocation = true;
                }
                LogicNode compare = b.add(CompareNode.createCompareNode(b.getConstantReflection(), b.getMetaAccess(), b.getOptions(), null, CanonicalCondition.EQ, condition, ConstantNode.forBoolean(true, object.graph()), NodeView.DEFAULT));
                ConditionAnchorNode anchor = b.add(new ConditionAnchorNode(compare));
                b.addPush(this.returnKind, b.add(new GuardedUnsafeLoadNode(b.addNonNullCast(object), offset, this.returnKind, locationIdentity, anchor, forceLocation)));
                return true;
            }
            if (this.canDelayIntrinsification) {
                return false;
            }
            RawLoadNode load = b.addPush(this.returnKind, new RawLoadNode(object, offset, this.returnKind, LocationIdentity.any(), true));
            TruffleGraphBuilderPlugins.logPerformanceWarningLocationNotConstant(location, targetMethod, load);
            return true;
        }
    }
}

