/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaAccessProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CompilationTask;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotFastThreadLocal;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotThreadLocalHandshake;
import sun.misc.Unsafe;

public abstract class AbstractHotSpotTruffleRuntime
extends GraalTruffleRuntime
implements HotSpotTruffleCompilerRuntime {
    static final int JAVA_SPEC = AbstractHotSpotTruffleRuntime.getJavaSpecificationVersion();
    static final Unsafe UNSAFE = AbstractHotSpotTruffleRuntime.getUnsafe();
    private volatile boolean traceTransferToInterpreter;
    private Boolean profilingEnabled;
    private volatile Lazy lazy;
    private volatile String lazyConfigurationName;
    private volatile CompilationTask initializationTask;
    private volatile boolean truffleCompilerInitialized;
    private volatile Throwable truffleCompilerInitializationException;
    private final HotSpotVMConfigAccess vmConfigAccess;
    private final int jvmciReservedLongOffset0;
    private final int jvmciReservedReference0Offset;
    private final MethodHandle setJVMCIReservedReference0;
    private final MethodHandle getJVMCIReservedReference0;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lazy lazy() {
        if (this.lazy == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                if (this.lazy == null) {
                    this.lazy = new Lazy(this);
                }
            }
        }
        return this.lazy;
    }

    public AbstractHotSpotTruffleRuntime() {
        super(Arrays.asList(HotSpotOptimizedCallTarget.class, InstalledCode.class, HotSpotThreadLocalHandshake.class));
        int longOffset;
        AbstractHotSpotTruffleRuntime.installCallBoundaryMethods(null);
        this.vmConfigAccess = new HotSpotVMConfigAccess(HotSpotJVMCIRuntime.runtime().getConfigStore());
        try {
            longOffset = (Integer)this.vmConfigAccess.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "jlong", (Object)-1);
        }
        catch (NoSuchMethodError error) {
            longOffset = -1;
        }
        catch (JVMCIError error) {
            try {
                longOffset = (Integer)this.vmConfigAccess.getFieldOffset("JavaThread::_jvmci_reserved0", Integer.class, "intptr_t*", (Object)-1);
            }
            catch (NoSuchMethodError e) {
                longOffset = -1;
            }
        }
        this.jvmciReservedLongOffset0 = longOffset;
        this.jvmciReservedReference0Offset = (Integer)this.vmConfigAccess.getFieldOffset("JavaThread::_jvmci_reserved_oop0", Integer.class, "oop", (Object)-1);
        MethodHandle setReservedReference0 = null;
        MethodHandle getReservedReference0 = null;
        if (this.jvmciReservedReference0Offset != -1) {
            AbstractHotSpotTruffleRuntime.installReservedOopMethods(null);
            try {
                setReservedReference0 = MethodHandles.lookup().findVirtual(HotSpotJVMCIRuntime.class, "setThreadLocalObject", MethodType.methodType(Void.TYPE, Integer.TYPE, Object.class));
                getReservedReference0 = MethodHandles.lookup().findVirtual(HotSpotJVMCIRuntime.class, "getThreadLocalObject", MethodType.methodType(Object.class, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.setJVMCIReservedReference0 = setReservedReference0;
        this.getJVMCIReservedReference0 = getReservedReference0;
    }

    public final int getJVMCIReservedLongOffset0() {
        return this.jvmciReservedLongOffset0;
    }

    @Override
    public final ThreadLocalHandshake getThreadLocalHandshake() {
        return HotSpotThreadLocalHandshake.SINGLETON;
    }

    @Override
    protected StackIntrospection getStackIntrospection() {
        Lazy l = this.lazy();
        if (l.stackIntrospection == null) {
            l.stackIntrospection = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getStackIntrospection();
        }
        return l.stackIntrospection;
    }

    @Override
    public HotSpotTruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        if (this.truffleCompiler == null) {
            this.initializeTruffleCompiler((OptimizedCallTarget)compilable);
            this.rethrowTruffleCompilerInitializationException();
            assert (this.truffleCompiler != null) : "TruffleCompiler must be non null";
        }
        return (HotSpotTruffleCompiler)this.truffleCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(final OptimizedCallTarget firstCallTarget) {
        if (this.truffleCompilerInitialized) {
            return;
        }
        CompilationTask localTask = this.initializationTask;
        if (localTask == null) {
            AbstractHotSpotTruffleRuntime lock;
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = lock = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                localTask = this.initializationTask;
                if (localTask == null && !this.truffleCompilerInitialized) {
                    this.rethrowTruffleCompilerInitializationException();
                    this.initializationTask = localTask = this.getCompileQueue().submitInitialization(firstCallTarget, new Consumer<CompilationTask>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(CompilationTask task) {
                            Object object = lock;
                            synchronized (object) {
                                AbstractHotSpotTruffleRuntime.this.initializeTruffleCompiler(firstCallTarget);
                                assert (AbstractHotSpotTruffleRuntime.this.truffleCompilerInitialized || AbstractHotSpotTruffleRuntime.this.truffleCompilerInitializationException != null);
                                assert (AbstractHotSpotTruffleRuntime.this.initializationTask != null);
                                AbstractHotSpotTruffleRuntime.this.initializationTask = null;
                            }
                        }
                    });
                }
            }
        }
        if (localTask != null) {
            firstCallTarget.maybeWaitForTask(localTask);
            this.rethrowTruffleCompilerInitializationException();
        } else assert (this.truffleCompilerInitialized || this.truffleCompilerInitializationException != null);
    }

    @Override
    public boolean isLatestJVMCI() {
        if (this.getJVMCIReservedReference0 == null) {
            return false;
        }
        return this.getJVMCIReservedLongOffset0() != -1;
    }

    public final void resetCompiler() {
        this.truffleCompiler = null;
        this.truffleCompilerInitialized = false;
        this.truffleCompilerInitializationException = null;
    }

    private synchronized void initializeTruffleCompiler(OptimizedCallTarget callTarget) {
        if (!this.truffleCompilerInitialized) {
            this.rethrowTruffleCompilerInitializationException();
            try {
                EngineData engine = callTarget.engine;
                this.profilingEnabled = engine.profilingEnabled;
                HotSpotTruffleCompiler compiler = (HotSpotTruffleCompiler)this.newTruffleCompiler();
                compiler.initialize(AbstractHotSpotTruffleRuntime.getOptionsForCompiler(callTarget), callTarget, true);
                AbstractHotSpotTruffleRuntime.installCallBoundaryMethods(compiler);
                if (this.jvmciReservedReference0Offset != -1) {
                    AbstractHotSpotTruffleRuntime.installReservedOopMethods(compiler);
                }
                this.truffleCompiler = compiler;
                this.traceTransferToInterpreter = engine.traceTransferToInterpreter;
                this.truffleCompilerInitialized = true;
            }
            catch (Throwable e) {
                this.truffleCompilerInitializationException = e;
            }
        }
    }

    private void rethrowTruffleCompilerInitializationException() {
        if (this.truffleCompilerInitializationException != null) {
            throw AbstractHotSpotTruffleRuntime.sthrow(RuntimeException.class, this.truffleCompilerInitializationException);
        }
    }

    private static <T extends Throwable> T sthrow(Class<T> type, Throwable t) throws T {
        throw t;
    }

    @Override
    public final OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        HotSpotOptimizedCallTarget target = new HotSpotOptimizedCallTarget(source, rootNode);
        this.ensureInitialized(target);
        return target;
    }

    @Override
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        HotSpotOptimizedCallTarget callTarget = (HotSpotOptimizedCallTarget)compilable;
        callTarget.setInstalledCode(installedCode);
    }

    @Override
    public SpeculationLog createSpeculationLog() {
        return new HotSpotSpeculationLog();
    }

    public static void setDontInlineCallBoundaryMethod(List<ResolvedJavaMethod> callBoundaryMethods) {
        for (ResolvedJavaMethod method : callBoundaryMethods) {
            AbstractHotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    static MetaAccessProvider getMetaAccess() {
        return JVMCI.getRuntime().getHostJVMCIBackend().getMetaAccess();
    }

    private static void setNotInlinableOrCompilable(ResolvedJavaMethod method) {
        Method[] methods;
        for (Method m : methods = HotSpotResolvedJavaMethod.class.getMethods()) {
            if (!m.getName().equals("setNotInlineable") && !m.getName().equals("setNotInlinableOrCompilable") && !m.getName().equals("setNotInlineableOrCompileable")) continue;
            try {
                m.invoke((Object)method, new Object[0]);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        throw new InternalError(String.format("Could not find setNotInlineable, setNotInlinableOrCompilable or setNotInlineableOrCompileable in %s", HotSpotResolvedJavaMethod.class));
    }

    @Override
    public BackgroundCompileQueue getCompileQueue() {
        return this.lazy();
    }

    @Override
    protected String getCompilerConfigurationName() {
        TruffleCompiler compiler = this.truffleCompiler;
        String compilerConfig = compiler != null ? compiler.getCompilerConfigurationName() : this.getLazyCompilerConfigurationName();
        return compilerConfig;
    }

    private boolean verifyCompilerConfiguration(String name) {
        String lazyName = this.getLazyCompilerConfigurationName();
        if (!name.equals(lazyName)) {
            throw new AssertionError((Object)("Expected compiler configuration name " + name + " but was " + lazyName + "."));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLazyCompilerConfigurationName() {
        String compilerConfig = this.lazyConfigurationName;
        if (compilerConfig == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                compilerConfig = this.lazyConfigurationName;
                if (compilerConfig == null) {
                    this.lazyConfigurationName = compilerConfig = this.initLazyCompilerConfigurationName();
                }
            }
        }
        return compilerConfig;
    }

    protected abstract String initLazyCompilerConfigurationName();

    @Override
    public void bypassedInstalledCode(OptimizedCallTarget target) {
        if (!this.truffleCompilerInitialized) {
            return;
        }
        AbstractHotSpotTruffleRuntime.installCallBoundaryMethods((HotSpotTruffleCompiler)this.truffleCompiler);
    }

    public MethodHandle getSetThreadLocalObject() {
        return this.setJVMCIReservedReference0;
    }

    public MethodHandle getGetThreadLocalObject() {
        return this.getJVMCIReservedReference0;
    }

    public boolean bypassedReservedOop(boolean waitForInit) {
        if (this.jvmciReservedReference0Offset == -1) {
            throw CompilerDirectives.shouldNotReachHere((String)"bypassedReservedOop without field available. default fast thread locals should be used instead.");
        }
        CompilationTask task = this.initializationTask;
        if (task != null) {
            while (waitForInit) {
                try {
                    task.awaitCompletion();
                    break;
                }
                catch (ExecutionException e) {
                    throw new AssertionError("Initialization failed.", e);
                }
                catch (InterruptedException e) {
                }
            }
            return true;
        }
        if (!this.truffleCompilerInitialized) {
            if (this.truffleCompilerInitializationException != null) {
                throw new AssertionError("Compiler initialization failed cannot continue.", this.truffleCompilerInitializationException);
            }
            return false;
        }
        AbstractHotSpotTruffleRuntime.installReservedOopMethods((HotSpotTruffleCompiler)this.truffleCompiler);
        return true;
    }

    private static void installCallBoundaryMethods(HotSpotTruffleCompiler compiler) {
        ResolvedJavaType type = AbstractHotSpotTruffleRuntime.getMetaAccess().lookupJavaType(OptimizedCallTarget.class);
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            if (method.getAnnotation(TruffleCallBoundary.class) == null) continue;
            if (compiler != null) {
                compiler.installTruffleCallBoundaryMethod(method);
                continue;
            }
            AbstractHotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    private static void installReservedOopMethods(HotSpotTruffleCompiler compiler) {
        ResolvedJavaType local = AbstractHotSpotTruffleRuntime.getMetaAccess().lookupJavaType(HotSpotFastThreadLocal.class);
        block7: for (ResolvedJavaMethod method : local.getDeclaredMethods()) {
            String name;
            switch (name = method.getName()) {
                case "set": 
                case "get": {
                    if (compiler != null) {
                        compiler.installTruffleReservedOopMethod(method);
                        continue block7;
                    }
                    AbstractHotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
                }
            }
        }
    }

    @Override
    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (this.callMethods == null) {
            this.lookupCallMethods(AbstractHotSpotTruffleRuntime.getMetaAccess());
        }
        return this.callMethods;
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.traceTransferToInterpreter) {
            TruffleCompiler compiler = this.truffleCompiler;
            assert (compiler != null);
            TraceTransferToInterpreterHelper.traceTransferToInterpreter(this, (HotSpotTruffleCompiler)compiler);
        }
    }

    public final boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            return true;
        }
        return this.profilingEnabled;
    }

    @Override
    protected JavaConstant forObject(Object object) {
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getConstantReflection();
        return constantReflection.forObject(object);
    }

    @Override
    protected int getBaseInstanceSize(Class<?> type) {
        if (type.isArray() || type.isPrimitive()) {
            throw new IllegalArgumentException("Class " + type.getName() + " is a primitive type or an array class!");
        }
        HotSpotMetaAccessProvider meta = (HotSpotMetaAccessProvider)AbstractHotSpotTruffleRuntime.getMetaAccess();
        HotSpotResolvedObjectType resolvedType = (HotSpotResolvedObjectType)meta.lookupJavaType(type);
        return resolvedType.instanceSize();
    }

    private static boolean fieldIsNotEligible(Class<?> clazz, ResolvedJavaField f) {
        return Reference.class.isAssignableFrom(clazz) && f.getDeclaringClass().isAssignableFrom(AbstractHotSpotTruffleRuntime.getMetaAccess().lookupJavaType(Reference.class));
    }

    @Override
    protected Object[] getResolvedFields(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        if (type.isArray() || type.isPrimitive()) {
            throw new IllegalArgumentException("Class " + type.getName() + " is a primitive type or an array class!");
        }
        HotSpotMetaAccessProvider meta = (HotSpotMetaAccessProvider)AbstractHotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType javaType = meta.lookupJavaType(type);
        ResolvedJavaField[] fields = javaType.getInstanceFields(includeSuperclasses);
        ResolvedJavaField[] fieldsToReturn = new ResolvedJavaField[fields.length];
        int fieldsCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            ResolvedJavaField f = fields[i];
            if (!includePrimitive && f.getJavaKind().isPrimitive() || AbstractHotSpotTruffleRuntime.fieldIsNotEligible(type, f)) continue;
            fieldsToReturn[fieldsCount++] = f;
        }
        return Arrays.copyOf(fieldsToReturn, fieldsCount);
    }

    @Override
    protected Object getFieldValue(ResolvedJavaField resolvedJavaField, Object obj) {
        assert (obj != null);
        assert (!resolvedJavaField.isStatic());
        assert (resolvedJavaField.getJavaKind() == JavaKind.Object);
        assert (resolvedJavaField.getDeclaringClass().isAssignableFrom(AbstractHotSpotTruffleRuntime.getMetaAccess().lookupJavaType(obj.getClass())));
        Object value = resolvedJavaField.isVolatile() ? UNSAFE.getObjectVolatile(obj, resolvedJavaField.getOffset()) : UNSAFE.getObject(obj, resolvedJavaField.getOffset());
        return value;
    }

    private <T> T getVMOptionValue(String name, Class<T> type) {
        try {
            return (T)this.vmConfigAccess.getFlag(name, type);
        }
        catch (JVMCIError jvmciError) {
            throw new IllegalArgumentException(jvmciError);
        }
    }

    @Override
    protected int getObjectAlignment() {
        return this.getVMOptionValue("ObjectAlignmentInBytes", Integer.class);
    }

    @Override
    protected int getArrayIndexScale(Class<?> componentType) {
        MetaAccessProvider meta = AbstractHotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType resolvedType = meta.lookupJavaType(componentType);
        return ((HotSpotJVMCIRuntime)JVMCI.getRuntime()).getArrayIndexScale(resolvedType.getJavaKind());
    }

    @Override
    protected int getArrayBaseOffset(Class<?> componentType) {
        MetaAccessProvider meta = AbstractHotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType resolvedType = meta.lookupJavaType(componentType);
        return ((HotSpotJVMCIRuntime)JVMCI.getRuntime()).getArrayBaseOffset(resolvedType.getJavaKind());
    }

    private static int getJavaSpecificationVersion() {
        String value = (String)Services.getSavedProperties().get("java.specification.version");
        if (value.startsWith("1.")) {
            value = value.substring(2);
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getStackOverflowLimit() {
        try {
            int stackOverflowLimitOffset = (Integer)this.vmConfigAccess.getFieldOffset(JAVA_SPEC >= 16 ? "JavaThread::_stack_overflow_state._stack_overflow_limit" : "JavaThread::_stack_overflow_limit", Integer.class, "address");
            long threadEETopOffset = UNSAFE.objectFieldOffset(Thread.class.getDeclaredField("eetop"));
            long eetop = UNSAFE.getLong(Thread.currentThread(), threadEETopOffset);
            return UNSAFE.getLong(eetop + (long)stackOverflowLimitOffset);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
        return (T)hsConstant.asObject(type);
    }

    @Override
    protected AbstractFastThreadLocal getFastThreadLocalImpl() {
        if (this.jvmciReservedReference0Offset != -1) {
            return HotSpotFastThreadLocal.SINGLETON;
        }
        return null;
    }

    public static AbstractHotSpotTruffleRuntime getRuntime() {
        return (AbstractHotSpotTruffleRuntime)GraalTruffleRuntime.getRuntime();
    }

    private static class TraceTransferToInterpreterHelper {
        private static final long THREAD_EETOP_OFFSET;

        private TraceTransferToInterpreterHelper() {
        }

        static void traceTransferToInterpreter(AbstractHotSpotTruffleRuntime runtime, HotSpotTruffleCompiler compiler) {
            boolean deoptimized;
            FrameInstance currentFrame = runtime.getCurrentFrame();
            if (currentFrame == null) {
                return;
            }
            OptimizedCallTarget callTarget = (OptimizedCallTarget)currentFrame.getCallTarget();
            long thread = UNSAFE.getLong(Thread.currentThread(), THREAD_EETOP_OFFSET);
            long pendingTransferToInterpreterAddress = thread + (long)compiler.pendingTransferToInterpreterOffset(callTarget);
            boolean bl = deoptimized = UNSAFE.getByte(pendingTransferToInterpreterAddress) != 0;
            if (deoptimized) {
                GraalTruffleRuntime.StackTraceHelper.logHostAndGuestStacktrace("transferToInterpreter", callTarget);
                UNSAFE.putByte(pendingTransferToInterpreterAddress, (byte)0);
            }
        }

        static {
            try {
                THREAD_EETOP_OFFSET = UNSAFE.objectFieldOffset(Thread.class.getDeclaredField("eetop"));
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    static final class Lazy
    extends BackgroundCompileQueue {
        StackIntrospection stackIntrospection;

        Lazy(AbstractHotSpotTruffleRuntime runtime) {
            super(runtime);
            runtime.installDefaultListeners();
        }

        @Override
        protected void compilerThreadIdled() {
            TruffleCompiler compiler = ((AbstractHotSpotTruffleRuntime)this.runtime).truffleCompiler;
            if (compiler != null) {
                ((HotSpotTruffleCompiler)compiler).purgeCaches();
            }
        }
    }
}

