/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.java;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleCompilerImpl;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;

final class HotSpotTruffleRuntime
extends AbstractHotSpotTruffleRuntime {
    HotSpotTruffleRuntime() {
    }

    @Override
    public <T> T getGraalOptions(Class<T> optionValuesType) {
        if (optionValuesType == OptionValues.class) {
            return optionValuesType.cast(HotSpotGraalOptionValues.defaultOptions());
        }
        return (T)super.getGraalOptions(optionValuesType);
    }

    @Override
    protected boolean isPrintGraphEnabled() {
        return DebugOptions.PrintGraph.getValue(this.getGraalOptions(OptionValues.class)) != DebugOptions.PrintGraphTarget.Disable;
    }

    @Override
    protected String initLazyCompilerConfigurationName() {
        OptionValues options = this.getGraalOptions(OptionValues.class);
        String factoryName = HotSpotTruffleCompilerImpl.Options.TruffleCompilerConfiguration.getValue(options);
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        CompilerConfigurationFactory compilerConfigurationFactory = CompilerConfigurationFactory.selectFactory(factoryName, options, runtime);
        return compilerConfigurationFactory.getName();
    }

    @Override
    public TruffleCompiler newTruffleCompiler() {
        return HotSpotTruffleCompilerImpl.create(this);
    }
}

