/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.util.CompilationAlarm;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;
import org.graalvm.compiler.phases.common.util.LoopUtility;
import org.graalvm.compiler.phases.graph.ReentrantBlockIterator;
import org.graalvm.compiler.phases.schedule.SchedulePhase;

public abstract class EffectsPhase<CoreProvidersT extends CoreProviders>
extends BasePhase<CoreProvidersT> {
    private final int maxIterations;
    protected final CanonicalizerPhase canonicalizer;
    private final boolean unscheduled;
    private final SchedulePhase.SchedulingStrategy strategy;

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer) {
        this(maxIterations, canonicalizer, false, SchedulePhase.SchedulingStrategy.EARLIEST);
    }

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer, boolean unscheduled, SchedulePhase.SchedulingStrategy strategy) {
        this.strategy = strategy;
        this.maxIterations = maxIterations;
        this.canonicalizer = canonicalizer;
        this.unscheduled = unscheduled;
    }

    protected EffectsPhase(int maxIterations, CanonicalizerPhase canonicalizer, boolean unscheduled) {
        this(maxIterations, canonicalizer, unscheduled, unscheduled ? null : SchedulePhase.SchedulingStrategy.EARLIEST);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProvidersT context) {
        this.runAnalysis(graph, context);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runAnalysis(StructuredGraph graph, CoreProvidersT context) {
        LoopUtility.removeObsoleteProxies(graph, context, this.canonicalizer);
        assert (this.unscheduled || this.strategy != null);
        boolean changed = false;
        CompilationAlarm compilationAlarm = CompilationAlarm.current();
        DebugContext debug = graph.getDebug();
        int iteration = 0;
        while (iteration < this.maxIterations) {
            block53: {
                if (compilationAlarm.hasExpired()) return changed;
                try (DebugContext.Scope s = debug.scope(debug.areScopesEnabled() ? "iteration " + iteration : null);){
                    ControlFlowGraph cfg;
                    StructuredGraph.ScheduleResult schedule;
                    if (this.unscheduled) {
                        schedule = null;
                        cfg = ControlFlowGraph.compute(graph, true, true, false, false);
                    } else {
                        new SchedulePhase(this.strategy).apply(graph, context, false);
                        schedule = graph.getLastSchedule();
                        cfg = schedule.getCFG();
                    }
                    try {
                        Throwable throwable;
                        DebugContext.Scope scheduleScope;
                        block51: {
                            block52: {
                                scheduleScope = debug.scope((Object)"EffectsPhaseWithSchedule", schedule);
                                throwable = null;
                                Closure<?> closure = this.createEffectsClosure(context, schedule, cfg);
                                ReentrantBlockIterator.apply(closure, cfg.getStartBlock());
                                if (closure.needsApplyEffects()) {
                                    EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
                                    try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                                        closure.applyEffects();
                                        if (debug.isDumpEnabled(3)) {
                                            debug.dump(3, (Object)graph, "%s iteration", this.getName());
                                        }
                                        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
                                    }
                                    LoopUtility.removeObsoleteProxies(graph, context, this.canonicalizer);
                                    this.postIteration(graph, context, listener.getNodes());
                                }
                                if (closure.hasChanged()) {
                                    changed = true;
                                    break block51;
                                }
                                if (scheduleScope == null) return changed;
                                if (throwable == null) break block52;
                                try {
                                    scheduleScope.close();
                                    return changed;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return changed;
                                }
                            }
                            scheduleScope.close();
                            return changed;
                        }
                        if (scheduleScope == null) break block53;
                        if (throwable != null) {
                            try {
                                scheduleScope.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block53;
                        } else {
                            scheduleScope.close();
                        }
                        break block53;
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (scheduleScope == null) throw throwable5;
                                if (throwable == null) {
                                    scheduleScope.close();
                                    throw throwable5;
                                }
                                try {
                                    scheduleScope.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        throw debug.handle(t);
                    }
                }
            }
            ++iteration;
        }
        return changed;
    }

    protected void postIteration(StructuredGraph graph, CoreProvidersT context, EconomicSet<Node> changedNodes) {
        if (this.canonicalizer != null) {
            this.canonicalizer.applyIncremental(graph, (CoreProviders)context, (Iterable<? extends Node>)changedNodes);
        }
    }

    protected abstract Closure<?> createEffectsClosure(CoreProvidersT var1, StructuredGraph.ScheduleResult var2, ControlFlowGraph var3);

    public static abstract class Closure<T>
    extends ReentrantBlockIterator.BlockIteratorClosure<T> {
        public abstract boolean hasChanged();

        public abstract boolean needsApplyEffects();

        public abstract void applyEffects();
    }
}

