/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.jniutils.NativeBridgeSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class LibGraalNativeBridgeSupport
implements NativeBridgeSupport {
    private static final String JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME = "JNI_LIBGRAAL_TRACE_LEVEL";
    private static final int UNINITIALIZED_TRACE_LEVEL = Integer.MIN_VALUE;
    private final ThreadLocal<Boolean> inTrace = ThreadLocal.withInitial(() -> false);
    private final AtomicInteger traceLevel = new AtomicInteger(Integer.MIN_VALUE);

    @Override
    public String getFeatureName() {
        return "LIBGRAAL";
    }

    @Override
    public boolean isTracingEnabled(int level) {
        return this.traceLevel() >= level;
    }

    @Override
    public void trace(String message) {
        if (!this.inTrace.get().booleanValue()) {
            this.inTrace.set(true);
            try {
                TTY.println(message);
            }
            finally {
                this.inTrace.remove();
            }
        }
    }

    private int traceLevel() {
        int res = this.traceLevel.get();
        if (res == Integer.MIN_VALUE) {
            String var = (String)Services.getSavedProperties().get(JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME);
            if (var != null) {
                try {
                    res = Integer.parseInt(var);
                }
                catch (NumberFormatException e) {
                    TTY.printf("Invalid value for %s: %s%n", JNI_LIBGRAAL_TRACE_LEVEL_PROPERTY_NAME, e);
                    res = 0;
                }
            } else {
                res = 0;
            }
            this.traceLevel.set(res);
        }
        return res;
    }
}

