/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class ObjectSizeEstimate {
    private static final int UNCOMPRESSED_POINTER_SIZE = 8;
    private static final int UNCOMPRESSED_HEADER_SIZE = 16;
    private static final int COMPRESSED_POINTER_SIZE = 4;
    private static final int COMPRESSED_HEADER_SIZE = 12;
    private int headerCount;
    private int pointerCount;
    private int primitiveByteSize;

    public static ObjectSizeEstimate forObject(Object root) {
        return ObjectSizeEstimate.forObject(root, Integer.MAX_VALUE);
    }

    public static ObjectSizeEstimate forObject(Object root, int maxDepth) {
        return ObjectSizeEstimate.forObjectHelper(root, maxDepth);
    }

    private ObjectSizeEstimate() {
    }

    public ObjectSizeEstimate add(ObjectSizeEstimate other) {
        ObjectSizeEstimate result = new ObjectSizeEstimate();
        result.headerCount = this.headerCount + other.headerCount;
        result.primitiveByteSize = this.primitiveByteSize + other.primitiveByteSize;
        result.pointerCount = this.pointerCount + other.pointerCount;
        return result;
    }

    public ObjectSizeEstimate subtract(ObjectSizeEstimate other) {
        ObjectSizeEstimate result = new ObjectSizeEstimate();
        result.headerCount = this.headerCount - other.headerCount;
        result.primitiveByteSize = this.primitiveByteSize - other.primitiveByteSize;
        result.pointerCount = this.pointerCount - other.pointerCount;
        return result;
    }

    public int getHeaderCount() {
        return this.headerCount;
    }

    public int getPointerCount() {
        return this.pointerCount;
    }

    public int getPrimitiveByteSize() {
        return this.primitiveByteSize;
    }

    public String toString() {
        return String.format("(#headers=%s, #pointers=%s, #primitiveBytes=%s, totalCompressed=%s, totalNonCompressed=%s)", this.headerCount, this.pointerCount, this.primitiveByteSize, this.getCompressedTotalBytes(), this.getTotalBytes());
    }

    public int getCompressedTotalBytes() {
        return this.headerCount * 12 + this.pointerCount * 4 + this.primitiveByteSize;
    }

    public int getTotalBytes() {
        return this.headerCount * 16 + this.pointerCount * 8 + this.primitiveByteSize;
    }

    private void recordHeader() {
        ++this.headerCount;
    }

    private void recordPointer() {
        ++this.pointerCount;
    }

    private void recordPrimitiveBytes(int size) {
        this.primitiveByteSize += size;
    }

    private static ObjectSizeEstimate forObjectHelper(Object object, int maxDepth) {
        EconomicMap identityHashMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        ObjectSizeEstimate size = new ObjectSizeEstimate();
        ArrayList<Object> stack = new ArrayList<Object>();
        ArrayList<Integer> depthStack = new ArrayList<Integer>();
        stack.add(object);
        depthStack.add(0);
        identityHashMap.put(object, object);
        while (!stack.isEmpty()) {
            Class<?> c;
            Object o = stack.remove(stack.size() - 1);
            int depth = (Integer)depthStack.remove(depthStack.size() - 1);
            size.recordHeader();
            if (c.isArray()) {
                size.recordPrimitiveBytes(4);
                if (o instanceof byte[]) {
                    size.recordPrimitiveBytes(1 * ((byte[])o).length);
                    continue;
                }
                if (o instanceof boolean[]) {
                    size.recordPrimitiveBytes(1 * ((boolean[])o).length);
                    continue;
                }
                if (o instanceof char[]) {
                    size.recordPrimitiveBytes(2 * ((char[])o).length);
                    continue;
                }
                if (o instanceof short[]) {
                    size.recordPrimitiveBytes(2 * ((short[])o).length);
                    continue;
                }
                if (o instanceof int[]) {
                    size.recordPrimitiveBytes(4 * ((int[])o).length);
                    continue;
                }
                if (o instanceof long[]) {
                    size.recordPrimitiveBytes(8 * ((long[])o).length);
                    continue;
                }
                if (o instanceof float[]) {
                    size.recordPrimitiveBytes(4 * ((float[])o).length);
                    continue;
                }
                if (o instanceof double[]) {
                    size.recordPrimitiveBytes(1 * ((double[])o).length);
                    continue;
                }
                for (Object element : (Object[])o) {
                    size.recordPointer();
                    if (element == null || depth >= maxDepth || identityHashMap.containsKey(element)) continue;
                    identityHashMap.put(element, null);
                    stack.add(element);
                    depthStack.add(depth + 1);
                }
                continue;
            }
            for (c = o.getClass(); c != null; c = c.getSuperclass()) {
                Field[] fields;
                for (Field f : fields = c.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    Class<?> type = f.getType();
                    if (type == Byte.TYPE) {
                        size.recordPrimitiveBytes(1);
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        size.recordPrimitiveBytes(1);
                        continue;
                    }
                    if (type == Character.TYPE) {
                        size.recordPrimitiveBytes(2);
                        continue;
                    }
                    if (type == Short.TYPE) {
                        size.recordPrimitiveBytes(2);
                        continue;
                    }
                    if (type == Integer.TYPE) {
                        size.recordPrimitiveBytes(4);
                        continue;
                    }
                    if (type == Long.TYPE) {
                        size.recordPrimitiveBytes(8);
                        continue;
                    }
                    if (type == Float.TYPE) {
                        size.recordPrimitiveBytes(4);
                        continue;
                    }
                    if (type == Double.TYPE) {
                        size.recordPrimitiveBytes(8);
                        continue;
                    }
                    size.recordPointer();
                    if (maxDepth <= 1) continue;
                    try {
                        f.setAccessible(true);
                        Object inner = f.get(o);
                        if (inner == null || depth >= maxDepth || identityHashMap.containsKey(inner)) continue;
                        identityHashMap.put(inner, null);
                        stack.add(inner);
                        depthStack.add(depth + 1);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new UnsupportedOperationException("Must have access privileges to traverse object graph");
                    }
                    catch (RuntimeException e) {
                        if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                            throw new UnsupportedOperationException("Target class is not exported to the current module.", e);
                        }
                        throw e;
                    }
                }
            }
        }
        return size;
    }

    public static ObjectSizeEstimate zero() {
        return new ObjectSizeEstimate();
    }

    public int hashCode() {
        int prime = 31;
        return this.headerCount + 31 * (this.pointerCount + 31 * this.primitiveByteSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ObjectSizeEstimate) {
            ObjectSizeEstimate other = (ObjectSizeEstimate)obj;
            return this.headerCount == other.headerCount && this.pointerCount == other.pointerCount && this.primitiveByteSize == other.primitiveByteSize;
        }
        return false;
    }
}

