// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: GraalOptions.java
package org.graalvm.compiler.core.common;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class GraalOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlwaysInlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "AlwaysInlineVTableStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "AlwaysInlineVTableStubs",
                /*option*/ GraalOptions.AlwaysInlineVTableStubs,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ArrayRegionEqualsConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "ArrayRegionEqualsConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Array region equality checks will be evaluated at compile time if the receiver is a constant and its length is smaller than this value.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ArrayRegionEqualsConstantLimit",
                /*option*/ GraalOptions.ArrayRegionEqualsConstantLimit,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CanOmitFrame": {
            return OptionDescriptor.create(
                /*name*/ "CanOmitFrame",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "CanOmitFrame",
                /*option*/ GraalOptions.CanOmitFrame,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ConditionalElimination",
                /*option*/ GraalOptions.ConditionalElimination,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalEliminationMaxIterations": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalEliminationMaxIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ConditionalEliminationMaxIterations",
                /*option*/ GraalOptions.ConditionalEliminationMaxIterations,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptALot": {
            return OptionDescriptor.create(
                /*name*/ "DeoptALot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "DeoptALot",
                /*option*/ GraalOptions.DeoptALot,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptsToDisableOptimisticOptimization": {
            return OptionDescriptor.create(
                /*name*/ "DeoptsToDisableOptimisticOptimization",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "DeoptsToDisableOptimisticOptimization",
                /*option*/ GraalOptions.DeoptsToDisableOptimisticOptimization,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EagerSnippets": {
            return OptionDescriptor.create(
                /*name*/ "EagerSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Eagerly construct extra snippet info.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EagerSnippets",
                /*option*/ GraalOptions.EagerSnippets,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyGVN": {
            return OptionDescriptor.create(
                /*name*/ "EarlyGVN",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform early global value numbering.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EarlyGVN",
                /*option*/ GraalOptions.EarlyGVN,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyLICM": {
            return OptionDescriptor.create(
                /*name*/ "EarlyLICM",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform early loop invariant code motion.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EarlyLICM",
                /*option*/ GraalOptions.EarlyLICM,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EmitStringSubstitutions": {
            return OptionDescriptor.create(
                /*name*/ "EmitStringSubstitutions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit substitutions for String methods",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EmitStringSubstitutions",
                /*option*/ GraalOptions.EmitStringSubstitutions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisIterations": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalysisIterations",
                /*option*/ GraalOptions.EscapeAnalysisIterations,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisLoopCutoff": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisLoopCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalysisLoopCutoff",
                /*option*/ GraalOptions.EscapeAnalysisLoopCutoff,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalyzeOnly": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalyzeOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "EscapeAnalyzeOnly",
                /*option*/ GraalOptions.EscapeAnalyzeOnly,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FloatingDivNodes": {
            return OptionDescriptor.create(
                /*name*/ "FloatingDivNodes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Try to float non-constant division operations to expose global value numbering of divisions.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "FloatingDivNodes",
                /*option*/ GraalOptions.FloatingDivNodes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FullUnroll": {
            return OptionDescriptor.create(
                /*name*/ "FullUnroll",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "FullUnroll",
                /*option*/ GraalOptions.FullUnroll,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GCDebugStartCycle": {
            return OptionDescriptor.create(
                /*name*/ "GCDebugStartCycle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Start tracing compiled GC barriers after N garbage collections (disabled if N <= 0).",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GCDebugStartCycle",
                /*option*/ GraalOptions.GCDebugStartCycle,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenLoopSafepoints": {
            return OptionDescriptor.create(
                /*name*/ "GenLoopSafepoints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GenLoopSafepoints",
                /*option*/ GraalOptions.GenLoopSafepoints,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GuardPriorities": {
            return OptionDescriptor.create(
                /*name*/ "GuardPriorities",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "GuardPriorities",
                /*option*/ GraalOptions.GuardPriorities,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HotSpotPrintInlining": {
            return OptionDescriptor.create(
                /*name*/ "HotSpotPrintInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print inlining optimizations",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "HotSpotPrintInlining",
                /*option*/ GraalOptions.HotSpotPrintInlining,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineEverything": {
            return OptionDescriptor.create(
                /*name*/ "InlineEverything",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineEverything",
                /*option*/ GraalOptions.InlineEverything,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMegamorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMegamorphicCalls",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with megamorphic type profile (i.e., not all types could be recorded).",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineMegamorphicCalls",
                /*option*/ GraalOptions.InlineMegamorphicCalls,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMonomorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMonomorphicCalls",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with monomorphic type profile.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineMonomorphicCalls",
                /*option*/ GraalOptions.InlineMonomorphicCalls,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlinePolymorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlinePolymorphicCalls",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with polymorphic type profile.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlinePolymorphicCalls",
                /*option*/ GraalOptions.InlinePolymorphicCalls,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "InlineVTableStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "InlineVTableStubs",
                /*option*/ GraalOptions.InlineVTableStubs,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Intrinsify": {
            return OptionDescriptor.create(
                /*name*/ "Intrinsify",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use compiler intrinsifications.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "Intrinsify",
                /*option*/ GraalOptions.Intrinsify,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IsolatedLoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "IsolatedLoopHeaderAlignment",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment in bytes for loop header blocks that have no fall through paths.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "IsolatedLoopHeaderAlignment",
                /*option*/ GraalOptions.IsolatedLoopHeaderAlignment,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LimitInlinedInvokes": {
            return OptionDescriptor.create(
                /*name*/ "LimitInlinedInvokes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Double.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LimitInlinedInvokes",
                /*option*/ GraalOptions.LimitInlinedInvokes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "LoopHeaderAlignment",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment in bytes for loop header blocks.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopHeaderAlignment",
                /*option*/ GraalOptions.LoopHeaderAlignment,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopMaxUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopMaxUnswitch",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopMaxUnswitch",
                /*option*/ GraalOptions.LoopMaxUnswitch,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPeeling": {
            return OptionDescriptor.create(
                /*name*/ "LoopPeeling",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPeeling",
                /*option*/ GraalOptions.LoopPeeling,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredication": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredication",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Hoists array bounds checks out of simple loops. This is ignored if SpeculativeGuardMovement is enabled.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPredication",
                /*option*/ GraalOptions.LoopPredication,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredicationMainPath": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredicationMainPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Restricts LoopPredication to only focus on array bounds checks that dominate the back edge of a loop.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopPredicationMainPath",
                /*option*/ GraalOptions.LoopPredicationMainPath,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopUnswitch",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "LoopUnswitch",
                /*option*/ GraalOptions.LoopUnswitch,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MatchExpressions": {
            return OptionDescriptor.create(
                /*name*/ "MatchExpressions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow backend to match complex expressions.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MatchExpressions",
                /*option*/ GraalOptions.MatchExpressions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumDesiredSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumDesiredSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum desired size of the compiler graph in nodes.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumDesiredSize",
                /*option*/ GraalOptions.MaximumDesiredSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumEscapeAnalysisArrayLength": {
            return OptionDescriptor.create(
                /*name*/ "MaximumEscapeAnalysisArrayLength",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum length of an array that will be escape analyzed.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumEscapeAnalysisArrayLength",
                /*option*/ GraalOptions.MaximumEscapeAnalysisArrayLength,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Inlining is explored up to this number of nodes in the graph for each call site.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumInliningSize",
                /*option*/ GraalOptions.MaximumInliningSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumRecursiveInlining": {
            return OptionDescriptor.create(
                /*name*/ "MaximumRecursiveInlining",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum level of recursive inlining.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MaximumRecursiveInlining",
                /*option*/ GraalOptions.MaximumRecursiveInlining,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MegamorphicInliningMinMethodProbability": {
            return OptionDescriptor.create(
                /*name*/ "MegamorphicInliningMinMethodProbability",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Double.class,
                /*help*/ "Minimum probability for methods to be inlined for megamorphic type profiles.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MegamorphicInliningMinMethodProbability",
                /*option*/ GraalOptions.MegamorphicInliningMinMethodProbability,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimalBulkZeroingSize": {
            return OptionDescriptor.create(
                /*name*/ "MinimalBulkZeroingSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "If applicable, use bulk zeroing instructions when the zeroing size in bytes exceeds this threshold.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MinimalBulkZeroingSize",
                /*option*/ GraalOptions.MinimalBulkZeroingSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimumPeelFrequency": {
            return OptionDescriptor.create(
                /*name*/ "MinimumPeelFrequency",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Float.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "MinimumPeelFrequency",
                /*option*/ GraalOptions.MinimumPeelFrequency,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitHotExceptionStacktrace": {
            return OptionDescriptor.create(
                /*name*/ "OmitHotExceptionStacktrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OmitHotExceptionStacktrace",
                /*option*/ GraalOptions.OmitHotExceptionStacktrace,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptAssumptions": {
            return OptionDescriptor.create(
                /*name*/ "OptAssumptions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptAssumptions",
                /*option*/ GraalOptions.OptAssumptions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptConvertDeoptsToGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptConvertDeoptsToGuards",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptConvertDeoptsToGuards",
                /*option*/ GraalOptions.OptConvertDeoptsToGuards,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDeoptimizationGrouping": {
            return OptionDescriptor.create(
                /*name*/ "OptDeoptimizationGrouping",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptDeoptimizationGrouping",
                /*option*/ GraalOptions.OptDeoptimizationGrouping,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDevirtualizeInvokesOptimistically": {
            return OptionDescriptor.create(
                /*name*/ "OptDevirtualizeInvokesOptimistically",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptDevirtualizeInvokesOptimistically",
                /*option*/ GraalOptions.OptDevirtualizeInvokesOptimistically,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptEliminateGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptEliminateGuards",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptEliminateGuards",
                /*option*/ GraalOptions.OptEliminateGuards,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptFloatingReads": {
            return OptionDescriptor.create(
                /*name*/ "OptFloatingReads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptFloatingReads",
                /*option*/ GraalOptions.OptFloatingReads,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptImplicitNullChecks": {
            return OptionDescriptor.create(
                /*name*/ "OptImplicitNullChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptImplicitNullChecks",
                /*option*/ GraalOptions.OptImplicitNullChecks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptReadElimination": {
            return OptionDescriptor.create(
                /*name*/ "OptReadElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptReadElimination",
                /*option*/ GraalOptions.OptReadElimination,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptScheduleOutOfLoops": {
            return OptionDescriptor.create(
                /*name*/ "OptScheduleOutOfLoops",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "OptScheduleOutOfLoops",
                /*option*/ GraalOptions.OptScheduleOutOfLoops,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "PartialEscapeAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PartialEscapeAnalysis",
                /*option*/ GraalOptions.PartialEscapeAnalysis,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialUnroll": {
            return OptionDescriptor.create(
                /*name*/ "PartialUnroll",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PartialUnroll",
                /*option*/ GraalOptions.PartialUnroll,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintProfilingInformation": {
            return OptionDescriptor.create(
                /*name*/ "PrintProfilingInformation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print profiling information when parsing a method's bytecode",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "PrintProfilingInformation",
                /*option*/ GraalOptions.PrintProfilingInformation,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RawConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "RawConditionalElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RawConditionalElimination",
                /*option*/ GraalOptions.RawConditionalElimination,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReadEliminationMaxLoopVisits": {
            return OptionDescriptor.create(
                /*name*/ "ReadEliminationMaxLoopVisits",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReadEliminationMaxLoopVisits",
                /*option*/ GraalOptions.ReadEliminationMaxLoopVisits,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReassociateExpressions": {
            return OptionDescriptor.create(
                /*name*/ "ReassociateExpressions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Re-associate loop invariants and constants.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReassociateExpressions",
                /*option*/ GraalOptions.ReassociateExpressions,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RegisterPressure": {
            return OptionDescriptor.create(
                /*name*/ "RegisterPressure",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated list of registers that register allocation is limited to.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RegisterPressure",
                /*option*/ GraalOptions.RegisterPressure,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveNeverExecutedCode": {
            return OptionDescriptor.create(
                /*name*/ "RemoveNeverExecutedCode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "RemoveNeverExecutedCode",
                /*option*/ GraalOptions.RemoveNeverExecutedCode,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReplaceInputsWithConstantsBasedOnStamps": {
            return OptionDescriptor.create(
                /*name*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*option*/ GraalOptions.ReplaceInputsWithConstantsBasedOnStamps,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SmallCompiledLowLevelGraphSize": {
            return OptionDescriptor.create(
                /*name*/ "SmallCompiledLowLevelGraphSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "If the previous low-level graph size of the method exceeds the threshold, it is not inlined.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SmallCompiledLowLevelGraphSize",
                /*option*/ GraalOptions.SmallCompiledLowLevelGraphSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SnippetCounters": {
            return OptionDescriptor.create(
                /*name*/ "SnippetCounters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable counters for various paths in snippets.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SnippetCounters",
                /*option*/ GraalOptions.SnippetCounters,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculativeGuardMovement": {
            return OptionDescriptor.create(
                /*name*/ "SpeculativeGuardMovement",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Move loop invariant guards (e.g., array bounds checks) out of loops.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SpeculativeGuardMovement",
                /*option*/ GraalOptions.SpeculativeGuardMovement,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressExplicitExceptionCode": {
            return OptionDescriptor.create(
                /*name*/ "StressExplicitExceptionCode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting explicit exception throwing code.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressExplicitExceptionCode",
                /*option*/ GraalOptions.StressExplicitExceptionCode,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressInvokeWithExceptionNode": {
            return OptionDescriptor.create(
                /*name*/ "StressInvokeWithExceptionNode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting invokes with explicit exception edges.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressInvokeWithExceptionNode",
                /*option*/ GraalOptions.StressInvokeWithExceptionNode,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressTestEarlyReads": {
            return OptionDescriptor.create(
                /*name*/ "StressTestEarlyReads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code by emitting reads at earliest instead of latest point.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StressTestEarlyReads",
                /*option*/ GraalOptions.StressTestEarlyReads,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictDeoptInsertionChecks": {
            return OptionDescriptor.create(
                /*name*/ "StrictDeoptInsertionChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform checks that guards and deopts aren't introduced in graphs that should handle exceptions explicitly",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StrictDeoptInsertionChecks",
                /*option*/ GraalOptions.StrictDeoptInsertionChecks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StringIndexOfConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "StringIndexOfConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "String.indexOf invocations will be evaluated at compile time if the receiver is a constant and its length is smaller than this value.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "StringIndexOfConstantLimit",
                /*option*/ GraalOptions.StringIndexOfConstantLimit,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportJsrBytecodes": {
            return OptionDescriptor.create(
                /*name*/ "SupportJsrBytecodes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "SupportJsrBytecodes",
                /*option*/ GraalOptions.SupportJsrBytecodes,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "TraceEscapeAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceEscapeAnalysis",
                /*option*/ GraalOptions.TraceEscapeAnalysis,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInlining": {
            return OptionDescriptor.create(
                /*name*/ "TraceInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable tracing of inlining decisions.",
                /*extraHelp*/ new String[] {
                         "Output format:",
                         "  compilation of 'Signature of the compilation root method':",
                         "    at 'Signature of the root method' ['Bytecode index']: <'Phase'> 'Child method signature': 'Decision made about this callsite'",
                         "      at 'Signature of the child method' ['Bytecode index']: ",
                         "         |--<'Phase 1'> 'Grandchild method signature': 'First decision made about this callsite'",
                         "         \\--<'Phase 2'> 'Grandchild method signature': 'Second decision made about this callsite'",
                         "      at 'Signature of the child method' ['Bytecode index']: <'Phase'> 'Another grandchild method signature': 'The only decision made about this callsite.'",
                              },
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceInlining",
                /*option*/ GraalOptions.TraceInlining,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInliningForStubsAndSnippets": {
            return OptionDescriptor.create(
                /*name*/ "TraceInliningForStubsAndSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable inlining decision tracing in stubs and snippets.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TraceInliningForStubsAndSnippets",
                /*option*/ GraalOptions.TraceInliningForStubsAndSnippets,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeInsertion": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeInsertion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track source stack trace where a node was inserted into the graph.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrackNodeInsertion",
                /*option*/ GraalOptions.TrackNodeInsertion,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeSourcePosition": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeSourcePosition",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the NodeSourcePosition.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrackNodeSourcePosition",
                /*option*/ GraalOptions.TrackNodeSourcePosition,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrivialInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "TrivialInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Graphs with less than this number of nodes are trivial and therefore always inlined.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "TrivialInliningSize",
                /*option*/ GraalOptions.TrivialInliningSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseExceptionProbability": {
            return OptionDescriptor.create(
                /*name*/ "UseExceptionProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseExceptionProbability",
                /*option*/ GraalOptions.UseExceptionProbability,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseGraalStubs": {
            return OptionDescriptor.create(
                /*name*/ "UseGraalStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use Graal-generated stubs for complicated LIR operations instead of embedding all the emitted code.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseGraalStubs",
                /*option*/ GraalOptions.UseGraalStubs,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLoopLimitChecks": {
            return OptionDescriptor.create(
                /*name*/ "UseLoopLimitChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseLoopLimitChecks",
                /*option*/ GraalOptions.UseLoopLimitChecks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSnippetGraphCache": {
            return OptionDescriptor.create(
                /*name*/ "UseSnippetGraphCache",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a cache for snippet graphs.",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseSnippetGraphCache",
                /*option*/ GraalOptions.UseSnippetGraphCache,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseTypeCheckHints": {
            return OptionDescriptor.create(
                /*name*/ "UseTypeCheckHints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "UseTypeCheckHints",
                /*option*/ GraalOptions.UseTypeCheckHints,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyHeapAtReturn": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeapAtReturn",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform platform dependent validation of the Java heap at returns",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "VerifyHeapAtReturn",
                /*option*/ GraalOptions.VerifyHeapAtReturn,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyPhases": {
            return OptionDescriptor.create(
                /*name*/ "VerifyPhases",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "VerifyPhases",
                /*option*/ GraalOptions.VerifyPhases,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapStackOnMethodEntry": {
            return OptionDescriptor.create(
                /*name*/ "ZapStackOnMethodEntry",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*declaringClass*/ GraalOptions.class,
                /*fieldName*/ "ZapStackOnMethodEntry",
                /*option*/ GraalOptions.ZapStackOnMethodEntry,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 84;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlwaysInlineVTableStubs");
                    case 1: return get("ArrayRegionEqualsConstantLimit");
                    case 2: return get("CanOmitFrame");
                    case 3: return get("ConditionalElimination");
                    case 4: return get("ConditionalEliminationMaxIterations");
                    case 5: return get("DeoptALot");
                    case 6: return get("DeoptsToDisableOptimisticOptimization");
                    case 7: return get("EagerSnippets");
                    case 8: return get("EarlyGVN");
                    case 9: return get("EarlyLICM");
                    case 10: return get("EmitStringSubstitutions");
                    case 11: return get("EscapeAnalysisIterations");
                    case 12: return get("EscapeAnalysisLoopCutoff");
                    case 13: return get("EscapeAnalyzeOnly");
                    case 14: return get("FloatingDivNodes");
                    case 15: return get("FullUnroll");
                    case 16: return get("GCDebugStartCycle");
                    case 17: return get("GenLoopSafepoints");
                    case 18: return get("GuardPriorities");
                    case 19: return get("HotSpotPrintInlining");
                    case 20: return get("InlineEverything");
                    case 21: return get("InlineMegamorphicCalls");
                    case 22: return get("InlineMonomorphicCalls");
                    case 23: return get("InlinePolymorphicCalls");
                    case 24: return get("InlineVTableStubs");
                    case 25: return get("Intrinsify");
                    case 26: return get("IsolatedLoopHeaderAlignment");
                    case 27: return get("LimitInlinedInvokes");
                    case 28: return get("LoopHeaderAlignment");
                    case 29: return get("LoopMaxUnswitch");
                    case 30: return get("LoopPeeling");
                    case 31: return get("LoopPredication");
                    case 32: return get("LoopPredicationMainPath");
                    case 33: return get("LoopUnswitch");
                    case 34: return get("MatchExpressions");
                    case 35: return get("MaximumDesiredSize");
                    case 36: return get("MaximumEscapeAnalysisArrayLength");
                    case 37: return get("MaximumInliningSize");
                    case 38: return get("MaximumRecursiveInlining");
                    case 39: return get("MegamorphicInliningMinMethodProbability");
                    case 40: return get("MinimalBulkZeroingSize");
                    case 41: return get("MinimumPeelFrequency");
                    case 42: return get("OmitHotExceptionStacktrace");
                    case 43: return get("OptAssumptions");
                    case 44: return get("OptConvertDeoptsToGuards");
                    case 45: return get("OptDeoptimizationGrouping");
                    case 46: return get("OptDevirtualizeInvokesOptimistically");
                    case 47: return get("OptEliminateGuards");
                    case 48: return get("OptFloatingReads");
                    case 49: return get("OptImplicitNullChecks");
                    case 50: return get("OptReadElimination");
                    case 51: return get("OptScheduleOutOfLoops");
                    case 52: return get("PartialEscapeAnalysis");
                    case 53: return get("PartialUnroll");
                    case 54: return get("PrintProfilingInformation");
                    case 55: return get("RawConditionalElimination");
                    case 56: return get("ReadEliminationMaxLoopVisits");
                    case 57: return get("ReassociateExpressions");
                    case 58: return get("RegisterPressure");
                    case 59: return get("RemoveNeverExecutedCode");
                    case 60: return get("ReplaceInputsWithConstantsBasedOnStamps");
                    case 61: return get("SmallCompiledLowLevelGraphSize");
                    case 62: return get("SnippetCounters");
                    case 63: return get("SpeculativeGuardMovement");
                    case 64: return get("StressExplicitExceptionCode");
                    case 65: return get("StressInvokeWithExceptionNode");
                    case 66: return get("StressTestEarlyReads");
                    case 67: return get("StrictDeoptInsertionChecks");
                    case 68: return get("StringIndexOfConstantLimit");
                    case 69: return get("SupportJsrBytecodes");
                    case 70: return get("TraceEscapeAnalysis");
                    case 71: return get("TraceInlining");
                    case 72: return get("TraceInliningForStubsAndSnippets");
                    case 73: return get("TrackNodeInsertion");
                    case 74: return get("TrackNodeSourcePosition");
                    case 75: return get("TrivialInliningSize");
                    case 76: return get("UseExceptionProbability");
                    case 77: return get("UseGraalStubs");
                    case 78: return get("UseLoopLimitChecks");
                    case 79: return get("UseSnippetGraphCache");
                    case 80: return get("UseTypeCheckHints");
                    case 81: return get("VerifyHeapAtReturn");
                    case 82: return get("VerifyPhases");
                    case 83: return get("ZapStackOnMethodEntry");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
