// CheckStyle: start generated
package org.graalvm.compiler.truffle.options;

import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionStability;

@GeneratedBy(PolyglotCompilerOptions.class)
final class PolyglotCompilerOptionsOptionDescriptors implements OptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "engine.ArgumentTypeSpeculation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ArgumentTypeSpeculation, "engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.BackgroundCompilation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.BackgroundCompilation, "engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Compilation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Compilation, "engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationExceptionsAreFatal" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreFatal, "engine.CompilationExceptionsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM'").help("Treat compilation exceptions as fatal exceptions that will exit the application").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationExceptionsArePrinted" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsArePrinted, "engine.CompilationExceptionsArePrinted").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Print'").help("Prints the exception stack trace for compilation exceptions").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationExceptionsAreThrown" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreThrown, "engine.CompilationExceptionsAreThrown").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Throw'").help("Treat compilation exceptions as thrown runtime exceptions").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationFailureAction" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationFailureAction, "engine.CompilationFailureAction").deprecated(false).help(String.format("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.")).usageSyntax("Silent|Print|Throw|Diagnose|ExitVM").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationStatisticDetails" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatisticDetails, "engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilationStatistics" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatistics, "engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileAOTOnCreate" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileAOTOnCreate, "engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileImmediately" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileImmediately, "engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompileOnly" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileOnly, "engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilerIdleDelay" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerIdleDelay, "engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect. default: 10000").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.CompilerThreads" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerThreads, "engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads. By default, the number of compiler threads is scaled with the number of available cores on the CPU.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholds" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholds, "engine.DynamicCompilationThresholds").deprecated(false).help("Reduce or increase the compilation threshold depending on the size of the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMaxNormalLoad" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMaxNormalLoad, "engine.DynamicCompilationThresholdsMaxNormalLoad").deprecated(false).help("The desired maximum compilation queue load. When the load rises above this value, the compilation thresholds are increased. The load is scaled by the number of compiler threads.  (default: 10)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMinNormalLoad" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMinNormalLoad, "engine.DynamicCompilationThresholdsMinNormalLoad").deprecated(false).help("The desired minimum compilation queue load. When the load falls bellow this value, the compilation thresholds are decreased. The load is scaled by the number of compiler threads (default: 10).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.DynamicCompilationThresholdsMinScale" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMinScale, "engine.DynamicCompilationThresholdsMinScale").deprecated(false).help("The minimal scale the compilation thresholds can be reduced to (default: 0.1).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.EncodedGraphCache" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCache, "engine.EncodedGraphCache").deprecated(false).help("Cache encoded graphs across Truffle compilations to speed up partial evaluation. (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.EncodedGraphCachePurgeDelay" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCachePurgeDelay, "engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when a Truffle compiler thread becomes idle (default: 10000).").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ExcludeAssertions" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ExcludeAssertions, "engine.ExcludeAssertions").deprecated(false).help("Exclude assertion code from Truffle compilations (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierBackedgeCounts" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierBackedgeCounts, "engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierCompilationThreshold, "engine.FirstTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load (default: 400).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierInliningPolicy" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierInliningPolicy, "engine.FirstTierInliningPolicy").deprecated(false).help("Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.").usageSyntax("<policy>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierMinInvokeThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, "engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier (default: 1)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.FirstTierUseEconomy" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierUseEconomy, "engine.FirstTierUseEconomy").deprecated(false).help("Whether to use the economy configuration in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ForceFrameLivenessAnalysis" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ForceFrameLivenessAnalysis, "engine.ForceFrameLivenessAnalysis").deprecated(true).deprecationMessage("The analysis is now always executed, irrespective of this option").help("Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InlineAcrossTruffleBoundary" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineAcrossTruffleBoundary, "engine.InlineAcrossTruffleBoundary").deprecated(false).help("Enable inlining across Truffle boundary").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InlineOnly" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineOnly, "engine.InlineOnly").deprecated(false).help("Restrict inlined methods to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Inlining" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Inlining, "engine.Inlining").deprecated(false).help("Enable automatic inlining of guest language call targets (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InliningExpansionBudget" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningExpansionBudget, "engine.InliningExpansionBudget").deprecated(false).help("The base expansion budget for language-agnostic inlining (default: 12000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InliningInliningBudget" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningInliningBudget, "engine.InliningInliningBudget").deprecated(false).help("The base inlining budget for language-agnostic inlining (default: 12000)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InliningPolicy" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningPolicy, "engine.InliningPolicy").deprecated(false).help("Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.").usageSyntax("<policy>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InliningRecursionDepth" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningRecursionDepth, "engine.InliningRecursionDepth").deprecated(false).help("Maximum depth for recursive inlining (default: 2).").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InliningUseSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningUseSize, "engine.InliningUseSize").deprecated(false).help("Use the graph size as a cost model during inlining (default: false).").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentBoundaries" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundaries, "engine.InstrumentBoundaries").deprecated(false).help("Instrument Truffle boundaries and output profiling information to the standard output.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentBoundariesPerInlineSite" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite, "engine.InstrumentBoundariesPerInlineSite").deprecated(false).help("Instrument Truffle boundaries by considering different inlining sites as different branches.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentBranches" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranches, "engine.InstrumentBranches").deprecated(false).help("Instrument branches and output profiling information to the standard output.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentBranchesPerInlineSite" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite, "engine.InstrumentBranchesPerInlineSite").deprecated(false).help("Instrument branches by considering different inlining sites as different branches.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentFilter" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentFilter, "engine.InstrumentFilter").deprecated(false).help("Method filter for host methods in which to add instrumentation.").usageSyntax("<method>,<method>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InstrumentationTableSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentationTableSize, "engine.InstrumentationTableSize").deprecated(false).help("Maximum number of instrumentation counters available (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.InvalidationReprofileCount" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.InvalidationReprofileCount, "engine.InvalidationReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.IterativePartialEscape" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.IterativePartialEscape, "engine.IterativePartialEscape").deprecated(false).help("Run the partial escape analysis iteratively in Truffle compilation.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.LastTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.LastTierCompilationThreshold, "engine.LastTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in last tier under normal compilation load (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MaximumGraalGraphSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalGraphSize, "engine.MaximumGraalGraphSize").deprecated(false).help("Stop partial evaluation when the graph exceeded this size (default: 150000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MaximumGraalNodeCount" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalNodeCount, "engine.MaximumGraalNodeCount").deprecated(true).deprecationMessage("Use MaximumGraalGraphSize.").help("Stop partial evaluation when the graph exceeded this many nodes (default: 40000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MaximumInlineNodeCount" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumInlineNodeCount, "engine.MaximumInlineNodeCount").deprecated(false).help("Ignore further truffle inlining decisions when the graph exceeded this many nodes (default: 150000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MethodExpansionStatistics" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MethodExpansionStatistics, "engine.MethodExpansionStatistics").deprecated(false).help(String.format("Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.MinInvokeThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MinInvokeThreshold, "engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled (default: 3).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Mode" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Mode, "engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").usageSyntax("latency|throughput").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "engine.MultiTier" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.MultiTier, "engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.NodeExpansionStatistics" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeExpansionStatistics, "engine.NodeExpansionStatistics").deprecated(false).help(String.format("Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.NodeSourcePositions" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeSourcePositions, "engine.NodeSourcePositions").deprecated(false).help("Enable node source positions in truffle partial evaluations.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.OSR" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSR, "engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.OSRCompilationThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSRCompilationThreshold, "engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered (default 100352).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockCompilation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilation, "engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockCompilationSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilationSize, "engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 3000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PartialBlockMaximumSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockMaximumSize, "engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PerformanceWarningsAreFatal" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PerformanceWarningsAreFatal, "engine.PerformanceWarningsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'").help("Treat performance warnings as fatal occurrences that will exit the applications").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PrintExpansionHistogram" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PrintExpansionHistogram, "engine.PrintExpansionHistogram").deprecated(true).deprecationMessage("The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.").help("Prints a histogram of all expanded Java methods.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.PriorityQueue" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.PriorityQueue, "engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Profiling" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Profiling, "engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ReplaceReprofileCount" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReplaceReprofileCount, "engine.ReplaceReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after a node replacement. Deprecated: no longer has any effect.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.ReturnTypeSpeculation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReturnTypeSpeculation, "engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SingleTierCompilationThreshold" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SingleTierCompilationThreshold, "engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier (default: 1000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.Splitting" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.Splitting, "engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting) (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingAllowForcedSplits" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingAllowForcedSplits, "engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingDumpDecisions" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingDumpDecisions, "engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingGrowthLimit" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingGrowthLimit, "engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count (default: 1.5).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingMaxCalleeSize" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxCalleeSize, "engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit (default: 100)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingMaxPropagationDepth" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxPropagationDepth, "engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets (default: 5)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.SplittingTraceEvents" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingTraceEvents, "engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceAssumptions" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceAssumptions, "engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilation" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilation, "engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "engine.TraceCompilationAST" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationAST, "engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilationDetails" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationDetails, "engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceCompilationPolymorphism" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationPolymorphism, "engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceDeoptimizeFrame" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceDeoptimizeFrame, "engine.TraceDeoptimizeFrame").deprecated(false).help("Print stack trace when deoptimizing a frame from the stack with `FrameInstance#getFrame(READ_WRITE|MATERIALIZE)`.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceInlining" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInlining, "engine.TraceInlining").deprecated(false).help("Print information for inlining decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceInliningDetails" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInliningDetails, "engine.TraceInliningDetails").deprecated(false).help("Print detailed information for inlining (i.e. the entire explored call tree).").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceMethodExpansion" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceMethodExpansion, "engine.TraceMethodExpansion").deprecated(false).help(String.format("Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceNodeExpansion" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceNodeExpansion, "engine.TraceNodeExpansion").deprecated(false).help(String.format("Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TracePerformanceWarnings" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TracePerformanceWarnings, "engine.TracePerformanceWarnings").deprecated(false).help("Print potential performance problems, Performance warnings are: call, instanceof, store, frame_merge, trivial.").usageSyntax("none|all|<perfWarning>,<perfWarning>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceSplitting" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplitting, "engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceSplittingSummary" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplittingSummary, "engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceStackTraceLimit" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceStackTraceLimit, "engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraceTransferToInterpreter" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceTransferToInterpreter, "engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingCompilationQueue" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingCompilationQueue, "engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueFirstTierBonus" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierBonus, "engine.TraversingQueueFirstTierBonus").deprecated(false).help("Controls how much of a priority should be given to first tier compilations (default 15.0).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueFirstTierPriority" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierPriority, "engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TraversingQueueWeightingBothTiers" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueWeightingBothTiers, "engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "engine.TreatPerformanceWarningsAsErrors" :
                return OptionDescriptor.newBuilder(PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors, "engine.TreatPerformanceWarningsAsErrors").deprecated(false).help("Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value. Performance warnings are: call, instanceof, store, frame_merge, trivial.").usageSyntax("none|all|<perfWarning>,<perfWarning>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return Arrays.asList(
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.ArgumentTypeSpeculation, "engine.ArgumentTypeSpeculation").deprecated(false).help("Speculate on arguments types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.BackgroundCompilation, "engine.BackgroundCompilation").deprecated(false).help("Enable asynchronous truffle compilation in background threads (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.Compilation, "engine.Compilation").deprecated(false).help("Enable or disable Truffle compilation.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreFatal, "engine.CompilationExceptionsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM'").help("Treat compilation exceptions as fatal exceptions that will exit the application").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsArePrinted, "engine.CompilationExceptionsArePrinted").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Print'").help("Prints the exception stack trace for compilation exceptions").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationExceptionsAreThrown, "engine.CompilationExceptionsAreThrown").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=Throw'").help("Treat compilation exceptions as thrown runtime exceptions").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationFailureAction, "engine.CompilationFailureAction").deprecated(false).help(String.format("Specifies the action to take when Truffle compilation fails.%nThe accepted values are:%n    Silent - Print nothing to the console.%n     Print - Print the exception to the console.%n     Throw - Throw the exception to caller.%n  Diagnose - Retry compilation with extra diagnostics enabled.%n    ExitVM - Exit the VM process.")).usageSyntax("Silent|Print|Throw|Diagnose|ExitVM").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatisticDetails, "engine.CompilationStatisticDetails").deprecated(false).help("Print additional more verbose Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilationStatistics, "engine.CompilationStatistics").deprecated(false).help("Print Truffle compilation statistics at the end of a run.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileAOTOnCreate, "engine.CompileAOTOnCreate").deprecated(false).help("Compiles created call targets immediately with last tier. Disables background compilation if enabled.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileImmediately, "engine.CompileImmediately").deprecated(false).help("Compile immediately to test Truffle compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompileOnly, "engine.CompileOnly").deprecated(false).help("Restrict compilation to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerIdleDelay, "engine.CompilerIdleDelay").deprecated(false).help("Set the time in milliseconds an idle Truffle compiler thread will wait for new tasks before terminating. New compiler threads will be started once new compilation tasks are submitted. Select '0' to never terminate the Truffle compiler thread. The option is not supported by all Truffle runtimes. On the runtime which doesn't support it the option has no effect. default: 10000").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.CompilerThreads, "engine.CompilerThreads").deprecated(false).help("Manually set the number of compiler threads. By default, the number of compiler threads is scaled with the number of available cores on the CPU.").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholds, "engine.DynamicCompilationThresholds").deprecated(false).help("Reduce or increase the compilation threshold depending on the size of the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMaxNormalLoad, "engine.DynamicCompilationThresholdsMaxNormalLoad").deprecated(false).help("The desired maximum compilation queue load. When the load rises above this value, the compilation thresholds are increased. The load is scaled by the number of compiler threads.  (default: 10)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMinNormalLoad, "engine.DynamicCompilationThresholdsMinNormalLoad").deprecated(false).help("The desired minimum compilation queue load. When the load falls bellow this value, the compilation thresholds are decreased. The load is scaled by the number of compiler threads (default: 10).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.DynamicCompilationThresholdsMinScale, "engine.DynamicCompilationThresholdsMinScale").deprecated(false).help("The minimal scale the compilation thresholds can be reduced to (default: 0.1).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCache, "engine.EncodedGraphCache").deprecated(false).help("Cache encoded graphs across Truffle compilations to speed up partial evaluation. (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.EncodedGraphCachePurgeDelay, "engine.EncodedGraphCachePurgeDelay").deprecated(false).help("Delay, in milliseconds, after which the encoded graph cache is dropped when a Truffle compiler thread becomes idle (default: 10000).").usageSyntax("<ms>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.ExcludeAssertions, "engine.ExcludeAssertions").deprecated(false).help("Exclude assertion code from Truffle compilations (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierBackedgeCounts, "engine.FirstTierBackedgeCounts").deprecated(false).help("Whether to emit look-back-edge counters in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierCompilationThreshold, "engine.FirstTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in first tier under normal compilation load (default: 400).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierInliningPolicy, "engine.FirstTierInliningPolicy").deprecated(false).help("Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.").usageSyntax("<policy>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierMinInvokeThreshold, "engine.FirstTierMinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled in the first tier (default: 1)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.FirstTierUseEconomy, "engine.FirstTierUseEconomy").deprecated(false).help("Whether to use the economy configuration in the first-tier compilations. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.ForceFrameLivenessAnalysis, "engine.ForceFrameLivenessAnalysis").deprecated(true).deprecationMessage("The analysis is now always executed, irrespective of this option").help("Forces the frame clearing mechanism to be executed, even if Frame.clear() is not used.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineAcrossTruffleBoundary, "engine.InlineAcrossTruffleBoundary").deprecated(false).help("Enable inlining across Truffle boundary").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InlineOnly, "engine.InlineOnly").deprecated(false).help("Restrict inlined methods to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default.").usageSyntax("<name>,<name>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.Inlining, "engine.Inlining").deprecated(false).help("Enable automatic inlining of guest language call targets (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningExpansionBudget, "engine.InliningExpansionBudget").deprecated(false).help("The base expansion budget for language-agnostic inlining (default: 12000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningInliningBudget, "engine.InliningInliningBudget").deprecated(false).help("The base inlining budget for language-agnostic inlining (default: 12000)").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningPolicy, "engine.InliningPolicy").deprecated(false).help("Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.").usageSyntax("<policy>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningRecursionDepth, "engine.InliningRecursionDepth").deprecated(false).help("Maximum depth for recursive inlining (default: 2).").usageSyntax("[0, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InliningUseSize, "engine.InliningUseSize").deprecated(false).help("Use the graph size as a cost model during inlining (default: false).").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundaries, "engine.InstrumentBoundaries").deprecated(false).help("Instrument Truffle boundaries and output profiling information to the standard output.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBoundariesPerInlineSite, "engine.InstrumentBoundariesPerInlineSite").deprecated(false).help("Instrument Truffle boundaries by considering different inlining sites as different branches.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranches, "engine.InstrumentBranches").deprecated(false).help("Instrument branches and output profiling information to the standard output.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentBranchesPerInlineSite, "engine.InstrumentBranchesPerInlineSite").deprecated(false).help("Instrument branches by considering different inlining sites as different branches.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentFilter, "engine.InstrumentFilter").deprecated(false).help("Method filter for host methods in which to add instrumentation.").usageSyntax("<method>,<method>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InstrumentationTableSize, "engine.InstrumentationTableSize").deprecated(false).help("Maximum number of instrumentation counters available (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.InvalidationReprofileCount, "engine.InvalidationReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after an invalidation to allow for reprofiling. Deprecated: no longer has any effect.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.IterativePartialEscape, "engine.IterativePartialEscape").deprecated(false).help("Run the partial escape analysis iteratively in Truffle compilation.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.LastTierCompilationThreshold, "engine.LastTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root in last tier under normal compilation load (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalGraphSize, "engine.MaximumGraalGraphSize").deprecated(false).help("Stop partial evaluation when the graph exceeded this size (default: 150000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumGraalNodeCount, "engine.MaximumGraalNodeCount").deprecated(true).deprecationMessage("Use MaximumGraalGraphSize.").help("Stop partial evaluation when the graph exceeded this many nodes (default: 40000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MaximumInlineNodeCount, "engine.MaximumInlineNodeCount").deprecated(false).help("Ignore further truffle inlining decisions when the graph exceeded this many nodes (default: 150000).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MethodExpansionStatistics, "engine.MethodExpansionStatistics").deprecated(false).help(String.format("Print statistics on expanded Java methods during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MinInvokeThreshold, "engine.MinInvokeThreshold").deprecated(false).help("Minimum number of calls before a call target is compiled (default: 3).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.Mode, "engine.Mode").deprecated(false).help("Configures the execution mode of the engine. Available modes are 'latency' and 'throughput'. The default value balances between the two.").usageSyntax("latency|throughput").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.MultiTier, "engine.MultiTier").deprecated(false).help("Whether to use multiple Truffle compilation tiers by default. (default: true)").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeExpansionStatistics, "engine.NodeExpansionStatistics").deprecated(false).help(String.format("Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.NodeSourcePositions, "engine.NodeSourcePositions").deprecated(false).help("Enable node source positions in truffle partial evaluations.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSR, "engine.OSR").deprecated(false).help("Enable automatic on-stack-replacement of loops (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.OSRCompilationThreshold, "engine.OSRCompilationThreshold").deprecated(false).help("Number of loop iterations until on-stack-replacement compilation is triggered (default 100352).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilation, "engine.PartialBlockCompilation").deprecated(false).help("Enable partial compilation for BlockNode (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockCompilationSize, "engine.PartialBlockCompilationSize").deprecated(false).help("Sets the target non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 3000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PartialBlockMaximumSize, "engine.PartialBlockMaximumSize").deprecated(false).help("Sets the maximum non-trivial Truffle node size for partial compilation of BlockNode nodes (default: 10000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PerformanceWarningsAreFatal, "engine.PerformanceWarningsAreFatal").deprecated(true).deprecationMessage("Use 'engine.CompilationFailureAction=ExitVM' 'engine.TreatPerformanceWarningsAsErrors=<PerformanceWarningKinds>'").help("Treat performance warnings as fatal occurrences that will exit the applications").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PrintExpansionHistogram, "engine.PrintExpansionHistogram").deprecated(true).deprecationMessage("The expansion histogram was superseeded by engine.TraceMethodExpansion, engine.TraceNodeExpansion, engine.MethodExpansionHistogram and engine.NodeExpansionHistogram.").help("Prints a histogram of all expanded Java methods.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.PriorityQueue, "engine.PriorityQueue").deprecated(false).help("Use the priority of compilation jobs in the compilation queue (default: true).").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.Profiling, "engine.Profiling").deprecated(false).help("Enable/disable builtin profiles in com.oracle.truffle.api.profiles. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReplaceReprofileCount, "engine.ReplaceReprofileCount").deprecated(true).deprecationMessage("").help("Delay compilation after a node replacement. Deprecated: no longer has any effect.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.ReturnTypeSpeculation, "engine.ReturnTypeSpeculation").deprecated(false).help("Speculate on return types at call sites (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SingleTierCompilationThreshold, "engine.SingleTierCompilationThreshold").deprecated(false).help("Minimum number of invocations or loop iterations needed to compile a guest language root when not using multi tier (default: 1000).").usageSyntax("[1, inf)").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.Splitting, "engine.Splitting").deprecated(false).help("Enable automatic duplication of compilation profiles (splitting) (default: true).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingAllowForcedSplits, "engine.SplittingAllowForcedSplits").deprecated(false).help("Should forced splits be allowed (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingDumpDecisions, "engine.SplittingDumpDecisions").deprecated(false).help("Dumps to IGV information on polymorphic events").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingGrowthLimit, "engine.SplittingGrowthLimit").deprecated(false).help("Disable call target splitting if the number of nodes created by splitting exceeds this factor times node count (default: 1.5).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxCalleeSize, "engine.SplittingMaxCalleeSize").deprecated(false).help("Disable call target splitting if tree size exceeds this limit (default: 100)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingMaxPropagationDepth, "engine.SplittingMaxPropagationDepth").deprecated(false).help("Propagate info about a polymorphic specialize through maximum this many call targets (default: 5)").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.SplittingTraceEvents, "engine.SplittingTraceEvents").deprecated(false).help("Trace details of splitting events and decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceAssumptions, "engine.TraceAssumptions").deprecated(false).help("Print stack trace on assumption invalidation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilation, "engine.TraceCompilation").deprecated(false).help("Print information for compilation results.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationAST, "engine.TraceCompilationAST").deprecated(false).help("Print the entire AST after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationDetails, "engine.TraceCompilationDetails").deprecated(false).help("Print information for compilation queuing.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceCompilationPolymorphism, "engine.TraceCompilationPolymorphism").deprecated(false).help("Print all polymorphic and generic nodes after each compilation").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceDeoptimizeFrame, "engine.TraceDeoptimizeFrame").deprecated(false).help("Print stack trace when deoptimizing a frame from the stack with `FrameInstance#getFrame(READ_WRITE|MATERIALIZE)`.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInlining, "engine.TraceInlining").deprecated(false).help("Print information for inlining decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceInliningDetails, "engine.TraceInliningDetails").deprecated(false).help("Print detailed information for inlining (i.e. the entire explored call tree).").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceMethodExpansion, "engine.TraceMethodExpansion").deprecated(false).help(String.format("Print a tree of all expanded Java methods with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceNodeExpansion, "engine.TraceNodeExpansion").deprecated(false).help(String.format("Print a tree of all expanded Truffle nodes with statistics after each compilation. Accepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.")).usageSyntax("true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TracePerformanceWarnings, "engine.TracePerformanceWarnings").deprecated(false).help("Print potential performance problems, Performance warnings are: call, instanceof, store, frame_merge, trivial.").usageSyntax("none|all|<perfWarning>,<perfWarning>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplitting, "engine.TraceSplitting").deprecated(false).help("Print information for splitting decisions.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceSplittingSummary, "engine.TraceSplittingSummary").deprecated(false).help("Used for debugging the splitting implementation. Prints splitting summary directly to stdout on shutdown").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceStackTraceLimit, "engine.TraceStackTraceLimit").deprecated(false).help("Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20).").usageSyntax("[1, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraceTransferToInterpreter, "engine.TraceTransferToInterpreter").deprecated(false).help("Print stack trace on transfer to interpreter.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingCompilationQueue, "engine.TraversingCompilationQueue").deprecated(false).help("Use a traversing compilation queue. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierBonus, "engine.TraversingQueueFirstTierBonus").deprecated(false).help("Controls how much of a priority should be given to first tier compilations (default 15.0).").usageSyntax("[0.0, inf)").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueFirstTierPriority, "engine.TraversingQueueFirstTierPriority").deprecated(false).help("Traversing queue gives first tier compilations priority.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TraversingQueueWeightingBothTiers, "engine.TraversingQueueWeightingBothTiers").deprecated(false).help("Traversing queue uses rate as priority for both tier. (default: true)").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PolyglotCompilerOptions.TreatPerformanceWarningsAsErrors, "engine.TreatPerformanceWarningsAsErrors").deprecated(false).help("Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value. Performance warnings are: call, instanceof, store, frame_merge, trivial.").usageSyntax("none|all|<perfWarning>,<perfWarning>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build())
        .iterator();
    }

}
