/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.Buffer;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.debug.GraalError;

public abstract class Assembler {
    private final TargetDescription target;
    private List<LabelHint> jumpDisplacementHints;
    Label labelsWithPatches;
    private final Buffer codeBuffer;
    protected Consumer<CodeAnnotation> codePatchingAnnotationConsumer;
    private static final String NEWLINE = System.lineSeparator();
    private Map<Label, String> nameMap;

    public Assembler(TargetDescription target) {
        this.target = target;
        this.codeBuffer = new Buffer(target.arch.getByteOrder());
    }

    public void setCodePatchingAnnotationConsumer(Consumer<CodeAnnotation> codeAnnotationConsumer) {
        assert (this.codePatchingAnnotationConsumer == null) : "overwriting existing value";
        this.codePatchingAnnotationConsumer = codeAnnotationConsumer;
    }

    public int position() {
        return this.codeBuffer.position();
    }

    public final void emitByte(int x) {
        this.codeBuffer.emitByte(x);
    }

    public final void emitShort(int x) {
        this.codeBuffer.emitShort(x);
    }

    public final void emitInt(int x) {
        this.codeBuffer.emitInt(x);
    }

    public final void emitLong(long x) {
        this.codeBuffer.emitLong(x);
    }

    public final void emitByte(int b, int pos) {
        this.codeBuffer.emitByte(b, pos);
    }

    public final void emitShort(int b, int pos) {
        this.codeBuffer.emitShort(b, pos);
    }

    public final void emitInt(int b, int pos) {
        this.codeBuffer.emitInt(b, pos);
    }

    public final void emitLong(long b, int pos) {
        this.codeBuffer.emitLong(b, pos);
    }

    public final int getByte(int pos) {
        return this.codeBuffer.getByte(pos);
    }

    public final int getShort(int pos) {
        return this.codeBuffer.getShort(pos);
    }

    public final int getInt(int pos) {
        return this.codeBuffer.getInt(pos);
    }

    public final void emitString(String x) {
        this.emitString0("\t");
        this.emitString0(x);
        this.emitString0(NEWLINE);
    }

    public final void emitString0(String x) {
        this.codeBuffer.emitBytes(x.getBytes(), 0, x.length());
    }

    public void emitString(String s, int pos) {
        this.codeBuffer.emitBytes(s.getBytes(), pos);
    }

    public byte[] close(boolean trimmedCopy) {
        this.checkAndClearLabelsWithPatches();
        return this.codeBuffer.close(trimmedCopy);
    }

    public byte[] copy(int start, int end) {
        return this.codeBuffer.copyData(start, end);
    }

    private void checkAndClearLabelsWithPatches() throws InternalError {
        Label label = this.labelsWithPatches;
        while (label != null) {
            if (label.patchPositions != null) {
                throw new GraalError("Label used by instructions at following offsets has not been bound: %s", label.patchPositions);
            }
            Label next = label.nextWithPatches;
            label.nextWithPatches = null;
            label = next;
        }
        this.labelsWithPatches = null;
    }

    public void bind(Label l) {
        assert (!l.isBound()) : "can bind label only once";
        l.bind(this.position(), this);
    }

    public abstract void align(int var1);

    public abstract void jmp(Label var1);

    protected abstract void patchJumpTarget(int var1, int var2);

    protected String createLabelName(Label l, int id) {
        return "L" + id;
    }

    public String nameOf(Label l) {
        String name;
        if (this.nameMap == null) {
            this.nameMap = new HashMap<Label, String>();
        }
        if ((name = this.nameMap.get(l)) == null) {
            name = this.createLabelName(l, this.nameMap.size());
            this.nameMap.put(l, name);
        }
        return name;
    }

    public abstract AbstractAddress makeAddress(int var1, Register var2, int var3);

    public abstract AbstractAddress getPlaceholder(int var1);

    public abstract void ensureUniquePC();

    public void reset() {
        this.codeBuffer.reset();
        this.captureLabelPositions();
    }

    private void captureLabelPositions() {
        if (this.jumpDisplacementHints == null) {
            return;
        }
        for (LabelHint request : this.jumpDisplacementHints) {
            request.capture();
        }
    }

    public LabelHint requestLabelHint(Label label) {
        if (this.jumpDisplacementHints == null) {
            this.jumpDisplacementHints = new ArrayList<LabelHint>();
        }
        LabelHint hint = new LabelHint(label, this.position());
        this.jumpDisplacementHints.add(hint);
        return hint;
    }

    public InstructionCounter getInstructionCounter() {
        throw new UnsupportedOperationException("Instruction counter is not implemented for " + this);
    }

    public boolean isTargetMP() {
        return this.target.isMP;
    }

    public int getReturnAddressSize() {
        return this.target.arch.getReturnAddressSize();
    }

    public int getMachineCodeCallDisplacementOffset() {
        return this.target.arch.getMachineCodeCallDisplacementOffset();
    }

    public boolean inlineObjects() {
        return this.target.inlineObjects;
    }

    public static interface InstructionCounter {
        public String[] getSupportedInstructionTypes();

        public int[] countInstructions(String[] var1, int var2, int var3);
    }

    public static class LabelHint {
        private Label label;
        private int forPosition;
        private int capturedTarget = -1;

        protected LabelHint(Label label, int lastPosition) {
            this.label = label;
            this.forPosition = lastPosition;
        }

        protected void capture() {
            this.capturedTarget = this.label.position();
        }

        public int getTarget() {
            assert (this.isValid());
            return this.capturedTarget;
        }

        public int getPosition() {
            assert (this.isValid());
            return this.forPosition;
        }

        public boolean isValid() {
            return this.capturedTarget >= 0;
        }
    }

    public static abstract class CodeAnnotation {
    }
}

