/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.aarch64;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public abstract class AArch64Assembler
extends Assembler {
    private final EnumSet<AArch64.CPUFeature> features;
    private final EnumSet<AArch64.Flag> flags;
    private static final int RdOffset = 0;
    private static final int Rs1Offset = 5;
    private static final int Rs2Offset = 16;
    private static final int Rs3Offset = 10;
    private static final int RtOffset = 0;
    private static final int RnOffset = 5;
    private static final int Rt2Offset = 10;
    private static final int ImmediateOffset = 10;
    private static final int ImmediateRotateOffset = 16;
    private static final int ImmediateSizeOffset = 22;
    private static final int ExtendTypeOffset = 13;
    private static final int AddSubImmOp = 0x11000000;
    private static final int AddSubShift12 = 0x400000;
    private static final int AddSubSetFlag = 0x20000000;
    private static final int LogicalImmOp = 0x12000000;
    private static final int MoveWideImmOp = 310378496;
    private static final int MoveWideImmOffset = 5;
    private static final int MoveWideShiftOffset = 21;
    private static final int BitfieldImmOp = 0x13000000;
    private static final int AddSubShiftedOp = 0xB000000;
    private static final int ShiftTypeOffset = 22;
    private static final int AddSubExtendedOp = 0xB200000;
    private static final int MulOp = 0x1B000000;
    private static final int SignedMulLongOp = -1692401664;
    private static final int DataProcessing1SourceOp = 1522532352;
    private static final int DataProcessing2SourceOp = 448790528;
    private static final int Fp1SourceOp = 505430016;
    private static final int Fp2SourceOp = 505415680;
    private static final int Fp3SourceOp = 0x1F000000;
    private static final int FpConvertOp = 505413632;
    private static final int FpImmOp = 505417728;
    private static final int FpImmOffset = 13;
    private static final int FpCmpOp = 505421824;
    private static final int FpCmpeOp = 505421840;
    private static final int PcRelImmHiOffset = 5;
    private static final int PcRelImmLoOffset = 29;
    private static final int PcRelImmOp = 0x10000000;
    private static final int UnconditionalBranchImmOp = 0x14000000;
    private static final int UnconditionalBranchRegOp = -704643072;
    private static final int CompareBranchOp = 0x34000000;
    private static final int ConditionalBranchImmOffset = 5;
    private static final int ConditionalSelectOp = 444596224;
    private static final int ConditionalConditionOffset = 12;
    private static final int LoadStoreScaledOp = 0x39000000;
    private static final int LoadStoreUnscaledOp = 0x38000000;
    private static final int LoadStorePostIndexedOp = 939525120;
    private static final int LoadStorePreIndexedOp = 939527168;
    private static final int LoadStoreRegisterOp = 941623296;
    private static final int LoadLiteralOp = 0x18000000;
    private static final int LoadStoreUnscaledImmOffset = 12;
    private static final int LoadStoreScaledImmOffset = 10;
    private static final int LoadStoreScaledRegOffset = 12;
    private static final int LoadStoreIndexedImmOffset = 12;
    private static final int LoadStoreTransferSizeOffset = 30;
    private static final int LoadStoreQuadWordTransferSizeOffset = 23;
    private static final int LoadStoreFpFlagOffset = 26;
    private static final int LoadLiteralImmOffset = 5;
    protected static final int LoadFlag = 0x400000;
    private static final int LoadStorePairSignedOffsetOp = 0x29000000;
    private static final int LoadStorePairPostIndexOp = 0x28800000;
    private static final int LoadStorePairPreIndexOp = 696254464;
    private static final int LoadStorePairImm7Offset = 15;
    private static final int LogicalShiftOp = 0xA000000;
    private static final int ExceptionOp = -738197504;
    private static final int SystemImmediateOffset = 5;
    private static final int SimdImmediateOffset = 16;
    private static final int BarrierOp = -721211361;
    private static final int BarrierKindOffset = 8;
    private static final int CASAcquireOffset = 22;
    private static final int CASReleaseOffset = 15;
    private static final int LDADDAcquireOffset = 23;
    private static final int LDADDReleaseOffset = 22;

    static int rd(Register reg) {
        return reg.encoding << 0;
    }

    static int rs1(Register reg) {
        return reg.encoding << 5;
    }

    static int rs2(Register reg) {
        return reg.encoding << 16;
    }

    private static int rs3(Register reg) {
        return reg.encoding << 10;
    }

    private static int rt(Register reg) {
        return reg.encoding << 0;
    }

    private static int rt2(Register reg) {
        return reg.encoding << 10;
    }

    static int rn(Register reg) {
        return reg.encoding << 5;
    }

    public AArch64Assembler(TargetDescription target) {
        super(target);
        this.features = ((AArch64)target.arch).getFeatures().clone();
        this.flags = ((AArch64)target.arch).getFlags();
    }

    public final EnumSet<AArch64.CPUFeature> getFeatures() {
        return this.features;
    }

    public final EnumSet<AArch64.Flag> getFlags() {
        return this.flags;
    }

    public boolean supports(AArch64.CPUFeature feature) {
        return this.getFeatures().contains(feature);
    }

    public boolean isFlagSet(AArch64.Flag flag) {
        return this.getFlags().contains(flag);
    }

    protected void b(ConditionFlag condition, int imm21) {
        this.b(condition, imm21, -1);
    }

    protected void b(ConditionFlag condition, int imm21, int pos) {
        if (pos == -1) {
            this.emitInt(Instruction.BCOND.encoding | AArch64Assembler.getConditionalBranchImm(imm21) | condition.encoding);
        } else {
            this.emitInt(Instruction.BCOND.encoding | AArch64Assembler.getConditionalBranchImm(imm21) | condition.encoding, pos);
        }
    }

    protected void cbnz(int size, Register reg, int imm21) {
        assert (Asserts.verifySizeAndRegistersR(size, reg));
        this.compareRegisterAndBranchInstruction(reg, imm21, InstructionType.generalFromSize(size), Instruction.CBNZ, -1);
    }

    protected void cbnz(int size, Register reg, int imm21, int pos) {
        assert (Asserts.verifySizeAndRegistersR(size, reg));
        this.compareRegisterAndBranchInstruction(reg, imm21, InstructionType.generalFromSize(size), Instruction.CBNZ, pos);
    }

    protected void cbz(int size, Register reg, int imm21) {
        assert (Asserts.verifySizeAndRegistersR(size, reg));
        this.compareRegisterAndBranchInstruction(reg, imm21, InstructionType.generalFromSize(size), Instruction.CBZ, -1);
    }

    protected void cbz(int size, Register reg, int imm21, int pos) {
        assert (Asserts.verifySizeAndRegistersR(size, reg));
        this.compareRegisterAndBranchInstruction(reg, imm21, InstructionType.generalFromSize(size), Instruction.CBZ, pos);
    }

    protected void tbnz(Register reg, int uimm6, int imm16) {
        this.tbnz(reg, uimm6, imm16, -1);
    }

    protected void tbz(Register reg, int uimm6, int imm16) {
        this.tbz(reg, uimm6, imm16, -1);
    }

    protected void tbnz(Register reg, int uimm6, int imm16, int pos) {
        assert (Asserts.verifyRegistersR(reg));
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        assert (NumUtil.isSignedNbit(16, imm16)) : String.format("Offset value must fit in 16 bits signed: 0x%x", imm16);
        assert ((imm16 & 3) == 0) : String.format("Lower two bits must be zero: 0x%x", imm16 & 3);
        int size = (uimm6 >> 5 & 1) == 0 ? 32 : 64;
        int uimm5 = uimm6 & 0x1F;
        int imm14 = (imm16 & NumUtil.getNbitNumberInt(16)) >> 2;
        InstructionType type = InstructionType.generalFromSize(size);
        int encoding = type.encoding | Instruction.TBNZ.encoding | uimm5 << 19 | imm14 << 5 | AArch64Assembler.rd(reg);
        if (pos == -1) {
            this.emitInt(encoding);
        } else {
            this.emitInt(encoding, pos);
        }
    }

    protected void tbz(Register reg, int uimm6, int imm16, int pos) {
        assert (Asserts.verifyRegistersR(reg));
        assert (NumUtil.isUnsignedNbit(6, uimm6));
        assert (NumUtil.isSignedNbit(16, imm16)) : String.format("Offset value must fit in 16 bits signed: 0x%x", imm16);
        assert ((imm16 & 3) == 0) : String.format("Lower two bits must be zero: 0x%x", imm16 & 3);
        int size = (uimm6 >> 5 & 1) == 0 ? 32 : 64;
        int uimm5 = uimm6 & 0x1F;
        int imm14 = (imm16 & NumUtil.getNbitNumberInt(16)) >> 2;
        InstructionType type = InstructionType.generalFromSize(size);
        int encoding = type.encoding | Instruction.TBZ.encoding | uimm5 << 19 | imm14 << 5 | AArch64Assembler.rd(reg);
        if (pos == -1) {
            this.emitInt(encoding);
        } else {
            this.emitInt(encoding, pos);
        }
    }

    private void compareRegisterAndBranchInstruction(Register reg, int imm21, InstructionType type, Instruction instr, int pos) {
        int instrEncoding = instr.encoding | 0x34000000;
        if (pos == -1) {
            this.emitInt(type.encoding | instrEncoding | AArch64Assembler.getConditionalBranchImm(imm21) | AArch64Assembler.rd(reg));
        } else {
            this.emitInt(type.encoding | instrEncoding | AArch64Assembler.getConditionalBranchImm(imm21) | AArch64Assembler.rd(reg), pos);
        }
    }

    private static int getConditionalBranchImm(int imm21) {
        assert (NumUtil.isSignedNbit(21, imm21) && (imm21 & 3) == 0) : String.format("Immediate has to be 21bit signed number and word aligned got value 0x%x", imm21);
        int imm = (imm21 & NumUtil.getNbitNumberInt(21)) >> 2;
        return imm << 5;
    }

    protected void b() {
        this.unconditionalBranchImmInstruction(0, Instruction.B, -1, true);
    }

    protected void b(int imm28) {
        this.unconditionalBranchImmInstruction(imm28, Instruction.B, -1, false);
    }

    protected void b(int imm28, int pos) {
        this.unconditionalBranchImmInstruction(imm28, Instruction.B, pos, false);
    }

    public void bl() {
        this.unconditionalBranchImmInstruction(0, Instruction.BL, -1, true);
    }

    private void unconditionalBranchImmInstruction(int imm28, Instruction instr, int pos, boolean needsImmAnnotation) {
        assert (NumUtil.isSignedNbit(28, imm28) && (imm28 & 3) == 0) : "Immediate has to be 28bit signed number and word aligned";
        int imm = (imm28 & NumUtil.getNbitNumberInt(28)) >> 2;
        int instrEncoding = instr.encoding | 0x14000000;
        if (needsImmAnnotation) {
            this.annotatePatchingImmediate(pos == -1 ? this.position() : pos, instr, 26, 0, 2);
        }
        if (pos == -1) {
            this.emitInt(instrEncoding | imm);
        } else {
            this.emitInt(instrEncoding | imm, pos);
        }
    }

    public void blr(Register reg) {
        assert (Asserts.verifyRegistersR(reg));
        this.unconditionalBranchRegInstruction(Instruction.BLR, reg);
    }

    protected void br(Register reg) {
        assert (Asserts.verifyRegistersR(reg));
        this.unconditionalBranchRegInstruction(Instruction.BR, reg);
    }

    public void ret(Register reg) {
        assert (Asserts.verifyRegistersR(reg));
        this.unconditionalBranchRegInstruction(Instruction.RET, reg);
    }

    private void unconditionalBranchRegInstruction(Instruction instr, Register reg) {
        this.emitInt(instr.encoding | 0xD6000000 | AArch64Assembler.rs1(reg));
    }

    public static int getLog2TransferSize(int bitMemoryTransferSize) {
        switch (bitMemoryTransferSize) {
            case 8: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 32: {
                return 2;
            }
            case 64: {
                return 3;
            }
            case 128: {
                return 4;
            }
        }
        throw GraalError.shouldNotReachHere("Unexpected transfer size.");
    }

    public void ldr(int srcSize, Register rt, AArch64Address address) {
        this.ldrHelper(srcSize, rt, address, false);
    }

    protected final void ldrHelper(int srcSize, Register rt, AArch64Address address, boolean allowZeroReg) {
        assert (srcSize == 8 || srcSize == 16 || srcSize == 32 || srcSize == 64);
        assert (!allowZeroReg ? Asserts.verifyRegistersR(rt) : Asserts.verifyRegistersZ(rt));
        int loadFlag = address.getAddressingMode() == AArch64Address.AddressingMode.PC_LITERAL ? 0 : 0x400000;
        this.loadStoreInstruction(Instruction.LDR, rt, address, false, AArch64Assembler.getLog2TransferSize(srcSize), loadFlag);
    }

    protected void ldrs(int targetSize, int srcSize, Register rt, AArch64Address address) {
        assert (srcSize == 8 || srcSize == 16 || srcSize == 32);
        assert (targetSize == 32 || targetSize == 64);
        assert (srcSize != targetSize);
        assert (Asserts.verifyRegistersR(rt));
        int target32BitFlag = targetSize == 32 ? 0x400000 : 0;
        this.loadStoreInstruction(Instruction.LDRS, rt, address, false, AArch64Assembler.getLog2TransferSize(srcSize), target32BitFlag);
    }

    public void prfm(AArch64Address address, PrefetchMode mode) {
        int prfmFlag;
        assert (mode != null);
        switch (address.getAddressingMode()) {
            case IMMEDIATE_UNSIGNED_SCALED: 
            case IMMEDIATE_SIGNED_UNSCALED: 
            case BASE_REGISTER_ONLY: 
            case REGISTER_OFFSET: 
            case EXTENDED_REGISTER_OFFSET: {
                prfmFlag = 0x800000;
                break;
            }
            case PC_LITERAL: {
                prfmFlag = Integer.MIN_VALUE;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        Register rt = mode.toRegister();
        this.loadStoreInstruction(Instruction.LDR, rt, address, false, AArch64Assembler.getLog2TransferSize(64), prfmFlag);
    }

    public void str(int destSize, Register rt, AArch64Address address) {
        assert (destSize == 8 || destSize == 16 || destSize == 32 || destSize == 64);
        assert (Asserts.verifyRegistersZ(rt));
        this.loadStoreInstruction(Instruction.STR, rt, address, false, AArch64Assembler.getLog2TransferSize(destSize));
    }

    private void loadStoreInstruction(Instruction instr, Register reg, AArch64Address address, boolean isFP, int log2TransferSize) {
        this.loadStoreInstruction(instr, reg, address, isFP, log2TransferSize, 0);
    }

    private void loadStoreInstruction(Instruction instr, Register reg, AArch64Address address, boolean isFP, int log2TransferSize, int extraEncoding) {
        int transferSizeEncoding;
        assert (log2TransferSize >= 0 && log2TransferSize < (isFP ? 5 : 4));
        assert (address.getBitMemoryTransferSize() == -1 || AArch64Assembler.getLog2TransferSize(address.getBitMemoryTransferSize()) == log2TransferSize);
        if (address.getAddressingMode() == AArch64Address.AddressingMode.PC_LITERAL) {
            assert (log2TransferSize >= 2) : "PC literal loads only works for load/stores of 32-bit and larger";
            transferSizeEncoding = log2TransferSize - 2 << 30;
        } else {
            transferSizeEncoding = (log2TransferSize & 3) << 30 | log2TransferSize >> 2 << 23;
        }
        int floatFlag = isFP ? 0x4000000 : 0;
        int memOp = extraEncoding | transferSizeEncoding | instr.encoding | floatFlag | AArch64Assembler.rt(reg);
        switch (address.getAddressingMode()) {
            case IMMEDIATE_UNSIGNED_SCALED: {
                this.emitInt(memOp | 0x39000000 | address.getImmediate() << 10 | AArch64Assembler.rs1(address.getBase()));
                break;
            }
            case IMMEDIATE_SIGNED_UNSCALED: {
                this.emitInt(memOp | 0x38000000 | address.getImmediate() << 12 | AArch64Assembler.rs1(address.getBase()));
                break;
            }
            case BASE_REGISTER_ONLY: {
                this.emitInt(memOp | 0x39000000 | AArch64Assembler.rs1(address.getBase()));
                break;
            }
            case REGISTER_OFFSET: 
            case EXTENDED_REGISTER_OFFSET: {
                ExtendType extendType = address.getAddressingMode() == AArch64Address.AddressingMode.EXTENDED_REGISTER_OFFSET ? address.getExtendType() : ExtendType.UXTX;
                int shouldScaleFlag = (address.isRegisterOffsetScaled() ? 1 : 0) << 12;
                this.emitInt(memOp | 0x38200800 | AArch64Assembler.rs2(address.getOffset()) | extendType.encoding << 13 | shouldScaleFlag | AArch64Assembler.rs1(address.getBase()));
                break;
            }
            case PC_LITERAL: {
                this.annotatePatchingImmediate(this.position(), instr, 21, 5, 2);
                this.emitInt(transferSizeEncoding | floatFlag | 0x18000000 | AArch64Assembler.rd(reg) | address.getImmediate() << 5);
                break;
            }
            case IMMEDIATE_POST_INDEXED: {
                this.emitInt(memOp | 0x38000400 | AArch64Assembler.rs1(address.getBase()) | address.getImmediate() << 12);
                break;
            }
            case IMMEDIATE_PRE_INDEXED: {
                this.emitInt(memOp | 0x38000C00 | AArch64Assembler.rs1(address.getBase()) | address.getImmediate() << 12);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unhandled addressing mode: " + address.getAddressingMode());
            }
        }
    }

    protected void insertLdpStp(int position, int size, Instruction instr, boolean isFP, Register rt, Register rt2, AArch64Address address) {
        if (isFP) {
            assert (size == 32 || size == 64 || size == 128) : size;
            assert (Asserts.verifyRegistersFF(rt, rt2));
        } else assert (Asserts.verifySizeAndRegistersZZ(size, rt, rt2));
        int instructionEncoding = AArch64Assembler.generateLoadStorePairInstructionEncoding(instr, rt, rt2, address, isFP, AArch64Assembler.getLog2TransferSize(size));
        this.emitInt(instructionEncoding, position);
    }

    public void ldp(int size, Register rt, Register rt2, AArch64Address address) {
        assert (Asserts.verifySizeAndRegistersRR(size, rt, rt2));
        this.loadStorePairInstruction(Instruction.LDP, rt, rt2, address, false, AArch64Assembler.getLog2TransferSize(size));
    }

    public void stp(int size, Register rt, Register rt2, AArch64Address address) {
        assert (Asserts.verifySizeAndRegistersZZ(size, rt, rt2));
        this.loadStorePairInstruction(Instruction.STP, rt, rt2, address, false, AArch64Assembler.getLog2TransferSize(size));
    }

    private static int generateLoadStorePairInstructionEncoding(Instruction instr, Register rt, Register rt2, AArch64Address address, boolean isFP, int log2TransferSize) {
        assert (log2TransferSize >= 2 && log2TransferSize < (isFP ? 5 : 4));
        assert (AArch64Assembler.getLog2TransferSize(address.getBitMemoryTransferSize()) == log2TransferSize);
        int transferSizeEncoding = log2TransferSize - 2 << (isFP ? 30 : 31);
        int floatFlag = isFP ? 0x4000000 : 0;
        int offset = address.getImmediate();
        int memOp = transferSizeEncoding | instr.encoding | floatFlag | offset << 15 | AArch64Assembler.rt2(rt2) | AArch64Assembler.rn(address.getBase()) | AArch64Assembler.rt(rt);
        switch (address.getAddressingMode()) {
            case IMMEDIATE_PAIR_SIGNED_SCALED: {
                return memOp | 0x29000000;
            }
            case IMMEDIATE_PAIR_POST_INDEXED: {
                return memOp | 0x28800000;
            }
            case IMMEDIATE_PAIR_PRE_INDEXED: {
                return memOp | 0x29800000;
            }
        }
        throw GraalError.shouldNotReachHere("Unhandled addressing mode: " + address.getAddressingMode());
    }

    private void loadStorePairInstruction(Instruction instr, Register rt, Register rt2, AArch64Address address, boolean isFP, int log2TransferSize) {
        int instructionEncoding = AArch64Assembler.generateLoadStorePairInstructionEncoding(instr, rt, rt2, address, isFP, log2TransferSize);
        this.emitInt(instructionEncoding);
    }

    protected void ldxr(int size, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRP(rt, rn));
        this.exclusiveLoadInstruction(Instruction.LDXR, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    protected void stxr(int size, Register rs, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRZP(rs, rt, rn));
        this.exclusiveStoreInstruction(Instruction.STXR, rs, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    public void ldar(int size, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRP(rt, rn));
        this.exclusiveLoadInstruction(Instruction.LDAR, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    public void stlr(int size, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersZP(rt, rn));
        this.exclusiveStoreInstruction(Instruction.STLR, AArch64.r0, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    protected void ldaxr(int size, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRP(rt, rn));
        this.exclusiveLoadInstruction(Instruction.LDAXR, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    protected void stlxr(int size, Register rs, Register rt, Register rn) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRZP(rs, rt, rn));
        this.exclusiveStoreInstruction(Instruction.STLXR, rs, rt, rn, AArch64Assembler.getLog2TransferSize(size));
    }

    private void exclusiveLoadInstruction(Instruction instr, Register rt, Register rn, int log2TransferSize) {
        assert (log2TransferSize >= 0 && log2TransferSize < 4);
        int transferSizeEncoding = log2TransferSize << 30;
        this.emitInt(transferSizeEncoding | instr.encoding | AArch64Assembler.rn(rn) | AArch64Assembler.rt(rt));
    }

    private void exclusiveStoreInstruction(Instruction instr, Register rs, Register rt, Register rn, int log2TransferSize) {
        assert (log2TransferSize >= 0 && log2TransferSize < 4);
        assert (instr == Instruction.STLR || !rs.equals((Object)rt) && !rs.equals((Object)rn));
        int transferSizeEncoding = log2TransferSize << 30;
        this.emitInt(transferSizeEncoding | instr.encoding | AArch64Assembler.rs2(rs) | AArch64Assembler.rn(rn) | AArch64Assembler.rt(rt));
    }

    public void cas(int size, Register rs, Register rt, Register rn, boolean acquire, boolean release) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRZP(rs, rt, rn));
        this.compareAndSwapInstruction(Instruction.CAS, rs, rt, rn, AArch64Assembler.getLog2TransferSize(size), acquire, release);
    }

    private void compareAndSwapInstruction(Instruction instr, Register rs, Register rt, Register rn, int log2TransferSize, boolean acquire, boolean release) {
        int transferSizeEncoding = log2TransferSize << 30;
        this.emitInt(transferSizeEncoding | instr.encoding | AArch64Assembler.rs2(rs) | AArch64Assembler.rn(rn) | AArch64Assembler.rt(rt) | (acquire ? 1 : 0) << 22 | (release ? 1 : 0) << 15);
    }

    public void ldadd(int size, Register rs, Register rt, Register rn, boolean acquire, boolean release) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersZRP(rs, rt, rn));
        this.loadAndAddInstruction(Instruction.LDADD, rs, rt, rn, AArch64Assembler.getLog2TransferSize(size), acquire, release);
    }

    private void loadAndAddInstruction(Instruction instr, Register rs, Register rt, Register rn, int log2TransferSize, boolean acquire, boolean release) {
        int transferSizeEncoding = log2TransferSize << 30;
        this.emitInt(transferSizeEncoding | instr.encoding | AArch64Assembler.rs2(rs) | AArch64Assembler.rn(rn) | AArch64Assembler.rt(rt) | (acquire ? 1 : 0) << 23 | (release ? 1 : 0) << 22);
    }

    public void swp(int size, Register rs, Register rt, Register rn, boolean acquire, boolean release) {
        assert (size == 8 || size == 16 || size == 32 || size == 64);
        assert (Asserts.verifyRegistersRZP(rs, rt, rn));
        this.swapInstruction(Instruction.SWP, rs, rt, rn, AArch64Assembler.getLog2TransferSize(size), acquire, release);
    }

    private void swapInstruction(Instruction instr, Register rs, Register rt, Register rn, int log2TransferSize, boolean acquire, boolean release) {
        int transferSizeEncoding = log2TransferSize << 30;
        this.emitInt(transferSizeEncoding | instr.encoding | AArch64Assembler.rs2(rs) | AArch64Assembler.rn(rn) | AArch64Assembler.rt(rt) | (acquire ? 1 : 0) << 23 | (release ? 1 : 0) << 22);
    }

    public void adrp(Register dst) {
        assert (Asserts.verifyRegistersR(dst));
        this.emitInt(Instruction.ADRP.encoding | 0x10000000 | AArch64Assembler.rd(dst));
    }

    public void adr(Register dst, int imm21) {
        assert (Asserts.verifyRegistersR(dst));
        this.emitInt(Instruction.ADR.encoding | 0x10000000 | AArch64Assembler.rd(dst) | AArch64Assembler.getPcRelativeImmEncoding(imm21));
    }

    public void adr(Register dst, int imm21, int pos) {
        assert (Asserts.verifyRegistersR(dst));
        this.emitInt(Instruction.ADR.encoding | 0x10000000 | AArch64Assembler.rd(dst) | AArch64Assembler.getPcRelativeImmEncoding(imm21), pos);
    }

    private static int getPcRelativeImmEncoding(int imm21) {
        assert (NumUtil.isSignedNbit(21, imm21));
        int imm = imm21 & NumUtil.getNbitNumberInt(21);
        int immHi = imm >> 2 << 5;
        int immLo = (imm & 3) << 29;
        return immHi | immLo;
    }

    protected void add(int size, Register dst, Register src, int aimm) {
        assert (Asserts.verifySizeAndRegistersPP(size, dst, src));
        this.addSubImmInstruction(Instruction.ADD, dst, src, aimm, InstructionType.generalFromSize(size));
    }

    protected void adds(int size, Register dst, Register src, int aimm) {
        assert (Asserts.verifySizeAndRegistersZP(size, dst, src));
        this.addSubImmInstruction(Instruction.ADDS, dst, src, aimm, InstructionType.generalFromSize(size));
    }

    protected void sub(int size, Register dst, Register src, int aimm) {
        assert (Asserts.verifySizeAndRegistersPP(size, dst, src));
        this.addSubImmInstruction(Instruction.SUB, dst, src, aimm, InstructionType.generalFromSize(size));
    }

    protected void subs(int size, Register dst, Register src, int aimm) {
        assert (Asserts.verifySizeAndRegistersZP(size, dst, src));
        this.addSubImmInstruction(Instruction.SUBS, dst, src, aimm, InstructionType.generalFromSize(size));
    }

    private void addSubImmInstruction(Instruction instr, Register dst, Register src, int aimm, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x11000000 | AArch64Assembler.encodeAddSubtractImm(aimm) | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void ccmp(int size, Register x, Register y, int aimm, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersZZ(size, x, y));
        this.emitInt(InstructionType.generalFromSize((int)size).encoding | Instruction.CCMP.encoding | AArch64Assembler.rs1(x) | AArch64Assembler.rs2(y) | AArch64Assembler.encodeAddSubtractImm(aimm) | condition.encoding << 12);
    }

    private static int encodeAddSubtractImm(int imm) {
        assert (AArch64Assembler.isAddSubtractImmediate(imm, false)) : "Immediate has to be legal add/substract immediate value " + imm;
        if (NumUtil.isUnsignedNbit(12, imm)) {
            return imm << 10;
        }
        return imm >>> 12 << 10 | 0x400000;
    }

    public static boolean isAddSubtractImmediate(long imm, boolean useAbs) {
        long checkedImm = useAbs ? Math.abs(imm) : imm;
        return NumUtil.isUnsignedNbit(12, checkedImm) || NumUtil.isUnsignedNbit(12, checkedImm >>> 12) && (checkedImm & 0xFFFL) == 0L;
    }

    public void and(int size, Register dst, Register src, long bimm) {
        assert (Asserts.verifySizeAndRegistersPR(size, dst, src));
        this.logicalImmInstruction(Instruction.AND, dst, src, bimm, InstructionType.generalFromSize(size));
    }

    public void ands(int size, Register dst, Register src, long bimm) {
        assert (Asserts.verifySizeAndRegistersZZ(size, dst, src));
        this.logicalImmInstruction(Instruction.ANDS, dst, src, bimm, InstructionType.generalFromSize(size));
    }

    public void eor(int size, Register dst, Register src, long bimm) {
        assert (Asserts.verifySizeAndRegistersPZ(size, dst, src));
        this.logicalImmInstruction(Instruction.EOR, dst, src, bimm, InstructionType.generalFromSize(size));
    }

    public void orr(int size, Register dst, Register src, long bimm) {
        assert (Asserts.verifySizeAndRegistersPZ(size, dst, src));
        this.logicalImmInstruction(Instruction.ORR, dst, src, bimm, InstructionType.generalFromSize(size));
    }

    private void logicalImmInstruction(Instruction instr, Register dst, Register src, long bimm, InstructionType type) {
        long bimmValue;
        if (type == InstructionType.General32) {
            assert (bimm >> 32 == 0L || bimm >> 32 == -1L && (int)bimm < 0) : "Immediate must be either 0x0000_0000_xxxx_xxxx or (0xFFFF_FFFF_xxxx_xxxx | 0x8000_0000)";
            bimmValue = bimm & NumUtil.getNbitNumberLong(32);
        } else {
            bimmValue = bimm;
        }
        int immEncoding = LogicalBitmaskImmediateEncoding.getEncoding(type == InstructionType.General64, bimmValue);
        this.emitInt(type.encoding | instr.encoding | 0x12000000 | immEncoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    protected void movz(int size, Register dst, int uimm16, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersR(size, dst));
        this.moveWideImmInstruction(Instruction.MOVZ, dst, uimm16, shiftAmt, InstructionType.generalFromSize(size));
    }

    protected void movn(int size, Register dst, int uimm16, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersR(size, dst));
        this.moveWideImmInstruction(Instruction.MOVN, dst, uimm16, shiftAmt, InstructionType.generalFromSize(size));
    }

    protected void movk(int size, Register dst, int uimm16, int pos) {
        assert (Asserts.verifySizeAndRegistersR(size, dst));
        this.moveWideImmInstruction(Instruction.MOVK, dst, uimm16, pos, InstructionType.generalFromSize(size));
    }

    private void moveWideImmInstruction(Instruction instr, Register dst, int uimm16, int shiftAmt, InstructionType type) {
        assert (NumUtil.isUnsignedNbit(16, uimm16)) : "Immediate has to be unsigned 16bit";
        assert (shiftAmt == 0 || shiftAmt == 16 || type == InstructionType.General64 && (shiftAmt == 32 || shiftAmt == 48)) : "Invalid shift amount: " + shiftAmt;
        int shiftValue = shiftAmt >> 4;
        this.emitInt(type.encoding | instr.encoding | 0x12800000 | AArch64Assembler.rd(dst) | uimm16 << 5 | shiftValue << 21);
    }

    public void bfm(int size, Register dst, Register src, int r, int s) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.bitfieldInstruction(Instruction.BFM, dst, src, r, s, InstructionType.generalFromSize(size));
    }

    public void ubfm(int size, Register dst, Register src, int r, int s) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.bitfieldInstruction(Instruction.UBFM, dst, src, r, s, InstructionType.generalFromSize(size));
    }

    public void sbfm(int size, Register dst, Register src, int r, int s) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.bitfieldInstruction(Instruction.SBFM, dst, src, r, s, InstructionType.generalFromSize(size));
    }

    private void bitfieldInstruction(Instruction instr, Register dst, Register src, int r, int s, InstructionType type) {
        assert (s >= 0 && s < type.width && r >= 0 && r < type.width);
        int sf = type == InstructionType.General64 ? 0x400000 : 0;
        this.emitInt(type.encoding | instr.encoding | 0x13000000 | sf | r << 16 | s << 10 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    protected void extr(int size, Register dst, Register src1, Register src2, int lsb) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        InstructionType type = InstructionType.generalFromSize(size);
        assert (lsb >= 0 && lsb < type.width);
        int sf = type == InstructionType.General64 ? 0x400000 : 0;
        this.emitInt(type.encoding | Instruction.EXTR.encoding | sf | lsb << 10 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    protected void add(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int imm) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.addSubShiftedInstruction(Instruction.ADD, dst, src1, src2, shiftType, imm, InstructionType.generalFromSize(size));
    }

    public void adds(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int imm) {
        assert (Asserts.verifySizeAndRegistersZZZ(size, dst, src1, src2));
        this.addSubShiftedInstruction(Instruction.ADDS, dst, src1, src2, shiftType, imm, InstructionType.generalFromSize(size));
    }

    protected void sub(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int imm) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.addSubShiftedInstruction(Instruction.SUB, dst, src1, src2, shiftType, imm, InstructionType.generalFromSize(size));
    }

    public void subs(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int imm) {
        assert (Asserts.verifySizeAndRegistersZZZ(size, dst, src1, src2));
        this.addSubShiftedInstruction(Instruction.SUBS, dst, src1, src2, shiftType, imm, InstructionType.generalFromSize(size));
    }

    private void addSubShiftedInstruction(Instruction instr, Register dst, Register src1, Register src2, ShiftType shiftType, int imm, InstructionType type) {
        assert (shiftType != ShiftType.ROR);
        assert (imm >= 0 && imm < type.width);
        this.emitInt(type.encoding | instr.encoding | 0xB000000 | imm << 10 | shiftType.encoding << 22 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void add(int size, Register dst, Register src1, Register src2, ExtendType extendType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersPPZ(size, dst, src1, src2));
        this.addSubExtendedInstruction(Instruction.ADD, dst, src1, src2, extendType, shiftAmt, InstructionType.generalFromSize(size));
    }

    protected void adds(int size, Register dst, Register src1, Register src2, ExtendType extendType, int shiftAmt) {
        assert (Asserts.verifySizeRegistersZPZ(size, dst, src1, src2));
        this.addSubExtendedInstruction(Instruction.ADDS, dst, src1, src2, extendType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void sub(int size, Register dst, Register src1, Register src2, ExtendType extendType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersPPZ(size, dst, src1, src2));
        this.addSubExtendedInstruction(Instruction.SUB, dst, src1, src2, extendType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void subs(int size, Register dst, Register src1, Register src2, ExtendType extendType, int shiftAmt) {
        assert (Asserts.verifySizeRegistersZPZ(size, dst, src1, src2));
        this.addSubExtendedInstruction(Instruction.SUBS, dst, src1, src2, extendType, shiftAmt, InstructionType.generalFromSize(size));
    }

    private void addSubExtendedInstruction(Instruction instr, Register dst, Register src1, Register src2, ExtendType extendType, int shiftAmt, InstructionType type) {
        assert (shiftAmt >= 0 && shiftAmt <= 4);
        this.emitInt(type.encoding | instr.encoding | 0xB200000 | shiftAmt << 10 | extendType.encoding << 13 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void and(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.AND, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    protected void ands(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersZZZ(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.ANDS, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void bic(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.BIC, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    protected void bics(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersZZZ(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.BICS, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void eon(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.EON, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void eor(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.EOR, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void orr(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.ORR, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    public void orn(int size, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt) {
        assert (Asserts.verifySizeAndRegistersRZR(size, dst, src1, src2));
        this.logicalRegInstruction(Instruction.ORN, dst, src1, src2, shiftType, shiftAmt, InstructionType.generalFromSize(size));
    }

    private void logicalRegInstruction(Instruction instr, Register dst, Register src1, Register src2, ShiftType shiftType, int shiftAmt, InstructionType type) {
        assert (shiftAmt >= 0 && shiftAmt < type.width);
        this.emitInt(type.encoding | instr.encoding | 0xA000000 | shiftAmt << 10 | shiftType.encoding << 22 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void asr(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.ASRV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    public void lsl(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.LSLV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    public void lsr(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.LSRV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    protected void rorv(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.RORV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    protected void cls(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.dataProcessing1SourceOp(Instruction.CLS, dst, src, InstructionType.generalFromSize(size));
    }

    public void clz(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.dataProcessing1SourceOp(Instruction.CLZ, dst, src, InstructionType.generalFromSize(size));
    }

    public void rbit(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        this.dataProcessing1SourceOp(Instruction.RBIT, dst, src, InstructionType.generalFromSize(size));
    }

    public void rev(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersRR(size, dst, src));
        if (size == 64) {
            this.dataProcessing1SourceOp(Instruction.REVX, dst, src, InstructionType.generalFromSize(size));
        } else {
            assert (size == 32);
            this.dataProcessing1SourceOp(Instruction.REVW, dst, src, InstructionType.generalFromSize(size));
        }
    }

    public void csel(int size, Register dst, Register src1, Register src2, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.conditionalSelectInstruction(Instruction.CSEL, dst, src1, src2, condition, InstructionType.generalFromSize(size));
    }

    public void csneg(int size, Register dst, Register src1, Register src2, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.conditionalSelectInstruction(Instruction.CSNEG, dst, src1, src2, condition, InstructionType.generalFromSize(size));
    }

    protected void csinc(int size, Register dst, Register src1, Register src2, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersRZZ(size, dst, src1, src2));
        this.conditionalSelectInstruction(Instruction.CSINC, dst, src1, src2, condition, InstructionType.generalFromSize(size));
    }

    private void conditionalSelectInstruction(Instruction instr, Register dst, Register src1, Register src2, ConditionFlag condition, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1A800000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | condition.encoding << 12);
    }

    public void madd(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.mulInstruction(Instruction.MADD, dst, src1, src2, src3, InstructionType.generalFromSize(size));
    }

    public void msub(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.mulInstruction(Instruction.MSUB, dst, src1, src2, src3, InstructionType.generalFromSize(size));
    }

    protected void smulh(Register dst, Register src1, Register src2) {
        assert (Asserts.verifyRegistersRRR(dst, src1, src2));
        this.emitInt(0x9B400000 | dst.encoding | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | 0x7C00);
    }

    protected void umulh(Register dst, Register src1, Register src2) {
        assert (Asserts.verifyRegistersRRR(dst, src1, src2));
        this.emitInt(0x9BC00000 | dst.encoding | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | 0x7C00);
    }

    protected void umaddl(Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifyRegistersRRRZ(dst, src1, src2, src3));
        this.emitInt(0x9BA00000 | dst.encoding | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | 0x7C00);
    }

    public void smaddl(Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifyRegistersRRRZ(dst, src1, src2, src3));
        this.smullInstruction(Instruction.MADD, dst, src1, src2, src3);
    }

    public void smsubl(Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifyRegistersRRRZ(dst, src1, src2, src3));
        this.smullInstruction(Instruction.MSUB, dst, src1, src2, src3);
    }

    private void mulInstruction(Instruction instr, Register dst, Register src1, Register src2, Register src3, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1B000000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | AArch64Assembler.rs3(src3));
    }

    private void smullInstruction(Instruction instr, Register dst, Register src1, Register src2, Register src3) {
        this.emitInt(instr.encoding | 0x9B200000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | AArch64Assembler.rs3(src3));
    }

    public void sdiv(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.SDIV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    public void udiv(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersRRR(size, dst, src1, src2));
        this.dataProcessing2SourceOp(Instruction.UDIV, dst, src1, src2, InstructionType.generalFromSize(size));
    }

    private void dataProcessing1SourceOp(Instruction instr, Register dst, Register src, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x5AC00000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    private void dataProcessing2SourceOp(Instruction instr, Register dst, Register src1, Register src2, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1AC00000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fldr(int size, Register rt, AArch64Address address) {
        assert (size == 8 || size == 16 || size == 32 || size == 64 || size == 128);
        assert (Asserts.verifyRegistersF(rt));
        int loadFlag = address.getAddressingMode() == AArch64Address.AddressingMode.PC_LITERAL ? 0 : 0x400000;
        this.loadStoreInstruction(Instruction.LDR, rt, address, true, AArch64Assembler.getLog2TransferSize(size), loadFlag);
    }

    public void fstr(int size, Register rt, AArch64Address address) {
        assert (size == 8 || size == 16 || size == 32 || size == 64 || size == 128);
        assert (Asserts.verifyRegistersF(rt));
        this.loadStoreInstruction(Instruction.STR, rt, address, true, AArch64Assembler.getLog2TransferSize(size));
    }

    public void fldp(int size, Register rt, Register rt2, AArch64Address address) {
        assert (size == 32 || size == 64 || size == 128);
        assert (Asserts.verifyRegistersFF(rt, rt2));
        this.loadStorePairInstruction(Instruction.LDP, rt, rt2, address, true, AArch64Assembler.getLog2TransferSize(size));
    }

    public void fstp(int size, Register rt, Register rt2, AArch64Address address) {
        assert (size == 32 || size == 64 || size == 128);
        assert (Asserts.verifyRegistersFF(rt, rt2));
        this.loadStorePairInstruction(Instruction.STP, rt, rt2, address, true, AArch64Assembler.getLog2TransferSize(size));
    }

    protected void fmovFpu2Fpu(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FMOV, dst, src, InstructionType.floatFromSize(size));
    }

    protected void fmovFpu2Cpu(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersRF(size, dst, src));
        this.fmovCpuFpuInstruction(dst, src, size == 64, Instruction.FMOVFPU2CPU);
    }

    protected void fmovCpu2Fpu(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFZ(size, dst, src));
        this.fmovCpuFpuInstruction(dst, src, size == 64, Instruction.FMOVCPU2FPU);
    }

    private void fmovCpuFpuInstruction(Register dst, Register src, boolean is64bit, Instruction instr) {
        int sf = is64bit ? InstructionType.FP64.encoding | InstructionType.General64.encoding : InstructionType.FP32.encoding | InstructionType.General32.encoding;
        this.emitInt(sf | instr.encoding | 0x1E200000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    protected void fmov(int size, Register dst, double imm) {
        int immEncoding;
        assert (Asserts.verifySizeAndRegistersF(size, dst));
        InstructionType type = InstructionType.floatFromSize(size);
        if (type == InstructionType.FP64) {
            immEncoding = AArch64Assembler.getDoubleImmediate(imm);
        } else {
            assert (imm == (double)((float)imm)) : "float mov must use an immediate that can be represented using a float.";
            immEncoding = AArch64Assembler.getFloatImmediate((float)imm);
        }
        this.emitInt(type.encoding | Instruction.FMOV.encoding | 0x1E201000 | immEncoding | AArch64Assembler.rd(dst));
    }

    private static int getDoubleImmediate(double imm) {
        assert (AArch64Assembler.isDoubleImmediate(imm));
        long repr = Double.doubleToRawLongBits(imm);
        int a = (int)(repr >>> 63) << 7;
        int b = (int)(repr >>> 61 & 1L) << 6;
        int cToH = (int)(repr >>> 48) & 0x3F;
        return (a | b | cToH) << 13;
    }

    protected static boolean isDoubleImmediate(double imm) {
        long bits = Double.doubleToRawLongBits(imm);
        if ((bits & NumUtil.getNbitNumberLong(48)) != 0L) {
            return false;
        }
        long pattern = bits >> 54 & NumUtil.getNbitNumberLong(8);
        if (pattern != 0L && pattern != NumUtil.getNbitNumberLong(8)) {
            return false;
        }
        boolean result = ((bits ^ bits << 1) & 0x4000000000000000L) != 0L;
        return result;
    }

    private static int getFloatImmediate(float imm) {
        assert (AArch64Assembler.isFloatImmediate(imm));
        int repr = Float.floatToRawIntBits(imm);
        int a = repr >>> 31 << 7;
        int b = (repr >>> 29 & 1) << 6;
        int cToH = repr >>> 19 & NumUtil.getNbitNumberInt(6);
        return (a | b | cToH) << 13;
    }

    protected static boolean isFloatImmediate(float imm) {
        int bits = Float.floatToRawIntBits(imm);
        if ((bits & NumUtil.getNbitNumberInt(19)) != 0) {
            return false;
        }
        int pattern = bits >> 25 & NumUtil.getNbitNumberInt(5);
        if (pattern != 0 && pattern != NumUtil.getNbitNumberInt(5)) {
            return false;
        }
        return ((bits ^ bits << 1) & 0x40000000) != 0;
    }

    public void fcvt(int dstSize, int srcSize, Register dst, Register src) {
        assert (Asserts.verifySizesAndRegistersFF(dstSize, srcSize, dst, src));
        assert (dstSize != srcSize);
        if (srcSize == 32) {
            this.fpDataProcessing1Source(Instruction.FCVTDS, dst, src, InstructionType.floatFromSize(srcSize));
        } else {
            this.fpDataProcessing1Source(Instruction.FCVTSD, dst, src, InstructionType.floatFromSize(srcSize));
        }
    }

    public void fcvtzs(int dstSize, int srcSize, Register dst, Register src) {
        assert (Asserts.verifySizesAndRegistersRF(dstSize, srcSize, dst, src));
        this.fcvtCpuFpuInstruction(Instruction.FCVTZS, dst, src, InstructionType.generalFromSize(dstSize), InstructionType.floatFromSize(srcSize));
    }

    public void scvtf(int dstSize, int srcSize, Register dst, Register src) {
        assert (Asserts.verifySizesAndRegistersFZ(dstSize, srcSize, dst, src));
        this.fcvtCpuFpuInstruction(Instruction.SCVTF, dst, src, InstructionType.floatFromSize(dstSize), InstructionType.generalFromSize(srcSize));
    }

    private void fcvtCpuFpuInstruction(Instruction instr, Register dst, Register src, InstructionType type1, InstructionType type2) {
        this.emitInt(type1.encoding | type2.encoding | instr.encoding | 0x1E200000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void frintz(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FRINTZ, dst, src, InstructionType.floatFromSize(size));
    }

    public void frintn(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FRINTN, dst, src, InstructionType.floatFromSize(size));
    }

    public void frintm(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FRINTM, dst, src, InstructionType.floatFromSize(size));
    }

    public void frintp(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FRINTP, dst, src, InstructionType.floatFromSize(size));
    }

    public void fabs(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FABS, dst, src, InstructionType.floatFromSize(size));
    }

    public void fneg(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FNEG, dst, src, InstructionType.floatFromSize(size));
    }

    public void fsqrt(int size, Register dst, Register src) {
        assert (Asserts.verifySizeAndRegistersFF(size, dst, src));
        this.fpDataProcessing1Source(Instruction.FSQRT, dst, src, InstructionType.floatFromSize(size));
    }

    private void fpDataProcessing1Source(Instruction instr, Register dst, Register src, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1E204000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src));
    }

    public void fadd(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FADD, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    public void fsub(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FSUB, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    public void fmul(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FMUL, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    public void fdiv(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FDIV, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    private void fpDataProcessing2Source(Instruction instr, Register dst, Register src1, Register src2, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1E200800 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fmax(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FMAX, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    public void fmin(int size, Register dst, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        this.fpDataProcessing2Source(Instruction.FMIN, dst, src1, src2, InstructionType.floatFromSize(size));
    }

    public void fmadd(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifySizeAndRegistersFFFF(size, dst, src1, src2, src3));
        this.fpDataProcessing3Source(Instruction.FMADD, dst, src1, src2, src3, InstructionType.floatFromSize(size));
    }

    protected void fmsub(int size, Register dst, Register src1, Register src2, Register src3) {
        assert (Asserts.verifySizeAndRegistersFFFF(size, dst, src1, src2, src3));
        this.fpDataProcessing3Source(Instruction.FMSUB, dst, src1, src2, src3, InstructionType.floatFromSize(size));
    }

    private void fpDataProcessing3Source(Instruction instr, Register dst, Register src1, Register src2, Register src3, InstructionType type) {
        this.emitInt(type.encoding | instr.encoding | 0x1F000000 | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | AArch64Assembler.rs3(src3));
    }

    public void fcmp(int size, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFF(size, src1, src2));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCMP.encoding | 0x1E202000 | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fcmpe(int size, Register src1, Register src2) {
        assert (Asserts.verifySizeAndRegistersFF(size, src1, src2));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCMP.encoding | 0x1E202010 | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fccmp(int size, Register src1, Register src2, int uimm4, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersFF(size, src1, src2));
        assert (NumUtil.isUnsignedNbit(4, uimm4));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCCMP.encoding | uimm4 | condition.encoding << 12 | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2));
    }

    public void fcmpZero(int size, Register src) {
        assert (Asserts.verifySizeAndRegistersF(size, src));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCMPZERO.encoding | 0x1E202000 | AArch64Assembler.rs1(src));
    }

    public void fcmpeZero(int size, Register src) {
        assert (Asserts.verifySizeAndRegistersF(size, src));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCMPZERO.encoding | 0x1E202010 | AArch64Assembler.rs1(src));
    }

    public void fcsel(int size, Register dst, Register src1, Register src2, ConditionFlag condition) {
        assert (Asserts.verifySizeAndRegistersFFF(size, dst, src1, src2));
        InstructionType type = InstructionType.floatFromSize(size);
        this.emitInt(type.encoding | Instruction.FCSEL.encoding | AArch64Assembler.rd(dst) | AArch64Assembler.rs1(src1) | AArch64Assembler.rs2(src2) | condition.encoding << 12);
    }

    protected void hlt(int uimm16) {
        this.exceptionInstruction(Instruction.HLT, uimm16);
    }

    protected void brk(int uimm16) {
        this.exceptionInstruction(Instruction.BRK, uimm16);
    }

    private void exceptionInstruction(Instruction instr, int uimm16) {
        assert (NumUtil.isUnsignedNbit(16, uimm16));
        this.emitInt(instr.encoding | 0xD4000000 | uimm16 << 5);
    }

    protected void hint(SystemHint hint) {
        this.emitInt(Instruction.HINT.encoding | hint.encoding << 5);
    }

    protected void clrex() {
        this.emitInt(Instruction.CLREX.encoding);
    }

    public void dmb(BarrierKind barrierKind) {
        this.emitInt(Instruction.DMB.encoding | 0xD503301F | barrierKind.encoding << 8);
    }

    public void dsb(BarrierKind barrierKind) {
        this.emitInt(Instruction.DSB.encoding | 0xD503301F | barrierKind.encoding << 8);
    }

    public void isb() {
        this.emitInt(Instruction.ISB.encoding | 0xD503301F | BarrierKind.SYSTEM.encoding << 8);
    }

    public void mrs(Register dst, SystemRegister systemRegister) {
        assert (Asserts.verifyRegistersR(dst));
        this.emitInt(Instruction.MRS.encoding | systemRegister.encoding() | AArch64Assembler.rt(dst));
    }

    public void msr(SystemRegister systemRegister, Register src) {
        assert (Asserts.verifyRegistersZ(src));
        this.emitInt(Instruction.MRS.encoding | systemRegister.encoding() | AArch64Assembler.rt(src));
    }

    public void dc(DataCacheOperationType type, Register src) {
        assert (Asserts.verifyRegistersR(src));
        this.emitInt(Instruction.DC.encoding | type.encoding() | AArch64Assembler.rt(src));
    }

    public void annotatePatchingImmediate(int pos, Instruction instruction, int operandSizeBits, int offsetBits, int shift) {
        if (this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new SingleInstructionAnnotation(pos, instruction, operandSizeBits, offsetBits, shift));
        }
    }

    public static class SingleInstructionAnnotation
    extends PatchableCodeAnnotation {
        public final int operandSizeBits;
        public final int offsetBits;
        public final Instruction instruction;
        public final int shift;

        SingleInstructionAnnotation(int instructionPosition, Instruction instruction, int operandSizeBits, int offsetBits, int shift) {
            super(instructionPosition);
            this.operandSizeBits = operandSizeBits;
            this.offsetBits = offsetBits;
            this.shift = shift;
            this.instruction = instruction;
        }

        public String toString() {
            return "SINGLE_INSTRUCTION";
        }

        @Override
        public void patch(long startAddress, int relative, byte[] code) {
            boolean expectedInstruction = this.instruction == Instruction.B || this.instruction == Instruction.BL;
            GraalError.guarantee(expectedInstruction, "trying to patch an unexpected instruction");
            int curValue = relative;
            assert ((curValue & (1 << this.shift) - 1) == 0) : "relative offset has incorrect alignment";
            GraalError.guarantee(NumUtil.isSignedNbit(this.operandSizeBits, curValue >>= this.shift), "value too large to fit into space");
            int bitsRemaining = this.operandSizeBits;
            int offsetRemaining = this.offsetBits;
            int[] bitsUsed = new int[4];
            int[] offsets = new int[4];
            for (int i = 0; i < 4; ++i) {
                int bits;
                if (offsetRemaining >= 8) {
                    offsetRemaining -= 8;
                    continue;
                }
                offsets[i] = offsetRemaining;
                bitsUsed[i] = bits = Math.min(8 - offsetRemaining, bitsRemaining);
                bitsRemaining -= bits;
                offsetRemaining = 0;
            }
            int originalInst = PatcherUtil.readInstruction(code, this.instructionPosition);
            int newInst = PatcherUtil.patchBitSequence(originalInst, curValue, bitsUsed, offsets);
            PatcherUtil.writeInstruction(code, this.instructionPosition, newInst);
        }
    }

    public static class PatcherUtil {
        public static int readInstruction(byte[] code, int pos) {
            return ByteBuffer.wrap(code, pos, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }

        public static void writeInstruction(byte[] code, int pos, int val) {
            ByteBuffer.wrap(code, pos, 4).order(ByteOrder.LITTLE_ENDIAN).putInt(val);
        }

        public static int patchBitSequence(int original, int value, int[] bitsUsed, int[] offsets) {
            assert (bitsUsed.length == 4 && offsets.length == 4) : "bitsUsed and offsets parameter should be of length 4";
            int result = 0;
            int curValue = value;
            for (int i = 0; i < bitsUsed.length; ++i) {
                int usedBits = bitsUsed[i];
                if (usedBits == 0) {
                    result |= original & 255 << 8 * i;
                }
                int offset = offsets[i];
                int mask = (1 << usedBits) - 1;
                byte patchTarget = (byte)(original >> 8 * i & 0xFF);
                byte patch = (byte)((curValue & mask) << offset & 0xFF);
                byte retainedPatchTarget = (byte)(patchTarget & (~(mask << offset) & 0xFF));
                int patchValue = (retainedPatchTarget | patch) & 0xFF;
                result |= patchValue << 8 * i;
                curValue >>= usedBits;
            }
            return result;
        }

        public static int patchAdrpHi21(int original, int imm21) {
            assert ((imm21 & 0x1FFFFF) == imm21);
            int immHi = imm21 >> 2 & 0x7FFFF;
            int immLo = imm21 & 3;
            int[] adrpBits = new int[]{3, 8, 8, 2};
            int[] adrpOffsets = new int[]{5, 0, 0, 5};
            int patch = immLo << 19 | immHi;
            return PatcherUtil.patchBitSequence(original, patch, adrpBits, adrpOffsets);
        }

        public static int patchAddLo12(int original, int imm12) {
            assert ((imm12 & 0xFFF) == imm12);
            int[] addBits = new int[]{0, 6, 6, 0};
            int[] addOffsets = new int[]{0, 2, 0, 0};
            return PatcherUtil.patchBitSequence(original, imm12, addBits, addOffsets);
        }

        public static int patchLdrLo12(int original, int imm12, int srcSize) {
            int shiftSize;
            assert ((imm12 & 0xFFF) == imm12);
            assert (srcSize == 64 || srcSize == 32 || srcSize == 16 || srcSize == 8);
            int n = srcSize == 64 ? 3 : (srcSize == 32 ? 2 : (shiftSize = srcSize == 16 ? 1 : 0));
            assert (shiftSize == 0 || (imm12 & (1 << shiftSize) - 1) == 0);
            int shiftedValue = (imm12 & 0xFFF) >> shiftSize;
            int[] ldrBits = new int[]{0, 6, 6, 0};
            int[] ldrOffsets = new int[]{0, 2, 0, 0};
            return PatcherUtil.patchBitSequence(original, shiftedValue, ldrBits, ldrOffsets);
        }

        public static int patchMov(int original, int imm16) {
            assert ((imm16 & 0xFFFF) == imm16);
            int[] movBits = new int[]{3, 8, 5, 0};
            int[] movOffsets = new int[]{5, 0, 0, 0};
            return PatcherUtil.patchBitSequence(original, imm16, movBits, movOffsets);
        }

        public static int computeRelativePageDifference(long target, long curPos, int pageSize) {
            int relative = (int)(target / (long)pageSize - curPos / (long)pageSize);
            return relative;
        }
    }

    public static abstract class PatchableCodeAnnotation
    extends Assembler.CodeAnnotation {
        public final int instructionPosition;

        PatchableCodeAnnotation(int instructionPosition) {
            this.instructionPosition = instructionPosition;
        }

        abstract void patch(long var1, int var3, byte[] var4);
    }

    public static enum BarrierKind {
        LOAD_ANY(9, "ISHLD"),
        STORE_STORE(10, "ISHST"),
        ANY_ANY(11, "ISH"),
        SYSTEM(15, "SYS");

        public final int encoding;
        public final String optionName;

        private BarrierKind(int encoding, String optionName) {
            this.encoding = encoding;
            this.optionName = optionName;
        }
    }

    public static enum SystemHint {
        NOP(0),
        YIELD(1),
        WFE(2),
        WFI(3),
        SEV(4),
        SEVL(5),
        CSDB(20);

        private final int encoding;

        private SystemHint(int encoding) {
            this.encoding = encoding;
        }
    }

    public static final class PrefetchMode
    extends Enum<PrefetchMode> {
        public static final /* enum */ PrefetchMode PLDL1KEEP = new PrefetchMode(0);
        public static final /* enum */ PrefetchMode PLDL1STRM = new PrefetchMode(1);
        public static final /* enum */ PrefetchMode PLDL2KEEP = new PrefetchMode(2);
        public static final /* enum */ PrefetchMode PLDL2STRM = new PrefetchMode(3);
        public static final /* enum */ PrefetchMode PLDL3KEEP = new PrefetchMode(4);
        public static final /* enum */ PrefetchMode PLDL3STRM = new PrefetchMode(5);
        public static final /* enum */ PrefetchMode PLIL1KEEP = new PrefetchMode(8);
        public static final /* enum */ PrefetchMode PLIL1STRM = new PrefetchMode(9);
        public static final /* enum */ PrefetchMode PLIL2KEEP = new PrefetchMode(10);
        public static final /* enum */ PrefetchMode PLIL2STRM = new PrefetchMode(11);
        public static final /* enum */ PrefetchMode PLIL3KEEP = new PrefetchMode(12);
        public static final /* enum */ PrefetchMode PLIL3STRM = new PrefetchMode(13);
        public static final /* enum */ PrefetchMode PSTL1KEEP = new PrefetchMode(16);
        public static final /* enum */ PrefetchMode PSTL1STRM = new PrefetchMode(17);
        public static final /* enum */ PrefetchMode PSTL2KEEP = new PrefetchMode(18);
        public static final /* enum */ PrefetchMode PSTL2STRM = new PrefetchMode(19);
        public static final /* enum */ PrefetchMode PSTL3KEEP = new PrefetchMode(20);
        public static final /* enum */ PrefetchMode PSTL3STRM = new PrefetchMode(21);
        private final int encoding;
        private static PrefetchMode[] modes;
        private static final /* synthetic */ PrefetchMode[] $VALUES;

        public static PrefetchMode[] values() {
            return (PrefetchMode[])$VALUES.clone();
        }

        public static PrefetchMode valueOf(String name) {
            return Enum.valueOf(PrefetchMode.class, name);
        }

        private PrefetchMode(int encoding) {
            this.encoding = encoding;
        }

        public static PrefetchMode lookup(int enc) {
            assert (enc >= 0 && enc < modes.length);
            return modes[enc];
        }

        public Register toRegister() {
            return AArch64.cpuRegisters.get(this.encoding);
        }

        static {
            $VALUES = new PrefetchMode[]{PLDL1KEEP, PLDL1STRM, PLDL2KEEP, PLDL2STRM, PLDL3KEEP, PLDL3STRM, PLIL1KEEP, PLIL1STRM, PLIL2KEEP, PLIL2STRM, PLIL3KEEP, PLIL3STRM, PSTL1KEEP, PSTL1STRM, PSTL2KEEP, PSTL2STRM, PSTL3KEEP, PSTL3STRM};
            modes = new PrefetchMode[]{PLDL1KEEP, PLDL1STRM, PLDL2KEEP, PLDL2STRM, PLDL3KEEP, PLDL3STRM, null, null, PLIL1KEEP, PLIL1STRM, PLIL2KEEP, PLIL2STRM, PLIL3KEEP, PLIL3STRM, null, null, PSTL1KEEP, PSTL1STRM, PSTL2KEEP, PSTL2STRM, PSTL3KEEP, PSTL3STRM};
        }
    }

    public static enum ConditionFlag {
        EQ(0),
        NE(1),
        HS(2),
        LO(3),
        MI(4),
        PL(5),
        VS(6),
        VC(7),
        HI(8),
        LS(9),
        GE(10),
        LT(11),
        GT(12),
        LE(13),
        AL(14),
        NV(15);

        public final int encoding;

        private ConditionFlag(int encoding) {
            this.encoding = encoding;
        }

        public static ConditionFlag fromEncoding(int encoding) {
            return ConditionFlag.values()[encoding];
        }

        public ConditionFlag negate() {
            switch (this) {
                case EQ: {
                    return NE;
                }
                case NE: {
                    return EQ;
                }
                case HS: {
                    return LO;
                }
                case LO: {
                    return HS;
                }
                case MI: {
                    return PL;
                }
                case PL: {
                    return MI;
                }
                case VS: {
                    return VC;
                }
                case VC: {
                    return VS;
                }
                case HI: {
                    return LS;
                }
                case LS: {
                    return HI;
                }
                case GE: {
                    return LT;
                }
                case LT: {
                    return GE;
                }
                case GT: {
                    return LE;
                }
                case LE: {
                    return GT;
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }

    public static enum ExtendType {
        UXTB(0),
        UXTH(1),
        UXTW(2),
        UXTX(3),
        SXTB(4),
        SXTH(5),
        SXTW(6),
        SXTX(7);

        public final int encoding;

        private ExtendType(int encoding) {
            this.encoding = encoding;
        }
    }

    public static enum ShiftType {
        LSL(0),
        LSR(1),
        ASR(2),
        ROR(3);

        public final int encoding;

        private ShiftType(int encoding) {
            this.encoding = encoding;
        }
    }

    public static enum DataCacheOperationType {
        ZVA(3, 4, 1),
        CVAP(3, 12, 1);

        private final int op1;
        private final int crm;
        private final int op2;

        private DataCacheOperationType(int op1, int crm, int op2) {
            this.op1 = op1;
            this.crm = crm;
            this.op2 = op2;
        }

        public int encoding() {
            return this.op1 << 16 | this.crm << 8 | this.op2 << 5;
        }
    }

    public static enum SystemRegister {
        FPCR(3, 3, 4, 4, 0),
        FPSR(3, 3, 4, 4, 1),
        CNTVCT_EL0(3, 3, 6, 0, 2);

        private final int op0;
        private final int op1;
        private final int crn;
        private final int crm;
        private final int op2;

        private SystemRegister(int op0, int op1, int crn, int crm, int op2) {
            this.op0 = op0;
            this.op1 = op1;
            this.crn = crn;
            this.crm = crm;
            this.op2 = op2;
        }

        public int encoding() {
            return this.op0 << 19 | this.op1 << 16 | this.crn << 12 | this.crm << 8 | this.op2 << 5;
        }
    }

    public static enum Instruction {
        BCOND(0x54000000),
        CBNZ(0x1000000),
        CBZ(0),
        TBZ(0x36000000),
        TBNZ(0x37000000),
        B(0),
        BL(Integer.MIN_VALUE),
        BR(0x1F0000),
        BLR(0x3F0000),
        RET(0x5F0000),
        LDR(0),
        LDRS(0x800000),
        LDXR(140475392),
        LDAR(148896768),
        LDAXR(140508160),
        STR(0),
        STXR(134249472),
        STLR(144702464),
        STLXR(134282240),
        LDP(0x400000),
        STP(0),
        CAS(144735232),
        LDADD(941621248),
        SWP(941654016),
        ADR(0),
        ADRP(Integer.MIN_VALUE),
        ADD(0),
        ADDS(Instruction.ADD.encoding | 0x20000000),
        SUB(0x40000000),
        SUBS(Instruction.SUB.encoding | 0x20000000),
        CCMP(2051014656),
        NOT(0x200000),
        AND(0),
        BIC(Instruction.AND.encoding | Instruction.NOT.encoding),
        ORR(0x20000000),
        ORN(Instruction.ORR.encoding | Instruction.NOT.encoding),
        EOR(0x40000000),
        EON(Instruction.EOR.encoding | Instruction.NOT.encoding),
        ANDS(0x60000000),
        BICS(Instruction.ANDS.encoding | Instruction.NOT.encoding),
        ASRV(10240),
        RORV(11264),
        LSRV(9216),
        LSLV(8192),
        CLS(5120),
        CLZ(4096),
        RBIT(0),
        REVX(3072),
        REVW(2048),
        MOVN(0),
        MOVZ(0x40000000),
        MOVK(0x60000000),
        CSEL(0),
        CSNEG(0x40000400),
        CSINC(1024),
        BFM(0x20000000),
        SBFM(0),
        UBFM(0x40000000),
        EXTR(327155712),
        MADD(0),
        MSUB(32768),
        SDIV(3072),
        UDIV(2048),
        FMOV(0),
        FMOVCPU2FPU(458752),
        FMOVFPU2CPU(393216),
        FCVTDS(163840),
        FCVTSD(131072),
        FCVTZS(0x180000),
        SCVTF(131072),
        FABS(32768),
        FSQRT(98304),
        FNEG(65536),
        FRINTM(327680),
        FRINTN(262144),
        FRINTP(294912),
        FRINTZ(360448),
        FADD(8192),
        FSUB(12288),
        FMUL(0),
        FDIV(4096),
        FMAX(16384),
        FMIN(20480),
        FMADD(0),
        FMSUB(32768),
        FCMP(0),
        FCMPZERO(8),
        FCCMP(505414656),
        FCSEL(505416704),
        HLT(0x400000),
        BRK(0x200000),
        CLREX(-721207457),
        HINT(-721215457),
        DMB(160),
        DSB(128),
        MRS(-718274560),
        MSR(-720371712),
        DC(-720867328),
        ISB(192),
        BLR_NATIVE(-1073741824);

        public final int encoding;

        private Instruction(int encoding) {
            this.encoding = encoding;
        }
    }

    protected static final class InstructionType
    extends Enum<InstructionType> {
        public static final /* enum */ InstructionType General32 = new InstructionType(0, 32, true);
        public static final /* enum */ InstructionType General64 = new InstructionType(Integer.MIN_VALUE, 64, true);
        public static final /* enum */ InstructionType FP32 = new InstructionType(0, 32, false);
        public static final /* enum */ InstructionType FP64 = new InstructionType(0x400000, 64, false);
        public final int encoding;
        public final int width;
        public final boolean isGeneral;
        private static final /* synthetic */ InstructionType[] $VALUES;

        public static InstructionType[] values() {
            return (InstructionType[])$VALUES.clone();
        }

        public static InstructionType valueOf(String name) {
            return Enum.valueOf(InstructionType.class, name);
        }

        private InstructionType(int encoding, int width, boolean isGeneral) {
            this.encoding = encoding;
            this.width = width;
            this.isGeneral = isGeneral;
        }

        public static InstructionType generalFromSize(int size) {
            assert (size == 32 || size == 64);
            return size == 32 ? General32 : General64;
        }

        public static InstructionType floatFromSize(int size) {
            assert (size == 32 || size == 64);
            return size == 32 ? FP32 : FP64;
        }

        static {
            $VALUES = new InstructionType[]{General32, General64, FP32, FP64};
        }
    }

    static class Asserts {
        Asserts() {
        }

        static boolean checkSize32Or64(int size) {
            assert (size == 32 || size == 64) : String.format("Expected size 32 or 64: %s", size);
            return true;
        }

        static boolean checkRegR(Register reg) {
            assert (reg != null) : "Register is null";
            assert (reg.getRegisterCategory().equals((Object)AArch64.CPU)) : String.format("General-purpose register expected: %s", reg);
            assert (!reg.equals((Object)AArch64.zr)) : "Unexpected zero register (zr) found";
            assert (!reg.equals((Object)AArch64.sp)) : "Unexpected stack pointer register (sp) found";
            return true;
        }

        static boolean checkRegZ(Register reg) {
            assert (reg != null) : "Register is null";
            assert (reg.getRegisterCategory().equals((Object)AArch64.CPU)) : String.format("General-purpose register expected: %s", reg);
            assert (!reg.equals((Object)AArch64.sp)) : "Unexpected stack pointer register (sp) found";
            return true;
        }

        static boolean checkRegP(Register reg) {
            assert (reg != null) : "Register is null";
            assert (reg.getRegisterCategory().equals((Object)AArch64.CPU)) : String.format("General-purpose register expected: %s", reg);
            assert (!reg.equals((Object)AArch64.zr)) : "Unexpected zero register (zr) found";
            return true;
        }

        static boolean checkRegF(Register reg) {
            assert (reg != null) : "Register is null";
            assert (reg.getRegisterCategory().equals((Object)AArch64.SIMD)) : String.format("Floating-point register expected: %s", reg);
            return true;
        }

        static boolean verifyRegistersR(Register reg) {
            assert (Asserts.checkRegR(reg));
            return true;
        }

        static boolean verifySizeAndRegistersR(int size, Register reg) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersR(reg));
            return true;
        }

        static boolean verifyRegistersZ(Register reg) {
            assert (Asserts.checkRegZ(reg));
            return true;
        }

        static boolean verifyRegistersF(Register reg) {
            assert (Asserts.checkRegF(reg));
            return true;
        }

        static boolean verifySizeAndRegistersF(int size, Register reg) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersF(reg));
            return true;
        }

        static boolean verifyRegistersRR(Register reg1, Register reg2) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegR(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersRR(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersRR(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersRP(Register reg1, Register reg2) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegP(reg2));
            return true;
        }

        static boolean verifyRegistersRF(Register reg1, Register reg2) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegF(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersRF(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersRF(reg1, reg2));
            return true;
        }

        static boolean verifySizesAndRegistersRF(int size1, int size2, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size1));
            assert (Asserts.checkSize32Or64(size2));
            assert (Asserts.verifyRegistersRF(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersZZ(Register reg1, Register reg2) {
            assert (Asserts.checkRegZ(reg1));
            assert (Asserts.checkRegZ(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersZZ(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersZZ(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersZP(Register reg1, Register reg2) {
            assert (Asserts.checkRegZ(reg1));
            assert (Asserts.checkRegP(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersZP(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersZP(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersPR(Register reg1, Register reg2) {
            assert (Asserts.checkRegP(reg1));
            assert (Asserts.checkRegR(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersPR(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersPR(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersPZ(Register reg1, Register reg2) {
            assert (Asserts.checkRegP(reg1));
            assert (Asserts.checkRegZ(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersPZ(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersPZ(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersPP(Register reg1, Register reg2) {
            assert (Asserts.checkRegP(reg1));
            assert (Asserts.checkRegP(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersPP(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersPP(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersFZ(Register reg1, Register reg2) {
            assert (Asserts.checkRegF(reg1));
            assert (Asserts.checkRegZ(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersFZ(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersFZ(reg1, reg2));
            return true;
        }

        static boolean verifySizesAndRegistersFZ(int size1, int size2, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size1));
            assert (Asserts.checkSize32Or64(size2));
            assert (Asserts.verifyRegistersFZ(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersFF(Register reg1, Register reg2) {
            assert (Asserts.checkRegF(reg1));
            assert (Asserts.checkRegF(reg2));
            return true;
        }

        static boolean verifySizeAndRegistersFF(int size, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersFF(reg1, reg2));
            return true;
        }

        static boolean verifySizesAndRegistersFF(int size1, int size2, Register reg1, Register reg2) {
            assert (Asserts.checkSize32Or64(size1));
            assert (Asserts.checkSize32Or64(size2));
            assert (Asserts.verifyRegistersFF(reg1, reg2));
            return true;
        }

        static boolean verifyRegistersRRR(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegR(reg2));
            assert (Asserts.checkRegR(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersRRR(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersRRR(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersRZR(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegZ(reg2));
            assert (Asserts.checkRegR(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersRZR(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersRZR(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersRZZ(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegZ(reg2));
            assert (Asserts.checkRegZ(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersRZZ(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersRZZ(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersRZP(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegZ(reg2));
            assert (Asserts.checkRegP(reg3));
            return true;
        }

        static boolean verifyRegistersZRP(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegZ(reg1));
            assert (Asserts.checkRegR(reg2));
            assert (Asserts.checkRegP(reg3));
            return true;
        }

        static boolean verifyRegistersZZZ(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegZ(reg1));
            assert (Asserts.checkRegZ(reg2));
            assert (Asserts.checkRegZ(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersZZZ(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersZZZ(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersZPZ(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegZ(reg1));
            assert (Asserts.checkRegP(reg2));
            assert (Asserts.checkRegZ(reg3));
            return true;
        }

        static boolean verifySizeRegistersZPZ(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersZPZ(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersPPZ(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegP(reg1));
            assert (Asserts.checkRegP(reg2));
            assert (Asserts.checkRegZ(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersPPZ(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersPPZ(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersFFF(Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkRegF(reg1));
            assert (Asserts.checkRegF(reg2));
            assert (Asserts.checkRegF(reg3));
            return true;
        }

        static boolean verifySizeAndRegistersFFF(int size, Register reg1, Register reg2, Register reg3) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersFFF(reg1, reg2, reg3));
            return true;
        }

        static boolean verifyRegistersRRRZ(Register reg1, Register reg2, Register reg3, Register reg4) {
            assert (Asserts.checkRegR(reg1));
            assert (Asserts.checkRegR(reg2));
            assert (Asserts.checkRegR(reg3));
            assert (Asserts.checkRegZ(reg4));
            return true;
        }

        static boolean verifyRegistersFFFF(Register reg1, Register reg2, Register reg3, Register reg4) {
            assert (Asserts.checkRegF(reg1));
            assert (Asserts.checkRegF(reg2));
            assert (Asserts.checkRegF(reg3));
            assert (Asserts.checkRegF(reg4));
            return true;
        }

        static boolean verifySizeAndRegistersFFFF(int size, Register reg1, Register reg2, Register reg3, Register reg4) {
            assert (Asserts.checkSize32Or64(size));
            assert (Asserts.verifyRegistersFFFF(reg1, reg2, reg3, reg4));
            return true;
        }
    }

    public static class LogicalBitmaskImmediateEncoding {
        private static final Immediate[] IMMEDIATE_TABLE = LogicalBitmaskImmediateEncoding.buildImmediateTable();
        private static final int ImmediateOffset = 10;
        private static final int ImmediateRotateOffset = 16;
        private static final int ImmediateSizeOffset = 22;

        protected static boolean canEncode(boolean is64bit, long immediate) {
            assert (is64bit || NumUtil.isUnsignedNbit(32, immediate));
            int pos = LogicalBitmaskImmediateEncoding.getImmediateTablePosition(is64bit, immediate);
            return pos >= 0;
        }

        public static int getEncoding(boolean is64bit, long value) {
            assert (is64bit || NumUtil.isUnsignedNbit(32, value));
            int pos = LogicalBitmaskImmediateEncoding.getImmediateTablePosition(is64bit, value);
            assert (pos >= 0) : "Value cannot be represented as logical immediate: " + value + ", is64bit=" + is64bit;
            Immediate imm = IMMEDIATE_TABLE[pos];
            assert (is64bit || !imm.only64Bit()) : "Immediate can only be represented for 64bit, but 32bit instruction specified";
            return LogicalBitmaskImmediateEncoding.IMMEDIATE_TABLE[pos].encoding;
        }

        private static int getImmediateTablePosition(boolean is64bit, long value) {
            assert (is64bit || NumUtil.isUnsignedNbit(32, value));
            Immediate imm = !is64bit ? new Immediate(value << 32 | value) : new Immediate(value);
            int pos = Arrays.binarySearch(IMMEDIATE_TABLE, imm);
            if (pos < 0) {
                return -1;
            }
            if (!is64bit && IMMEDIATE_TABLE[pos].only64Bit()) {
                return -1;
            }
            return pos;
        }

        private static Immediate[] buildImmediateTable() {
            int nrImmediates = 5334;
            int[] elementSizeEncodings = new int[]{60, 56, 48, 32, 0, 0};
            Object[] table = new Immediate[5334];
            int nrImms = 0;
            for (int logE = 1; logE <= 6; ++logE) {
                int e = 1 << logE;
                long mask = NumUtil.getNbitNumberLong(e);
                for (int nrOnes = 1; nrOnes < e; ++nrOnes) {
                    long val = (1L << nrOnes) - 1L;
                    for (int r = 0; r < e; ++r) {
                        long immediate = (val >>> r | val << e - r) & mask;
                        switch (logE) {
                            case 1: {
                                immediate |= immediate << 2;
                                immediate |= immediate << 4;
                                immediate |= immediate << 8;
                                immediate |= immediate << 16;
                                immediate |= immediate << 32;
                                break;
                            }
                            case 2: {
                                immediate |= immediate << 4;
                                immediate |= immediate << 8;
                                immediate |= immediate << 16;
                                immediate |= immediate << 32;
                                break;
                            }
                            case 3: {
                                immediate |= immediate << 8;
                                immediate |= immediate << 16;
                                immediate |= immediate << 32;
                                break;
                            }
                            case 4: {
                                immediate |= immediate << 16;
                                immediate |= immediate << 32;
                                break;
                            }
                            case 5: {
                                immediate |= immediate << 32;
                                break;
                            }
                        }
                        int s = elementSizeEncodings[logE - 1] | nrOnes - 1;
                        table[nrImms++] = new Immediate(immediate, e == 64, s, r);
                    }
                }
            }
            Arrays.sort(table);
            assert (nrImms == 5334) : nrImms + " instead of 5334 in table.";
            assert (LogicalBitmaskImmediateEncoding.checkDuplicates((Immediate[])table)) : "Duplicate values in table.";
            return table;
        }

        private static boolean checkDuplicates(Immediate[] table) {
            for (int i = 0; i < table.length - 1; ++i) {
                if (table[i].imm < table[i + 1].imm) continue;
                return false;
            }
            return true;
        }

        private static final class Immediate
        implements Comparable<Immediate> {
            public final long imm;
            public final boolean isOnly64Bit;
            public final int encoding;

            Immediate(long imm, boolean isOnly64Bit, int s, int r) {
                this.imm = imm;
                this.isOnly64Bit = isOnly64Bit;
                this.encoding = Immediate.computeEncoding(isOnly64Bit, s, r);
            }

            Immediate(long imm) {
                this(imm, false, 0, 0);
            }

            public boolean only64Bit() {
                return this.isOnly64Bit;
            }

            private static int computeEncoding(boolean is64, int s, int r) {
                int sf = is64 ? 1 : 0;
                return sf << 22 | r << 16 | s << 10;
            }

            @Override
            public int compareTo(Immediate o) {
                return Long.compare(this.imm, o.imm);
            }
        }
    }
}

