/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.debug.GraalError;

public final class AMD64Address
extends AbstractAddress {
    private final Register base;
    private final Register index;
    private final Scale scale;
    private final int displacement;
    private final Object displacementAnnotation;
    final int instructionStartPosition;

    public AMD64Address(Register base) {
        this(base, Register.None, Scale.Times1, 0);
    }

    public AMD64Address(Register base, int displacement) {
        this(base, Register.None, Scale.Times1, displacement);
    }

    public AMD64Address(Register base, Register index, Scale scale) {
        this(base, index, scale, 0, null, -1);
    }

    public AMD64Address(Register base, Register index, Scale scale, int displacement) {
        this(base, index, scale, displacement, null, -1);
    }

    public AMD64Address(Register base, Register index, Scale scale, int displacement, Object displacementAnnotation) {
        this(base, index, scale, displacement, displacementAnnotation, -1);
    }

    AMD64Address(Register base, Register index, Scale scale, int displacement, Object displacementAnnotation, int instructionStartPosition) {
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.displacementAnnotation = displacementAnnotation;
        this.instructionStartPosition = instructionStartPosition;
        assert (scale != null);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        String sep = "";
        if (!this.getBase().equals((Object)Register.None)) {
            s.append(this.getBase());
            sep = " + ";
        }
        if (!this.getIndex().equals((Object)Register.None)) {
            s.append(sep).append(this.getIndex()).append(" * ").append(this.getScale().value);
            sep = " + ";
        }
        if (this.getDisplacement() < 0) {
            s.append(" - ").append(-this.getDisplacement());
        } else if (this.getDisplacement() > 0) {
            s.append(sep).append(this.getDisplacement());
        }
        if (this.displacementAnnotation != null) {
            s.append(" + ").append(this.displacementAnnotation);
        }
        s.append("]");
        return s.toString();
    }

    public Register getBase() {
        return this.base;
    }

    public Register getIndex() {
        return this.index;
    }

    public Scale getScale() {
        return this.scale;
    }

    public int getDisplacement() {
        return this.displacement;
    }

    public Object getDisplacementAnnotation() {
        return this.displacementAnnotation;
    }

    boolean isPlaceholder() {
        return this.instructionStartPosition >= 0;
    }

    public static enum Scale {
        Times1(1, 0),
        Times2(2, 1),
        Times4(4, 2),
        Times8(8, 3);

        public final int value;
        public final int log2;

        private Scale(int value, int log2) {
            this.value = value;
            this.log2 = log2;
        }

        public static Scale fromInt(int scale) {
            switch (scale) {
                case 1: {
                    return Times1;
                }
                case 2: {
                    return Times2;
                }
                case 4: {
                    return Times4;
                }
                case 8: {
                    return Times8;
                }
            }
            throw new IllegalArgumentException("Unsupported SIB addressing mode scaling factor: " + scale);
        }

        public static Scale fromShift(int shift) {
            switch (shift) {
                case 0: {
                    return Times1;
                }
                case 1: {
                    return Times2;
                }
                case 2: {
                    return Times4;
                }
                case 3: {
                    return Times8;
                }
            }
            throw GraalError.shouldNotReachHere("Unsupported SIB addressing mode scaling factor: " + (1 << shift));
        }

        public static boolean isScaleSupported(int scale) {
            return CodeUtil.isPowerOf2((int)scale) && scale <= 8;
        }

        public static boolean isScaleShiftSupported(int shift) {
            return shift >= 0 && shift <= 3;
        }
    }
}

