/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.replacements.nodes.BitScanForwardNode;
import org.graalvm.compiler.replacements.nodes.BitScanReverseNode;
import org.graalvm.compiler.replacements.nodes.CountLeadingZerosNode;
import org.graalvm.compiler.replacements.nodes.CountTrailingZerosNode;

public interface AMD64LoweringProviderMixin
extends LoweringProvider {
    @Override
    default public boolean divisionOverflowIsJVMSCompliant() {
        return false;
    }

    @Override
    default public Integer smallestCompareWidth() {
        return 8;
    }

    @Override
    default public boolean supportsBulkZeroing() {
        return true;
    }

    @Override
    default public boolean writesStronglyOrdered() {
        return true;
    }

    default public boolean lowerAMD64(Node n) {
        UnaryNode count;
        AMD64 arch;
        if (n instanceof CountLeadingZerosNode) {
            arch = (AMD64)this.getTarget().arch;
            count = (CountLeadingZerosNode)n;
            if (!arch.getFeatures().contains(AMD64.CPUFeature.LZCNT) || !arch.getFlags().contains(AMD64.Flag.UseCountLeadingZerosInstruction)) {
                StructuredGraph graph = count.graph();
                JavaKind kind = count.getValue().getStackKind();
                ConstantNode zero = ConstantNode.forIntegerKind(kind, 0L, graph);
                LogicNode compare = IntegerEqualsNode.create(count.getValue(), zero, NodeView.DEFAULT);
                SubNode result = new SubNode(ConstantNode.forIntegerKind(JavaKind.Int, kind.getBitCount() - 1), new BitScanReverseNode(count.getValue()));
                ValueNode conditional = ConditionalNode.create(compare, ConstantNode.forInt(kind.getBitCount()), result, NodeView.DEFAULT);
                conditional = graph.addOrUniqueWithInputs(conditional);
                count.replaceAndDelete(conditional);
                return true;
            }
        }
        if (n instanceof CountTrailingZerosNode) {
            arch = (AMD64)this.getTarget().arch;
            count = (CountTrailingZerosNode)n;
            if (!arch.getFeatures().contains(AMD64.CPUFeature.BMI1) || !arch.getFlags().contains(AMD64.Flag.UseCountTrailingZerosInstruction)) {
                StructuredGraph graph = count.graph();
                JavaKind kind = count.getValue().getStackKind();
                ConstantNode zero = ConstantNode.forIntegerKind(kind, 0L, graph);
                LogicNode compare = IntegerEqualsNode.create(count.getValue(), zero, NodeView.DEFAULT);
                ValueNode conditional = ConditionalNode.create(compare, ConstantNode.forInt(kind.getBitCount()), new BitScanForwardNode(count.getValue()), NodeView.DEFAULT);
                conditional = graph.addOrUniqueWithInputs(conditional);
                count.replaceAndDelete(conditional);
                return true;
            }
        }
        return false;
    }
}

