/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractDeoptimizeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.DynamicDeoptimizeNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.MultiGuardNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.UseTrappingOperationPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.phases.tiers.LowTierContext;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class UseTrappingDivPhase
extends BasePhase<LowTierContext> {
    private static boolean conditionIsZeroCheck(LogicNode condition, ValueNode divisor) {
        if (condition instanceof IntegerEqualsNode) {
            IntegerEqualsNode eq = (IntegerEqualsNode)condition;
            return eq.getX() == divisor && eq.getY().isConstant() && eq.getY().asJavaConstant().asLong() == 0L;
        }
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        if (!GraalOptions.FloatingDivNodes.getValue(graph.getOptions()).booleanValue()) {
            return;
        }
        if (!GraalServices.supportsArbitraryImplicitException()) {
            return;
        }
        EconomicMap trappingReplaceTargets = null;
        StructuredGraph.ScheduleResult sched = null;
        for (IntegerDivRemNode divRem : graph.getNodes(IntegerDivRemNode.TYPE)) {
            IfNode ifNode;
            BeginNode divGuard;
            if (!(divRem instanceof SignedDivNode) && !(divRem instanceof SignedRemNode)) continue;
            ValueNode divisor = divRem.getY();
            ValueNode dividend = divRem.getX();
            if (divRem.getZeroGuard() instanceof MultiGuardNode || !(divRem.getZeroGuard() instanceof BeginNode) || !((divGuard = (BeginNode)divRem.getZeroGuard()).predecessor() instanceof IfNode) || (ifNode = (IfNode)divGuard.predecessor()).falseSuccessor() != divGuard || !UseTrappingDivPhase.conditionIsZeroCheck(ifNode.condition(), divisor) || !ifNode.condition().hasExactlyOneUsage()) continue;
            if (trappingReplaceTargets == null) {
                trappingReplaceTargets = EconomicMap.create();
                SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.EARLIEST);
                sched = graph.getLastSchedule();
            }
            Block ifBlock = sched.getNodeToBlockMap().get(ifNode);
            Block dividendBlock = sched.getNodeToBlockMap().get(dividend);
            if (dividendBlock == null) {
                assert (dividend instanceof PhiNode);
                dividendBlock = sched.getNodeToBlockMap().get(((PhiNode)dividend).merge());
            }
            if (!AbstractControlFlowGraph.dominates(dividendBlock, ifBlock)) continue;
            trappingReplaceTargets.put((Object)((IntegerEqualsNode)ifNode.condition()), (Object)divRem);
        }
        if (trappingReplaceTargets != null) {
            new Instance(trappingReplaceTargets).run(graph, context);
        }
    }

    static class Instance
    extends UseTrappingOperationPhase {
        final EconomicMap<IntegerEqualsNode, IntegerDivRemNode> trappingReplaceTargets;

        Instance(EconomicMap<IntegerEqualsNode, IntegerDivRemNode> trappingReplaceTargets) {
            this.trappingReplaceTargets = trappingReplaceTargets;
        }

        @Override
        public boolean isSupportedReason(DeoptimizationReason reason) {
            return reason == DeoptimizationReason.ArithmeticException;
        }

        @Override
        public boolean canReplaceCondition(LogicNode condition, IfNode ifNode) {
            if (condition instanceof IntegerEqualsNode) {
                return this.trappingReplaceTargets.containsKey((Object)((IntegerEqualsNode)condition));
            }
            return false;
        }

        @Override
        public boolean useAddressOptimization(AddressNode adr, LowTierContext context) {
            return false;
        }

        @Override
        public DeoptimizingFixedWithNextNode tryReplaceExisting(StructuredGraph graph, AbstractBeginNode nonTrappingContinuation, AbstractBeginNode trappingContinuation, LogicNode condition, IfNode ifNode, AbstractDeoptimizeNode deopt, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation, LowTierContext context) {
            return null;
        }

        @Override
        public DeoptimizingFixedWithNextNode createImplicitNode(StructuredGraph graph, LogicNode condition, JavaConstant deoptReasonAndAction, JavaConstant deoptSpeculation) {
            assert (condition instanceof IntegerEqualsNode);
            IntegerEqualsNode ieq = (IntegerEqualsNode)condition;
            IntegerDivRemNode divRem = (IntegerDivRemNode)this.trappingReplaceTargets.get((Object)ieq);
            ValueNode dividend = divRem.getX();
            ValueNode divisor = divRem.getY();
            IntegerDivRemNode divRemFixed = null;
            if (divRem instanceof SignedDivNode) {
                divRemFixed = graph.add(new SignedDivNode(dividend, divisor, null));
            } else if (divRem instanceof SignedRemNode) {
                divRemFixed = graph.add(new SignedRemNode(dividend, divisor, null));
            }
            divRemFixed.setImplicitDeoptimization(deoptReasonAndAction, deoptSpeculation);
            GraalError.guarantee(divRemFixed.canDeoptimize(), "Fixed representation must deopt since we replaced a 0 check");
            return divRemFixed;
        }

        @Override
        public boolean trueSuccessorIsDeopt() {
            return true;
        }

        @Override
        public void finalAction(DeoptimizingFixedWithNextNode trappingVersionNode, LogicNode condition) {
            assert (trappingVersionNode instanceof IntegerDivRemNode);
            IntegerDivRemNode fixedNonTrappingVersion = (IntegerDivRemNode)this.trappingReplaceTargets.get((Object)((IntegerEqualsNode)condition));
            fixedNonTrappingVersion.replaceAtUsages(trappingVersionNode);
            GraphUtil.unlinkFixedNode(fixedNonTrappingVersion);
            fixedNonTrappingVersion.safeDelete();
        }

        @Override
        public void actionBeforeGuardRewrite(DeoptimizingFixedWithNextNode trappingVersionNode) {
        }

        @Override
        protected void run(StructuredGraph graph, LowTierContext context) {
            MetaAccessProvider metaAccessProvider = context.getMetaAccess();
            for (DeoptimizeNode deoptimizeNode : graph.getNodes(DeoptimizeNode.TYPE)) {
                this.tryUseTrappingVersion(deoptimizeNode, deoptimizeNode.predecessor(), deoptimizeNode.getReason(), deoptimizeNode.getSpeculation(), deoptimizeNode.getActionAndReason(metaAccessProvider).asJavaConstant(), deoptimizeNode.getSpeculation(metaAccessProvider).asJavaConstant(), context);
            }
            for (DynamicDeoptimizeNode dynamicDeoptimizeNode : graph.getNodes(DynamicDeoptimizeNode.TYPE)) {
                this.tryUseTrappingVersion(metaAccessProvider, dynamicDeoptimizeNode, context);
            }
        }
    }
}

