/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.GraalError;

public final class StrideUtil {
    public static final int N_STRIDES = 3;
    public static final JavaKind S1 = JavaKind.Byte;
    public static final JavaKind S2 = JavaKind.Char;
    public static final JavaKind S4 = JavaKind.Int;
    public static final JavaKind NONE = JavaKind.Void;

    public static JavaKind getConstantStrideA(int directStubCallIndex) {
        return StrideUtil.log2ToStride(directStubCallIndex / 3);
    }

    public static JavaKind getConstantStrideB(int directStubCallIndex) {
        return StrideUtil.log2ToStride(directStubCallIndex % 3);
    }

    public static int getDirectStubCallIndex(int log2StrideA, int log2StrideB) {
        assert (0 <= log2StrideA && log2StrideA < 3) : log2StrideA;
        assert (0 <= log2StrideB && log2StrideB < 3) : log2StrideB;
        return log2StrideA * 3 + log2StrideB;
    }

    public static int log2(JavaKind stride) {
        return CodeUtil.log2((int)stride.getByteCount());
    }

    public static JavaKind log2ToStride(int log2Stride) {
        switch (log2Stride) {
            case 0: {
                return S1;
            }
            case 1: {
                return S2;
            }
            case 2: {
                return S4;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean useConstantStrides(Value dynamicStride) {
        return ValueUtil.isIllegal((Value)dynamicStride);
    }
}

