/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;

public abstract class Loop<T extends AbstractBlockBase<T>> {
    private final Loop<T> parent;
    private final ArrayList<Loop<T>> children;
    private final int depth;
    private final int index;
    private final T header;
    private final ArrayList<T> blocks;
    private final ArrayList<T> exits;
    private final ArrayList<T> naturalExits;
    private boolean inverted = true;

    protected Loop(Loop<T> parent, int index, T header) {
        this.parent = parent;
        this.depth = parent != null ? parent.getDepth() + 1 : 1;
        this.index = index;
        this.header = header;
        this.blocks = new ArrayList();
        this.children = new ArrayList();
        this.exits = new ArrayList();
        this.naturalExits = new ArrayList();
    }

    public abstract long numBackedges();

    public String toString() {
        return "loop " + this.index + " depth " + this.getDepth() + (String)(this.parent != null ? " outer " + this.parent.index : "");
    }

    public Loop<T> getParent() {
        return this.parent;
    }

    public List<Loop<T>> getChildren() {
        return this.children;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getIndex() {
        return this.index;
    }

    public T getHeader() {
        return this.header;
    }

    public List<T> getBlocks() {
        return this.blocks;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean isAncestorOrSelf(Loop<?> potentialAncestor) {
        for (Loop<T> p = this; p != null; p = p.getParent()) {
            if (p != potentialAncestor) continue;
            return true;
        }
        return false;
    }

    public List<T> getLoopExits() {
        return this.exits;
    }

    public boolean isLoopExit(T block) {
        assert (Loop.isSorted(this.exits));
        return Collections.binarySearch(this.exits, block, AbstractBlockBase.BLOCK_ID_COMPARATOR) >= 0;
    }

    public ArrayList<T> getNaturalExits() {
        return this.naturalExits;
    }

    public boolean isNaturalExit(T block) {
        assert (Loop.isSorted(this.naturalExits));
        return Collections.binarySearch(this.naturalExits, block, AbstractBlockBase.BLOCK_ID_COMPARATOR) >= 0;
    }

    private static <T extends AbstractBlockBase<T>> boolean isSorted(List<T> list) {
        int lastId = Integer.MIN_VALUE;
        for (AbstractBlockBase block : list) {
            if (block.getId() < lastId) {
                return false;
            }
            lastId = block.getId();
        }
        return true;
    }

    public int hashCode() {
        return this.index + this.depth * 31;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

