/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface PhasePlan<T> {
    public List<T> getPhases();

    default public String getPhaseName(T phase) {
        return phase.getClass().getName();
    }

    public static final class Printer {
        private static final String CONNECTING_INDENT = "\u2502   ";
        private static final String EMPTY_INDENT = "    ";
        private static final String CHILD = "\u251c\u2500\u2500 ";
        private static final String LAST_CHILD = "\u2514\u2500\u2500 ";
        final Map<String, String> abbreviations = new HashMap<String, String>();

        public <T> Formatter printTo(PhasePlan<T> plan, Formatter buf) {
            return this.printPlan(CHILD, LAST_CHILD, plan, buf);
        }

        public <T> String toString(PhasePlan<T> plan) {
            return this.printPlan(CHILD, LAST_CHILD, plan, new Formatter()).toString();
        }

        private <T> Formatter printPlan(String indent, String indentLast, PhasePlan<T> plan, Formatter buf) {
            Iterator<T> iter = plan.getPhases().iterator();
            while (iter.hasNext()) {
                T phase = iter.next();
                String className = plan.getPhaseName(phase);
                boolean hasNext = iter.hasNext();
                buf.format("%s%s%n", hasNext ? indent : indentLast, this.abbreviate(className));
                if (!(phase instanceof PhasePlan)) continue;
                PhasePlan subPlan = (PhasePlan)phase;
                String prefix = hasNext ? CONNECTING_INDENT : EMPTY_INDENT;
                this.printPlan(prefix + indent, prefix + indentLast, subPlan, buf);
            }
            return buf;
        }

        private static int firstCapitalAfterPeriod(String s) {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i - 1) != '.' || !Character.isUpperCase(s.charAt(i))) continue;
                return i;
            }
            return 0;
        }

        private String abbreviate(String className) {
            Object abbreviation = this.abbreviations.get(className);
            if (abbreviation == null) {
                int simpleClassNameStart = Printer.firstCapitalAfterPeriod(className);
                String simpleClassName = className.substring(simpleClassNameStart);
                String packageName = simpleClassNameStart != 0 ? className.substring(0, simpleClassNameStart - 1) : "";
                abbreviation = this.abbreviations.values().contains(simpleClassName) ? simpleClassName + " [" + packageName + "]" : simpleClassName;
                this.abbreviations.put(className, (String)abbreviation);
            }
            return abbreviation;
        }
    }
}

