/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.core.gen.InstructionPrinter;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchValue;
import org.graalvm.compiler.core.match.MatchPattern;
import org.graalvm.compiler.core.match.MatchRuleRegistry;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.lir.FullInfopointOp;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.debug.LIRGenerationDebugContext;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.ImplicitNullCheckNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;
import org.graalvm.compiler.nodes.calc.IntegerTestNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public abstract class NodeLIRBuilder
implements NodeLIRBuilderTool,
LIRGenerationDebugContext {
    private final NodeMap<Value> nodeOperands;
    private final DebugInfoBuilder debugInfoBuilder;
    private final int traceLIRGeneratorLevel;
    protected final LIRGenerator gen;
    private ValueNode currentInstruction;
    private ValueNode lastInstructionPrinted;
    private final NodeMatchRules nodeMatchRules;
    private EconomicMap<Class<? extends Node>, List<MatchStatement>> matchRules;
    private EconomicMap<Node, Integer> sharedMatchCounts;

    public NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, NodeMatchRules nodeMatchRules) {
        this.gen = (LIRGenerator)gen;
        this.nodeMatchRules = nodeMatchRules;
        this.nodeOperands = graph.createNodeMap();
        this.debugInfoBuilder = this.createDebugInfoBuilder(graph, this);
        OptionValues options = graph.getOptions();
        if (GraalOptions.MatchExpressions.getValue(options).booleanValue()) {
            this.matchRules = MatchRuleRegistry.lookup(nodeMatchRules.getClass(), options, graph.getDebug());
            this.sharedMatchCounts = EconomicMap.create();
        }
        int n = this.traceLIRGeneratorLevel = TTY.isSuppressed() ? 0 : LIRGenerator.Options.TraceLIRGeneratorLevel.getValue(options);
        assert (nodeMatchRules.lirBuilder == null);
        nodeMatchRules.lirBuilder = this;
    }

    public NodeMatchRules getNodeMatchRules() {
        return this.nodeMatchRules;
    }

    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        return new DebugInfoBuilder(nodeValueMap, this.gen.getProviders().getMetaAccessExtensionProvider(), graph.getDebug());
    }

    @Override
    public Value operand(Node node) {
        Value operand = this.getOperand(node);
        assert (operand != null) : String.format("missing operand for %1s", node);
        return operand;
    }

    @Override
    public boolean hasOperand(Node node) {
        return this.getOperand(node) != null;
    }

    private Value getOperand(Node node) {
        if (this.nodeOperands == null) {
            return null;
        }
        return this.nodeOperands.get(node);
    }

    @Override
    public ValueNode valueForOperand(Value value) {
        assert (this.nodeOperands != null);
        MapCursor<Node, Value> cursor = this.nodeOperands.getEntries();
        while (cursor.advance()) {
            if (!((Value)cursor.getValue()).equals((Object)value)) continue;
            return (ValueNode)cursor.getKey();
        }
        return null;
    }

    @Override
    public Object getSourceForOperand(Value value) {
        return this.valueForOperand(value);
    }

    @Override
    public Value setResult(ValueNode x, Value operand) {
        assert (!ValueUtil.isRegister((Value)operand) || !this.gen.attributes(ValueUtil.asRegister((Value)operand)).isAllocatable());
        assert (this.nodeOperands != null && (this.nodeOperands.get(x) == null || this.nodeOperands.get(x) instanceof ComplexMatchValue)) : "operand cannot be set twice";
        assert (operand != null && ValueUtil.isLegal((Value)operand)) : "operand must be legal";
        assert (!(x instanceof VirtualObjectNode));
        this.nodeOperands.set(x, operand);
        return operand;
    }

    public void setMatchResult(Node x, Value operand) {
        assert (operand.equals((Object)ComplexMatchValue.INTERIOR_MATCH) || operand instanceof ComplexMatchValue);
        assert (operand instanceof ComplexMatchValue || MatchPattern.isSingleValueUser(x)) : "interior matches must be single user";
        assert (this.nodeOperands != null && this.nodeOperands.get(x) == null) : "operand cannot be set twice";
        assert (!(x instanceof VirtualObjectNode));
        this.nodeOperands.set(x, operand);
    }

    public void incrementSharedMatchCount(Node node) {
        assert (this.nodeOperands != null && this.nodeOperands.get(node) == null) : "operand cannot be set twice";
        Integer matchValue = (Integer)this.sharedMatchCounts.get((Object)node);
        if (matchValue == null) {
            matchValue = 0;
        }
        matchValue = matchValue + 1;
        this.sharedMatchCounts.put((Object)node, (Object)matchValue);
        if (node.getUsageCount() == matchValue.intValue()) {
            this.nodeOperands.set(node, ComplexMatchValue.INTERIOR_MATCH);
        }
    }

    public LabelRef getLIRBlock(FixedNode b) {
        assert (this.gen.getResult().getLIR().getControlFlowGraph() instanceof ControlFlowGraph);
        Block result = ((ControlFlowGraph)this.gen.getResult().getLIR().getControlFlowGraph()).blockFor(b);
        int suxIndex = 0;
        for (AbstractBlockBase succ : this.gen.getCurrentBlock().getSuccessors()) {
            if (succ == result) {
                assert (this.gen.getCurrentBlock() instanceof Block);
                return LabelRef.forSuccessor(this.gen.getResult().getLIR(), this.gen.getCurrentBlock(), suxIndex);
            }
            ++suxIndex;
        }
        throw GraalError.shouldNotReachHere("Block not in successor list of current block");
    }

    public final void append(LIRInstruction op) {
        if (LIRGenerator.Options.PrintIRWithLIR.getValue(this.nodeOperands.graph().getOptions()).booleanValue() && !TTY.isSuppressed() && this.currentInstruction != null && this.lastInstructionPrinted != this.currentInstruction) {
            this.lastInstructionPrinted = this.currentInstruction;
            InstructionPrinter ip = new InstructionPrinter(TTY.out());
            ip.printInstructionListing(this.currentInstruction);
        }
        this.gen.append(op);
    }

    protected LIRKind getExactPhiKind(PhiNode phi) {
        LIRKind derivedKind = this.gen.toRegisterKind(this.gen.getLIRKind(phi.stamp(NodeView.DEFAULT)));
        for (int i = 0; i < phi.valueCount() && !derivedKind.isUnknownReference(); ++i) {
            LIRKind valueKind;
            ValueNode node = phi.valueAt(i);
            Value value = this.getOperand(node);
            if (value != null && !(value instanceof ComplexMatchValue)) {
                valueKind = (LIRKind)value.getValueKind(LIRKind.class);
            } else {
                assert (NodeLIRBuilder.isPhiInputFromBackedge(phi, i)) : String.format("Input %s to phi node %s is not yet available although it is not coming from a loop back edge", node, phi);
                LIRKind kind = this.gen.getLIRKind(node.stamp(NodeView.DEFAULT));
                valueKind = this.gen.toRegisterKind(kind);
            }
            derivedKind = LIRKind.mergeReferenceInformation(derivedKind, valueKind);
        }
        return derivedKind;
    }

    private static boolean isPhiInputFromBackedge(PhiNode phi, int index) {
        AbstractMergeNode merge = phi.merge();
        AbstractEndNode end = merge.phiPredecessorAt(index);
        return end instanceof LoopEndNode && ((LoopEndNode)end).loopBegin().equals(merge);
    }

    private Value[] createPhiIn(AbstractMergeNode merge) {
        ArrayList<Variable> values = new ArrayList<Variable>();
        for (ValuePhiNode phi : merge.valuePhis()) {
            assert (this.getOperand(phi) == null);
            Variable value = this.gen.newVariable(this.getExactPhiKind(phi));
            values.add(value);
            this.setResult(phi, (Value)value);
        }
        return values.toArray(new Value[values.size()]);
    }

    private Value[] createPhiOut(AbstractMergeNode merge, AbstractEndNode pred) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (PhiNode phiNode : merge.valuePhis()) {
            ValueNode node = phiNode.valueAt(pred);
            Object value = this.operand(node);
            assert (value != null);
            if (ValueUtil.isRegister((Value)value)) {
                value = this.gen.emitMove((Value)value);
            } else if (node.isConstant() && !this.gen.getSpillMoveFactory().allowConstantToStackMove(node.asConstant()) && !LIRKind.isValue(value)) {
                Variable result = this.gen.newVariable(value.getValueKind());
                this.gen.emitMove(result, (Value)value);
                value = result;
            }
            values.add((Value)value);
        }
        return values.toArray(new Value[values.size()]);
    }

    public void doBlockPrologue(Block block, OptionValues options) {
        if (SpectrePHTMitigations.Options.SpectrePHTBarriers.getValue(options) == SpectrePHTMitigations.AllTargets) {
            boolean isStartBlock;
            boolean hasControlSplitPredecessor = false;
            for (Block b : (Block[])block.getPredecessors()) {
                if (b.getSuccessorCount() <= 1) continue;
                hasControlSplitPredecessor = true;
                break;
            }
            boolean bl = isStartBlock = block.getPredecessorCount() == 0;
            if (hasControlSplitPredecessor || isStartBlock) {
                this.getLIRGeneratorTool().emitSpeculationFence();
            }
        }
    }

    @Override
    public void doBlock(Block block, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        OptionValues options = graph.getOptions();
        try (LIRGeneratorTool.BlockScope blockScope = this.gen.getBlockScope(block);){
            this.setSourcePosition(null);
            if (block == this.gen.getResult().getLIR().getControlFlowGraph().getStartBlock()) {
                assert (block.getPredecessorCount() == 0);
                this.emitPrologue(graph);
            } else {
                assert (block.getPredecessorCount() > 0);
                AbstractBeginNode begin = block.getBeginNode();
                if (begin instanceof AbstractMergeNode) {
                    AbstractMergeNode merge = (AbstractMergeNode)begin;
                    StandardOp.LabelOp label = (StandardOp.LabelOp)this.gen.getResult().getLIR().getLIRforBlock(block).get(0);
                    label.setPhiValues(this.createPhiIn(merge));
                    if (LIRGenerator.Options.PrintIRWithLIR.getValue(options).booleanValue() && !TTY.isSuppressed()) {
                        TTY.println("Created PhiIn: " + label);
                    }
                }
            }
            this.doBlockPrologue(block, options);
            List<Node> nodes = blockMap.get(block);
            boolean trace = this.traceLIRGeneratorLevel >= 3;
            for (int i = 0; i < nodes.size(); ++i) {
                Value operand;
                Node node = nodes.get(i);
                if (!(node instanceof ValueNode)) continue;
                this.setSourcePosition(node.getNodeSourcePosition());
                DebugContext debug = node.getDebug();
                ValueNode valueNode = (ValueNode)node;
                if (trace) {
                    TTY.println("LIRGen for " + valueNode);
                }
                if ((operand = this.getOperand(valueNode)) == null) {
                    if (this.peephole(valueNode)) continue;
                    try {
                        this.doRoot(valueNode);
                        continue;
                    }
                    catch (GraalError e) {
                        throw GraalGraphError.transformAndAddContext(e, valueNode);
                    }
                    catch (Throwable e) {
                        throw new GraalGraphError(e).addContext(valueNode);
                    }
                }
                if (ComplexMatchValue.INTERIOR_MATCH.equals((Object)operand)) {
                    debug.log("interior match for %s", valueNode);
                    continue;
                }
                if (!(operand instanceof ComplexMatchValue)) continue;
                debug.log("complex match for %s", valueNode);
                this.setSourcePosition(node.getNodeSourcePosition());
                ComplexMatchValue match = (ComplexMatchValue)operand;
                operand = match.evaluate(this);
                if (operand == null) continue;
                this.setResult(valueNode, operand);
            }
            if (!this.gen.hasBlockEnd(block)) {
                NodeIterable<Node> successors = block.getEndNode().successors();
                assert (successors.count() == block.getSuccessorCount());
                if (block.getSuccessorCount() != 1) {
                    throw new GraalError("Block without BlockEndOp: " + block.getEndNode());
                }
                this.gen.emitJump(this.getLIRBlock((FixedNode)successors.first()));
            }
            assert (LIR.verifyBlock(this.gen.getResult().getLIR(), block));
        }
    }

    public void matchBlock(Block block, StructuredGraph.ScheduleResult schedule) {
        try (DebugCloseable matchScope = this.gen.getMatchScope(block);){
            this.matchComplexExpressions(block, schedule);
        }
    }

    protected void matchComplexExpressions(Block block, StructuredGraph.ScheduleResult schedule) {
        if (this.matchRules != null) {
            DebugContext debug = this.gen.getResult().getLIR().getDebug();
            try (DebugContext.Scope s = debug.scope("MatchComplexExpressions");){
                List<Node> nodes = schedule.getBlockToNodesMap().get(block);
                if (DebugOptions.LogVerbose.getValue(this.nodeOperands.graph().getOptions()).booleanValue()) {
                    int i = 0;
                    for (Node node : nodes) {
                        debug.log("%d: (%s) %1S", (Object)i++, (Object)node.getUsageCount(), (Object)node);
                    }
                }
                for (int index = nodes.size() - 1; index >= 0; --index) {
                    MatchStatement statement;
                    List statements;
                    Node node = nodes.get(index);
                    if (this.getOperand(node) != null || (statements = (List)this.matchRules.get(node.getClass())) == null) continue;
                    Iterator iterator = statements.iterator();
                    while (iterator.hasNext() && !(statement = (MatchStatement)iterator.next()).generate(this, index, node, block, schedule)) {
                    }
                }
            }
        }
    }

    protected abstract boolean peephole(ValueNode var1);

    private void doRoot(ValueNode instr) {
        if (this.traceLIRGeneratorLevel >= 2) {
            TTY.println("Emitting LIR for instruction " + instr);
        }
        this.currentInstruction = instr;
        DebugContext debug = instr.getDebug();
        debug.log("Visiting %s", instr);
        this.emitNode(instr);
        debug.log("Operand for %s = %s", (Object)instr, (Object)this.getOperand(instr));
    }

    protected void emitNode(ValueNode node) {
        if (node.getDebug().isLogEnabled() && node.stamp(NodeView.DEFAULT).isEmpty()) {
            node.getDebug().log("This node has an empty stamp, we are emitting dead code(?): %s", node);
        }
        if (!(node instanceof LIRLowerable)) {
            throw GraalError.shouldNotReachHere("node is not LIRLowerable: " + node);
        }
        ((LIRLowerable)((Object)node)).generate(this);
    }

    protected void emitPrologue(StructuredGraph graph) {
        CallingConvention incomingArguments = this.gen.getResult().getCallingConvention();
        Value[] params = new Value[incomingArguments.getArgumentCount()];
        this.prologAssignParams(incomingArguments, params);
        this.gen.emitIncomingValues(params);
        this.prologSetParameterNodes(graph, params);
    }

    protected final void prologAssignParams(CallingConvention incomingArguments, Value[] params) {
        for (int i = 0; i < incomingArguments.getArgumentCount(); ++i) {
            StackSlot slot;
            params[i] = incomingArguments.getArgument(i);
            if (!ValueUtil.isStackSlot((Value)params[i]) || !(slot = ValueUtil.asStackSlot((Value)params[i])).isInCallerFrame() || this.gen.getResult().getLIR().hasArgInCallerFrame()) continue;
            this.gen.getResult().getLIR().setHasArgInCallerFrame();
        }
    }

    protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
        for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
            Value paramValue = params[param.index()];
            assert (paramValue.getValueKind().equals((Object)this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT)))) : paramValue + " " + this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT));
            this.setResult(param, (Value)this.gen.emitMove(paramValue));
        }
    }

    @Override
    public void visitMerge(AbstractMergeNode x) {
    }

    @Override
    public void visitEndNode(AbstractEndNode end) {
        AbstractMergeNode merge = end.merge();
        StandardOp.JumpOp jump = this.newJumpOp(this.getLIRBlock(merge));
        jump.setPhiValues(this.createPhiOut(merge, end));
        this.append(jump);
    }

    @Override
    public void visitLoopEnd(LoopEndNode x) {
    }

    protected StandardOp.JumpOp newJumpOp(LabelRef ref) {
        return new StandardOp.JumpOp(ref);
    }

    protected LIRKind getPhiKind(PhiNode phi) {
        return this.gen.getLIRKind(phi.stamp(NodeView.DEFAULT));
    }

    @Override
    public void emitIf(IfNode x) {
        this.emitBranch(x.condition(), this.getLIRBlock(x.trueSuccessor()), this.getLIRBlock(x.falseSuccessor()), x.probability(x.trueSuccessor()));
    }

    public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
        if (node instanceof IsNullNode) {
            LIRKind kind = this.gen.getLIRKind(((IsNullNode)node).getValue().stamp(NodeView.DEFAULT));
            Value nullValue = this.gen.emitConstant(kind, (Constant)((IsNullNode)node).nullConstant());
            this.gen.emitCompareBranch(kind.getPlatformKind(), this.operand(((IsNullNode)node).getValue()), nullValue, Condition.EQ, false, trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof CompareNode) {
            PlatformKind kind = this.gen.getLIRKind(((CompareNode)node).getX().stamp(NodeView.DEFAULT)).getPlatformKind();
            this.gen.emitCompareBranch(kind, this.operand(((CompareNode)node).getX()), this.operand(((CompareNode)node).getY()), ((CompareNode)node).condition().asCondition(), ((CompareNode)node).unorderedIsTrue(), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else if (node instanceof LogicConstantNode) {
            this.gen.emitJump(((LogicConstantNode)node).getValue() ? trueSuccessor : falseSuccessor);
        } else if (node instanceof IntegerTestNode) {
            this.gen.emitIntegerTestBranch(this.operand(((IntegerTestNode)node).getX()), this.operand(((IntegerTestNode)node).getY()), trueSuccessor, falseSuccessor, trueSuccessorProbability);
        } else {
            throw GraalError.unimplemented(node.toString());
        }
    }

    @Override
    public void emitConditional(ConditionalNode conditional) {
        Value tVal = this.operand(conditional.trueValue());
        Value fVal = this.operand(conditional.falseValue());
        this.setResult(conditional, (Value)this.emitConditional(conditional.condition(), tVal, fVal));
    }

    public Variable emitConditional(LogicNode node, Value trueValue, Value falseValue) {
        if (node instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)node;
            LIRKind kind = this.gen.getLIRKind(isNullNode.getValue().stamp(NodeView.DEFAULT));
            Value nullValue = this.gen.emitConstant(kind, (Constant)isNullNode.nullConstant());
            return this.gen.emitConditionalMove(kind.getPlatformKind(), this.operand(isNullNode.getValue()), nullValue, Condition.EQ, false, trueValue, falseValue);
        }
        if (node instanceof CompareNode) {
            CompareNode compare = (CompareNode)node;
            PlatformKind kind = this.gen.getLIRKind(compare.getX().stamp(NodeView.DEFAULT)).getPlatformKind();
            return this.gen.emitConditionalMove(kind, this.operand(compare.getX()), this.operand(compare.getY()), compare.condition().asCondition(), compare.unorderedIsTrue(), trueValue, falseValue);
        }
        if (node instanceof LogicConstantNode) {
            return this.gen.emitMove(((LogicConstantNode)node).getValue() ? trueValue : falseValue);
        }
        if (node instanceof IntegerTestNode) {
            IntegerTestNode test = (IntegerTestNode)node;
            return this.gen.emitIntegerTestMove(this.operand(test.getX()), this.operand(test.getY()), trueValue, falseValue);
        }
        throw GraalError.unimplemented(node.toString());
    }

    @Override
    public void emitInvoke(Invoke x) {
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)x.callTarget();
        FrameMapBuilder frameMapBuilder = this.gen.getResult().getFrameMapBuilder();
        CallingConvention invokeCc = frameMapBuilder.getRegisterConfig().getCallingConvention(callTarget.callType(), (JavaType)x.asNode().stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess()), callTarget.signature(), (ValueKindFactory)this.gen);
        frameMapBuilder.callsMethod(invokeCc);
        Value[] parameters = this.visitInvokeArguments(invokeCc, callTarget.arguments());
        LabelRef exceptionEdge = null;
        if (x instanceof InvokeWithExceptionNode) {
            exceptionEdge = this.getLIRBlock(((InvokeWithExceptionNode)x).exceptionEdge());
        }
        LIRFrameState callState = this.stateWithExceptionEdge(x, exceptionEdge);
        AllocatableValue result = invokeCc.getReturn();
        this.emitInvoke(callTarget, parameters, callState, (Value)result);
        if (ValueUtil.isLegal((Value)result)) {
            this.setResult(x.asNode(), (Value)this.gen.emitMove((Value)result));
        }
        if (x instanceof InvokeWithExceptionNode) {
            this.gen.emitJump(this.getLIRBlock(((InvokeWithExceptionNode)x).next()));
        }
    }

    protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
        if (callTarget instanceof DirectCallTargetNode) {
            this.emitDirectCall((DirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else if (callTarget instanceof IndirectCallTargetNode) {
            this.emitIndirectCall((IndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    @Override
    public void emitForeignCall(ForeignCall x) {
        Value[] args;
        LIRFrameState callState;
        Variable result;
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(x.getDescriptor());
        LabelRef exceptionEdge = null;
        if (x instanceof WithExceptionNode) {
            exceptionEdge = this.getLIRBlock(((WithExceptionNode)((Object)x)).exceptionEdge());
        }
        if ((result = this.gen.emitForeignCall(linkage, callState = this.stateWithExceptionEdge(x, exceptionEdge), args = x.operands(this))) != null) {
            this.setResult(x.asNode(), (Value)result);
        }
        if (x instanceof WithExceptionNode) {
            this.gen.emitJump(this.getLIRBlock(((WithExceptionNode)((Object)x)).next()));
        }
    }

    protected abstract void emitDirectCall(DirectCallTargetNode var1, Value var2, Value[] var3, Value[] var4, LIRFrameState var5);

    protected abstract void emitIndirectCall(IndirectCallTargetNode var1, Value var2, Value[] var3, Value[] var4, LIRFrameState var5);

    public Value[] visitInvokeArguments(CallingConvention invokeCc, Collection<ValueNode> arguments) {
        Value[] result = new Value[arguments.size()];
        int j = 0;
        for (ValueNode arg : arguments) {
            if (arg != null) {
                AllocatableValue operand = invokeCc.getArgument(j);
                this.gen.emitMove(operand, this.operand(arg));
                result[j] = operand;
                ++j;
                continue;
            }
            throw GraalError.shouldNotReachHere("I thought we no longer have null entries for two-slot types...");
        }
        return result;
    }

    @Override
    public void emitSwitch(SwitchNode x) {
        assert (x.defaultSuccessor() != null);
        LabelRef defaultTarget = this.getLIRBlock(x.defaultSuccessor());
        int keyCount = x.keyCount();
        if (keyCount == 0) {
            this.gen.emitJump(defaultTarget);
        } else {
            AllocatableValue value = this.gen.asAllocatable(this.operand(x.value()));
            if (keyCount == 1) {
                assert (defaultTarget != null);
                double probability = x.probability(x.keySuccessor(0));
                LIRKind kind = this.gen.getLIRKind(x.value().stamp(NodeView.DEFAULT));
                Value key = this.gen.emitConstant(kind, x.keyAt(0));
                this.gen.emitCompareBranch(kind.getPlatformKind(), (Value)value, key, Condition.EQ, false, this.getLIRBlock(x.keySuccessor(0)), defaultTarget, probability);
            } else if (x instanceof IntegerSwitchNode && x.isSorted()) {
                IntegerSwitchNode intSwitch = (IntegerSwitchNode)x;
                LabelRef[] keyTargets = new LabelRef[keyCount];
                JavaConstant[] keyConstants = new JavaConstant[keyCount];
                double[] keyProbabilities = new double[keyCount];
                JavaKind keyKind = intSwitch.keyAt(0).getJavaKind();
                for (int i = 0; i < keyCount; ++i) {
                    keyTargets[i] = this.getLIRBlock(intSwitch.keySuccessor(i));
                    keyConstants[i] = intSwitch.keyAt(i);
                    keyProbabilities[i] = intSwitch.keyProbability(i);
                    assert (keyConstants[i].getJavaKind() == keyKind);
                }
                this.gen.emitStrategySwitch(keyConstants, keyProbabilities, keyTargets, defaultTarget, value);
            } else {
                LabelRef[] keyTargets = new LabelRef[keyCount];
                Constant[] keyConstants = new Constant[keyCount];
                double[] keyProbabilities = new double[keyCount];
                for (int i = 0; i < keyCount; ++i) {
                    keyTargets[i] = this.getLIRBlock(x.keySuccessor(i));
                    keyConstants[i] = x.keyAt(i);
                    keyProbabilities[i] = x.keyProbability(i);
                }
                this.gen.emitStrategySwitch(new SwitchStrategy.SequentialStrategy(keyProbabilities, keyConstants), value, keyTargets, defaultTarget);
            }
        }
    }

    public DebugInfoBuilder getDebugInfoBuilder() {
        assert (this.debugInfoBuilder != null);
        return this.debugInfoBuilder;
    }

    private static FrameState getFrameState(DeoptimizingNode deopt) {
        if (deopt instanceof DeoptimizingNode.DeoptBefore) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptDuring) && !(deopt instanceof DeoptimizingNode.DeoptAfter));
            return ((DeoptimizingNode.DeoptBefore)deopt).stateBefore();
        }
        if (deopt instanceof DeoptimizingNode.DeoptDuring) {
            assert (!(deopt instanceof DeoptimizingNode.DeoptAfter));
            return ((DeoptimizingNode.DeoptDuring)deopt).stateDuring();
        }
        assert (deopt instanceof DeoptimizingNode.DeoptAfter);
        return ((DeoptimizingNode.DeoptAfter)deopt).stateAfter();
    }

    @Override
    public LIRFrameState state(DeoptimizingNode deopt) {
        if (!deopt.canDeoptimize()) {
            return null;
        }
        return this.stateFor(deopt, NodeLIRBuilder.getFrameState(deopt));
    }

    public LIRFrameState stateWithExceptionEdge(DeoptimizingNode deopt, LabelRef exceptionEdge) {
        if (!deopt.canDeoptimize()) {
            return null;
        }
        return this.stateForWithExceptionEdge(deopt, NodeLIRBuilder.getFrameState(deopt), exceptionEdge);
    }

    public LIRFrameState stateFor(NodeWithState deopt, FrameState state) {
        return this.stateForWithExceptionEdge(deopt, state, null);
    }

    public LIRFrameState stateForWithExceptionEdge(NodeWithState deopt, FrameState state, LabelRef exceptionEdge) {
        if (this.gen.needOnlyOopMaps()) {
            return new LIRFrameState(null, null, null);
        }
        JavaConstant deoptReasonAndAction = null;
        JavaConstant deoptSpeculation = null;
        assert (state != null) : "Deopt node=" + deopt + " needs a state ";
        if (deopt instanceof ImplicitNullCheckNode) {
            ImplicitNullCheckNode implicitNullCheck = (ImplicitNullCheckNode)deopt;
            deoptReasonAndAction = implicitNullCheck.getDeoptReasonAndAction();
            deoptSpeculation = implicitNullCheck.getDeoptSpeculation();
        } else if (deopt instanceof IntegerDivRemNode) {
            IntegerDivRemNode idiv = (IntegerDivRemNode)deopt;
            deoptReasonAndAction = idiv.getDeoptReasonAndAction();
            deoptSpeculation = idiv.getDeoptSpeculation();
        }
        if (deoptSpeculation != null) {
            assert (deoptReasonAndAction != null);
            assert (this.isValidImplicitLIRFrameState(deoptReasonAndAction, deoptSpeculation, deopt.asNode().graph().getSpeculationLog())) : "Unsupported implicit exception";
            return this.getDebugInfoBuilder().build(deopt, state, exceptionEdge, deoptReasonAndAction, deoptSpeculation);
        }
        return this.getDebugInfoBuilder().build(deopt, state, exceptionEdge, null, null);
    }

    private boolean isValidImplicitLIRFrameState(JavaConstant reasonAndAction, JavaConstant deoptSpeculation, SpeculationLog speculationLog) {
        if (GraalServices.supportsArbitraryImplicitException()) {
            return true;
        }
        DeoptimizationReason deoptimizationReason = this.getLIRGeneratorTool().getMetaAccess().decodeDeoptReason(reasonAndAction);
        SpeculationLog.Speculation speculation = this.getLIRGeneratorTool().getMetaAccess().decodeSpeculation(deoptSpeculation, speculationLog);
        return (deoptimizationReason == DeoptimizationReason.NullCheckException || deoptimizationReason == DeoptimizationReason.UnreachedCode || deoptimizationReason == DeoptimizationReason.TypeCheckedInliningViolated || deoptimizationReason == DeoptimizationReason.ArithmeticException) && speculation == SpeculationLog.NO_SPECULATION;
    }

    @Override
    public void emitOverflowCheckBranch(AbstractBeginNode overflowSuccessor, AbstractBeginNode next, Stamp stamp, double probability) {
        LIRKind cmpKind = this.getLIRGeneratorTool().getLIRKind(stamp);
        this.gen.emitOverflowCheckBranch(this.getLIRBlock(overflowSuccessor), this.getLIRBlock(next), cmpKind, probability);
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        this.append(new FullInfopointOp(this.stateFor(i, i.getState()), i.getReason()));
    }

    private void setSourcePosition(NodeSourcePosition position) {
        this.gen.setSourcePosition(position);
    }

    @Override
    public LIRGenerator getLIRGeneratorTool() {
        return this.gen;
    }

    @Override
    public void emitReadExceptionObject(ValueNode node) {
        LIRGenerator lirGenTool = this.getLIRGeneratorTool();
        RegisterValue returnRegister = lirGenTool.getRegisterConfig().getReturnRegister(node.getStackKind()).asValue((ValueKind)LIRKind.fromJavaKind(lirGenTool.target().arch, node.getStackKind()));
        lirGenTool.emitIncomingValues(new Value[]{returnRegister});
        this.setResult(node, (Value)lirGenTool.emitMove((Value)returnRegister));
    }
}

