/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.phases.BaseTier;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.loop.phases.LoopFullUnrollPhase;
import org.graalvm.compiler.loop.phases.LoopPeelingPhase;
import org.graalvm.compiler.loop.phases.LoopUnswitchingPhase;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.common.BoxNodeIdentityPhase;
import org.graalvm.compiler.phases.common.BoxNodeOptimizationPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.DisableOverflownCountedLoopsPhase;
import org.graalvm.compiler.phases.common.DominatorBasedGlobalValueNumberingPhase;
import org.graalvm.compiler.phases.common.HighTierLoweringPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.NodeCounterPhase;
import org.graalvm.compiler.phases.common.inlining.InliningPhase;
import org.graalvm.compiler.phases.common.inlining.policy.GreedyInliningPolicy;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.virtual.phases.ea.FinalPartialEscapePhase;
import org.graalvm.compiler.virtual.phases.ea.ReadEliminationPhase;

public class HighTier
extends BaseTier<HighTierContext> {
    public HighTier(OptionValues options) {
        CanonicalizerPhase canonicalizer = this.createCanonicalizerPhase();
        this.appendPhase(canonicalizer);
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.INIT));
        }
        if (Options.Inline.getValue(options).booleanValue()) {
            this.appendPhase(new InliningPhase(new GreedyInliningPolicy(null), canonicalizer));
            this.appendPhase(new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional));
        }
        this.appendPhase(new DisableOverflownCountedLoopsPhase());
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.EARLY));
        }
        if (GraalOptions.OptConvertDeoptsToGuards.getValue(options).booleanValue()) {
            this.appendPhase(new ConvertDeoptimizeToGuardPhase(canonicalizer));
        }
        if (GraalOptions.ConditionalElimination.getValue(options).booleanValue()) {
            this.appendPhase(new IterativeConditionalEliminationPhase(canonicalizer, false));
        }
        if (GraalOptions.EarlyGVN.getValue(options).booleanValue()) {
            this.appendPhase(new DominatorBasedGlobalValueNumberingPhase());
        }
        LoopPolicies loopPolicies = this.createLoopPolicies(options);
        this.appendPhase(new LoopFullUnrollPhase(canonicalizer, loopPolicies));
        if (GraalOptions.LoopPeeling.getValue(options).booleanValue()) {
            this.appendPhase(new LoopPeelingPhase(loopPolicies, canonicalizer));
        }
        if (GraalOptions.LoopUnswitch.getValue(options).booleanValue()) {
            this.appendPhase(new LoopUnswitchingPhase(loopPolicies, canonicalizer));
        }
        this.appendPhase(new BoxNodeIdentityPhase());
        if (GraalOptions.PartialEscapeAnalysis.getValue(options).booleanValue()) {
            this.appendPhase(new FinalPartialEscapePhase(true, canonicalizer, null, options));
        }
        if (GraalOptions.OptReadElimination.getValue(options).booleanValue()) {
            this.appendPhase(new ReadEliminationPhase(canonicalizer));
        }
        if (NodeCounterPhase.Options.NodeCounters.getValue(options).booleanValue()) {
            this.appendPhase(new NodeCounterPhase(NodeCounterPhase.Stage.LATE));
        }
        this.appendPhase(new BoxNodeOptimizationPhase(canonicalizer));
        this.appendPhase(new HighTierLoweringPhase(canonicalizer, true));
    }

    @Override
    public LoopPolicies createLoopPolicies(OptionValues options) {
        return new DefaultLoopPolicies();
    }

    public static class Options {
        public static final OptionKey<Boolean> Inline = new OptionKey<Boolean>(true);
    }
}

