/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ArrayIndexOfNode;

public class ArrayIndexOfStub
extends SnippetStub {
    public ArrayIndexOfStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(linkage.getDescriptor().getName(), options, providers, linkage);
    }

    @Snippet
    private static int indexOfTwoConsecutiveBS1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveBS2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveCS2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfB1S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOfB2S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfB3S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOfB4S1(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfB1S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOfB2S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfB3S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOfB4S2(byte[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfC1S2(char[] array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOfC2S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfC3S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOfC4S2(char[] array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveS4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, true, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf1S1(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf2S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf3S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf4S1(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOf1S2(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf2S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf3S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf4S2(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOf1S4(Object array, long offset, int arrayLength, int fromIndex, int v1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, false, false, array, offset, arrayLength, fromIndex, v1);
    }

    @Snippet
    private static int indexOf2S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, false, false, array, offset, arrayLength, fromIndex, v1, v2);
    }

    @Snippet
    private static int indexOf3S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3);
    }

    @Snippet
    private static int indexOf4S4(Object array, long offset, int arrayLength, int fromIndex, int v1, int v2, int v3, int v4) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, false, false, array, offset, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    @Snippet
    private static int indexOfWithMaskBS1(byte[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfWithMaskBS2(byte[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskBS1(byte[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S1, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskBS2(byte[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S1, StrideUtil.S2, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }

    @Snippet
    private static int indexOfWithMaskCS2(char[] array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskCS2(char[] array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.S2, StrideUtil.S2, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }

    @Snippet
    private static int indexOfWithMaskS1(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfWithMaskS2(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfWithMaskS4(Object array, long offset, int length, int fromIndex, int v1, int mask1) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, false, true, array, offset, length, fromIndex, v1, mask1);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS1(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S1, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS2(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S2, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }

    @Snippet
    private static int indexOfTwoConsecutiveWithMaskS4(Object array, long offset, int length, int fromIndex, int v1, int v2, int mask1, int mask2) {
        return ArrayIndexOfNode.optimizedArrayIndexOf(StrideUtil.NONE, StrideUtil.S4, true, true, array, offset, length, fromIndex, v1, v2, mask1, mask2);
    }
}

