/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.SymbolicJVMCIReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.SnippetObjectConstant;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaType;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ConstantBindingParameterPlugin;
import org.graalvm.compiler.replacements.PEGraphDecoder;
import org.graalvm.compiler.replacements.PartialIntrinsicCallTargetNode;

public class EncodedSnippets {
    private final byte[] snippetEncoding;
    private final Object[] snippetObjects;
    private final NodeClass<?>[] snippetNodeClasses;
    private final UnmodifiableEconomicMap<String, GraphData> graphDatas;
    private final Map<Class<?>, SnippetResolvedJavaType> snippetTypes;

    EncodedSnippets(byte[] snippetEncoding, Object[] snippetObjects, NodeClass<?>[] snippetNodeClasses, UnmodifiableEconomicMap<String, GraphData> graphDatas, Map<Class<?>, SnippetResolvedJavaType> snippetTypes) {
        this.snippetEncoding = snippetEncoding;
        this.snippetObjects = snippetObjects;
        this.snippetNodeClasses = snippetNodeClasses;
        this.graphDatas = graphDatas;
        this.snippetTypes = snippetTypes;
    }

    public NodeClass<?>[] getSnippetNodeClasses() {
        return this.snippetNodeClasses;
    }

    ResolvedJavaType lookupSnippetType(Class<?> clazz) {
        SnippetResolvedJavaType type = this.snippetTypes.get(clazz);
        if (type == null && HotSpotReplacementsImpl.isGraalClass(clazz)) {
            throw new GraalError("Missing Graal class " + clazz.getName());
        }
        return type;
    }

    public void visitImmutable(Consumer<Object> visitor) {
        visitor.accept(this.snippetEncoding);
        visitor.accept(this.snippetNodeClasses);
        visitor.accept(this.graphDatas);
    }

    public static String methodKey(ResolvedJavaMethod method) {
        return method.format("%H.%n(%P)");
    }

    StructuredGraph getEncodedSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, HotSpotReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        if (data == null) {
            if (Services.IS_IN_NATIVE_IMAGE) {
                throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
            }
            return null;
        }
        Class<?> receiverClass = null;
        if (!method.isStatic()) {
            assert (args != null && args[0] != null) : "must have a receiver";
            receiverClass = args[0].getClass();
        }
        int startOffset = data.getStartOffset(receiverClass);
        ResolvedJavaType declaringClass = method.getDeclaringClass();
        if (declaringClass instanceof SnippetResolvedJavaType) {
            declaringClass = replacements.getProviders().getMetaAccess().lookupJavaType(Object.class);
        }
        SymbolicEncodedGraph encodedGraph = new SymbolicEncodedGraph(this.snippetEncoding, startOffset, this.snippetObjects, this.snippetNodeClasses, data.originalMethod, declaringClass);
        return EncodedSnippets.decodeSnippetGraph(encodedGraph, method, original, replacements, args, allowAssumptions, options, Services.IS_IN_NATIVE_IMAGE);
    }

    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        assert (data != null) : method + " " + EncodedSnippets.methodKey(method);
        SnippetParameterInfo info = data.info;
        assert (info != null);
        return info;
    }

    public boolean isSnippet(ResolvedJavaMethod method) {
        GraphData data = null;
        if (this.graphDatas != null) {
            data = (GraphData)this.graphDatas.get((Object)EncodedSnippets.methodKey(method));
        }
        return data != null && data.info != null;
    }

    static StructuredGraph decodeSnippetGraph(SymbolicEncodedGraph encodedGraph, ResolvedJavaMethod method, ResolvedJavaMethod original, HotSpotReplacementsImpl replacements, Object[] args, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options, boolean mustSucceed) {
        HotSpotProviders providers = replacements.getProviders();
        ConstantBindingParameterPlugin parameterPlugin = null;
        if (args != null) {
            MetaAccessProvider meta = HotSpotReplacementsImpl.noticeTypes(providers.getMetaAccess());
            SnippetReflectionProvider snippetReflection = replacements.snippetReflection;
            if (Services.IS_IN_NATIVE_IMAGE) {
                snippetReflection = new LibGraalSnippetReflectionProvider(snippetReflection);
            }
            parameterPlugin = new ConstantBindingParameterPlugin(args, meta, snippetReflection);
        }
        try (DebugContext debug = replacements.openDebugContext("LibGraal", method, options);){
            boolean isSubstitution = true;
            StructuredGraph result = new StructuredGraph.Builder(options, debug, allowAssumptions).method(method).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).setIsSubstitution(isSubstitution).build();
            DebugContext.Scope scope = debug.scope((Object)"LibGraal.DecodeSnippet", result);
            try {
                SubstitutionGraphDecoder graphDecoder = new SubstitutionGraphDecoder(providers, result, replacements, parameterPlugin, method, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, encodedGraph, mustSucceed);
                graphDecoder.decode(method, isSubstitution, encodedGraph.trackNodeSourcePosition());
                EncodedSnippets.postDecode(debug, result, original);
                assert (result.verify());
                StructuredGraph structuredGraph = result;
                if (scope != null) {
                    scope.close();
                }
                return structuredGraph;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw debug.handle(t);
                }
            }
        }
    }

    private static void postDecode(DebugContext debug, StructuredGraph result, ResolvedJavaMethod original) {
        debug.dump(3, result, "Before PartialIntrinsicCallTargetNode replacement");
        for (PartialIntrinsicCallTargetNode partial : result.getNodes(PartialIntrinsicCallTargetNode.TYPE)) {
            assert (partial.checkName(original));
            ValueNode[] arguments = partial.arguments().toArray((A[])new ValueNode[partial.arguments().size()]);
            MethodCallTargetNode target = result.add(new MethodCallTargetNode(partial.invokeKind(), original, arguments, partial.returnStamp(), null));
            partial.replaceAndDelete(target);
        }
        debug.dump(3, result, "After decoding");
        for (ValueNode n : result.getNodes().filter(ValueNode.class)) {
            ConstantNode constant;
            if (!(n instanceof ConstantNode) || !((constant = (ConstantNode)n).asConstant() instanceof SnippetObjectConstant)) continue;
            throw new InternalError(n.toString(Verbosity.Debugger));
        }
    }

    static class SymbolicStampPair
    implements SymbolicJVMCIReference<StampPair> {
        final Object trustedStamp;
        final Object uncheckedStamp;

        SymbolicStampPair(Object trustedStamp, Object uncheckedStamp) {
            this.trustedStamp = trustedStamp;
            this.uncheckedStamp = uncheckedStamp;
        }

        @Override
        public StampPair resolve(ResolvedJavaType accessingClass) {
            return StampPair.create(SymbolicStampPair.resolveStamp(accessingClass, this.trustedStamp), SymbolicStampPair.resolveStamp(accessingClass, this.uncheckedStamp));
        }

        public String toString() {
            return "SymbolicStampPair{trustedStamp=" + this.trustedStamp + ", uncheckedStamp=" + this.uncheckedStamp + "}";
        }

        private static Stamp resolveStamp(ResolvedJavaType accessingClass, Object stamp) {
            if (stamp == null) {
                return null;
            }
            if (stamp instanceof Stamp) {
                return (Stamp)stamp;
            }
            return (Stamp)((SymbolicJVMCIReference)stamp).resolve(accessingClass);
        }
    }

    static class SymbolicResolvedJavaMethodBytecode
    implements SymbolicJVMCIReference<ResolvedJavaMethodBytecode> {
        SymbolicResolvedJavaMethod method;

        SymbolicResolvedJavaMethodBytecode(SymbolicResolvedJavaMethod method) {
            this.method = method;
        }

        @Override
        public ResolvedJavaMethodBytecode resolve(ResolvedJavaType accessingClass) {
            return new ResolvedJavaMethodBytecode(this.method.resolve(accessingClass));
        }

        public String toString() {
            return "SymbolicResolvedJavaMethodBytecode{method=" + this.method + "}";
        }
    }

    static class SymbolicResolvedJavaField
    implements SymbolicJVMCIReference<ResolvedJavaField> {
        final UnresolvedJavaType declaringType;
        final String name;
        final UnresolvedJavaType signature;
        private final boolean isStatic;

        SymbolicResolvedJavaField(UnresolvedJavaType declaringType, String name, UnresolvedJavaType signature, boolean isStatic) {
            this.declaringType = declaringType;
            this.name = name;
            this.signature = signature;
            this.isStatic = isStatic;
        }

        @Override
        public ResolvedJavaField resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaField[] fields;
            ResolvedJavaType resolvedType = this.declaringType.resolve(accessingClass);
            if (resolvedType == null) {
                throw new NoClassDefFoundError("Can't resolve " + this.declaringType.getName() + " with " + accessingClass.getName());
            }
            ResolvedJavaType resolvedFieldType = this.signature.resolve(accessingClass);
            if (resolvedFieldType == null) {
                throw new NoClassDefFoundError("Can't resolve " + this.signature.getName() + " with " + accessingClass.getName());
            }
            for (ResolvedJavaField field : fields = this.isStatic ? resolvedType.getStaticFields() : resolvedType.getInstanceFields(true)) {
                if (!field.getName().equals(this.name) || !field.getType().equals(resolvedFieldType)) continue;
                return field;
            }
            throw new InternalError("Could not resolve " + this + " in context of " + accessingClass.toJavaName());
        }

        public String toString() {
            return "SymbolicResolvedJavaField{" + this.signature.getName() + " " + this.declaringType.getName() + "." + this.name + "}";
        }
    }

    static class SymbolicResolvedJavaFieldLocationIdentity
    implements SymbolicJVMCIReference<FieldLocationIdentity> {
        final SymbolicResolvedJavaField inner;

        SymbolicResolvedJavaFieldLocationIdentity(SymbolicResolvedJavaField inner) {
            this.inner = inner;
        }

        @Override
        public FieldLocationIdentity resolve(ResolvedJavaType accessingClass) {
            return new FieldLocationIdentity(this.inner.resolve(accessingClass));
        }

        public String toString() {
            return "SymbolicResolvedJavaFieldLocationIdentity{" + this.inner.toString() + "}";
        }
    }

    static class SymbolicResolvedJavaMethod
    implements SymbolicJVMCIReference<ResolvedJavaMethod> {
        final UnresolvedJavaType type;
        final String methodName;
        final String signature;

        SymbolicResolvedJavaMethod(UnresolvedJavaType type, String methodName, String signature) {
            this.type = type;
            this.methodName = methodName;
            this.signature = signature;
        }

        public String toString() {
            return "SymbolicResolvedJavaMethod{declaringType='" + this.type.getName() + "', methodName='" + this.methodName + "', signature='" + this.signature + "'}";
        }

        @Override
        public ResolvedJavaMethod resolve(ResolvedJavaType accessingClass) {
            ResolvedJavaType resolvedType = this.type.resolve(accessingClass);
            if (resolvedType == null) {
                throw new NoClassDefFoundError("Can't resolve " + this.type.getName() + " with " + accessingClass.getName());
            }
            for (ResolvedJavaMethod method : this.methodName.equals("<init>") ? resolvedType.getDeclaredConstructors() : resolvedType.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName) || !method.getSignature().toMethodDescriptor().equals(this.signature)) continue;
                return method;
            }
            throw new NoClassDefFoundError("Can't resolve " + this.type.getName() + " with " + accessingClass.getName());
        }
    }

    static class GraalCapability {
        final Class<?> capabilityClass;

        GraalCapability(Class<?> capabilityClass) {
            this.capabilityClass = capabilityClass;
        }

        public Object resolve(GraalRuntime runtime) {
            Object capability = runtime.getCapability(this.capabilityClass);
            if (capability != null) {
                assert (capability.getClass() == this.capabilityClass);
                return capability;
            }
            throw new InternalError(this.capabilityClass.getName());
        }

        public String toString() {
            return "GraalCapability{capabilityClass=" + this.capabilityClass + "}";
        }
    }

    static class SymbolicEncodedGraph
    extends EncodedGraph {
        private final ResolvedJavaType[] accessingClasses;
        private final String originalMethod;

        SymbolicEncodedGraph(byte[] encoding, int startOffset, Object[] objects, NodeClass<?>[] types, String originalMethod, ResolvedJavaType ... accessingClasses) {
            super(encoding, startOffset, objects, types, null, null, false, false);
            this.accessingClasses = accessingClasses;
            this.originalMethod = originalMethod;
        }

        SymbolicEncodedGraph(EncodedGraph encodedGraph, ResolvedJavaType declaringClass, String originalMethod) {
            this(encodedGraph.getEncoding(), encodedGraph.getStartOffset(), encodedGraph.getObjects(), encodedGraph.getNodeClasses(), originalMethod, declaringClass);
        }

        @Override
        public Object getObject(int i) {
            Object o = this.objects[i];
            Object replacement = null;
            NoClassDefFoundError error = null;
            if (o instanceof SymbolicJVMCIReference) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((SymbolicJVMCIReference)o).resolve(type);
                        if (replacement == null) continue;
                        break;
                    }
                    catch (NoClassDefFoundError e) {
                        error = e;
                    }
                }
            } else if (o instanceof UnresolvedJavaType) {
                for (ResolvedJavaType type : this.accessingClasses) {
                    try {
                        replacement = ((UnresolvedJavaType)o).resolve(type);
                        if (replacement == null) continue;
                        break;
                    }
                    catch (NoClassDefFoundError e) {
                        error = e;
                    }
                }
            } else {
                if (o instanceof UnresolvedJavaMethod) {
                    throw new InternalError(o.toString());
                }
                if (o instanceof UnresolvedJavaField) {
                    for (ResolvedJavaType type : this.accessingClasses) {
                        try {
                            replacement = ((UnresolvedJavaField)o).resolve(type);
                            if (replacement == null) continue;
                            break;
                        }
                        catch (NoClassDefFoundError e) {
                            error = e;
                        }
                    }
                } else if (o instanceof GraalCapability) {
                    replacement = ((GraalCapability)o).resolve(((GraalJVMCICompiler)JVMCI.getRuntime().getCompiler()).getGraalRuntime());
                } else {
                    return o;
                }
            }
            if (replacement == null) {
                throw new GraalError(error, "Can't resolve %s", o);
            }
            this.objects[i] = o = replacement;
            return o;
        }

        @Override
        public boolean isCallToOriginal(ResolvedJavaMethod callTarget) {
            if (this.originalMethod != null && this.originalMethod.equals(EncodedSnippets.methodKey(callTarget))) {
                return true;
            }
            return super.isCallToOriginal(callTarget);
        }
    }

    static class SubstitutionGraphDecoder
    extends PEGraphDecoder {
        private final ResolvedJavaMethod method;
        private final EncodedGraph encodedGraph;
        private final IntrinsicContext intrinsic;
        private final boolean mustSucceed;

        SubstitutionGraphDecoder(Providers providers, StructuredGraph result, HotSpotReplacementsImpl replacements, ParameterPlugin parameterPlugin, ResolvedJavaMethod method, IntrinsicContext.CompilationContext context, EncodedGraph encodedGraph, boolean mustSucceed) {
            super(providers.getCodeCache().getTarget().arch, result, providers, null, replacements.getGraphBuilderPlugins().getInvocationPlugins(), new InlineInvokePlugin[0], parameterPlugin, null, null, null, new ConcurrentHashMap<PEGraphDecoder.SpecialCallTargetCacheKey, Object>(), new ConcurrentHashMap<ResolvedJavaMethod, Object>(), false);
            this.method = method;
            this.encodedGraph = encodedGraph;
            this.mustSucceed = mustSucceed;
            this.intrinsic = new IntrinsicContext(method, null, replacements.getDefaultReplacementBytecodeProvider(), context, false);
        }

        @Override
        protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod lookupMethod, BytecodeProvider intrinsicBytecodeProvider, boolean isSubstitution, boolean trackNodeSourcePosition) {
            if (lookupMethod.equals(this.method)) {
                return this.encodedGraph;
            }
            throw GraalError.shouldNotReachHere(this.method.format("%H.%n(%p)"));
        }

        @Override
        public IntrinsicContext getIntrinsic() {
            return this.intrinsic;
        }

        @Override
        protected boolean pluginReplacementMustSucceed() {
            return this.mustSucceed;
        }
    }

    static class LibGraalSnippetReflectionProvider
    implements SnippetReflectionProvider {
        final SnippetReflectionProvider delegate;

        LibGraalSnippetReflectionProvider(SnippetReflectionProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public JavaConstant forObject(Object object) {
            return new SnippetObjectConstant(object);
        }

        @Override
        public <T> T asObject(Class<T> type, JavaConstant constant) {
            return this.delegate.asObject(type, constant);
        }

        @Override
        public JavaConstant forBoxed(JavaKind kind, Object value) {
            if (kind == JavaKind.Object) {
                return this.forObject(value);
            }
            return this.delegate.forBoxed(kind, value);
        }

        @Override
        public <T> T getInjectedNodeIntrinsicParameter(Class<T> type) {
            return this.delegate.getInjectedNodeIntrinsicParameter(type);
        }

        @Override
        public Class<?> originalClass(ResolvedJavaType type) {
            return this.delegate.originalClass(type);
        }
    }

    static class VirtualGraphData
    extends GraphData {
        private final Class<?> receiverClass;
        private final VirtualGraphData next;

        VirtualGraphData(int startOffset, String originalMethod, SnippetParameterInfo info, Class<?> receiverClass, VirtualGraphData next) {
            super(startOffset, originalMethod, info);
            this.receiverClass = receiverClass;
            this.next = next;
        }

        @Override
        int getStartOffset(Class<?> aClass) {
            VirtualGraphData start = this;
            while (start != null) {
                if (start.receiverClass == aClass) {
                    return start.startOffset;
                }
                start = start.next;
            }
            throw GraalError.shouldNotReachHere("missing receiver type " + aClass);
        }
    }

    static class StaticGraphData
    extends GraphData {
        StaticGraphData(int startOffset, String originalMethod, SnippetParameterInfo info) {
            super(startOffset, originalMethod, info);
        }

        @Override
        int getStartOffset(Class<?> receiverClass) {
            assert (receiverClass == null);
            return this.startOffset;
        }
    }

    static abstract class GraphData {
        int startOffset;
        String originalMethod;
        SnippetParameterInfo info;

        GraphData(int startOffset, String originalMethod, SnippetParameterInfo info) {
            this.startOffset = startOffset;
            this.originalMethod = originalMethod;
            this.info = info;
        }

        public static GraphData create(int startOffset, String originalMethod, SnippetParameterInfo snippetParameterInfo, Class<?> receiverClass, GraphData existingGraph) {
            if (receiverClass == null) {
                assert (existingGraph == null) : originalMethod;
                return new StaticGraphData(startOffset, originalMethod, snippetParameterInfo);
            }
            return new VirtualGraphData(startOffset, originalMethod, snippetParameterInfo, receiverClass, (VirtualGraphData)existingGraph);
        }

        abstract int getStartOffset(Class<?> var1);
    }
}

