/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.core.aarch64.AArch64MoveFactory;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMove;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;

public class AArch64HotSpotMoveFactory
extends AArch64MoveFactory {
    @Override
    public boolean canInlineConstant(Constant c) {
        if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
            return true;
        }
        if (c instanceof HotSpotObjectConstant || c instanceof HotSpotMetaspaceConstant) {
            return false;
        }
        return super.canInlineConstant(c);
    }

    @Override
    public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        Object usedSource = HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(src) ? JavaConstant.INT_0 : (src instanceof HotSpotObjectConstant && ((HotSpotObjectConstant)src).isNull() ? JavaConstant.LONG_0 : src);
        if (usedSource instanceof HotSpotConstant) {
            HotSpotConstant constant = (HotSpotConstant)usedSource;
            if (constant.isCompressed()) {
                return new AArch64HotSpotMove.LoadHotSpotObjectConstantInline(constant, dst);
            }
            return new AArch64HotSpotMove.LoadHotSpotObjectConstantInline(constant, dst);
        }
        return super.createLoad(dst, (Constant)usedSource);
    }
}

