/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;

@Opcode(value="RETURN")
public final class AArch64HotSpotReturnOp
extends AArch64HotSpotEpilogueOp
implements DiagnosticLIRGeneratorTool.ZapStackArgumentSpaceBeforeInstruction {
    public static final LIRInstructionClass<AArch64HotSpotReturnOp> TYPE = LIRInstructionClass.create(AArch64HotSpotReturnOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value result;
    private final boolean isStub;
    private final boolean requiresReservedStackAccessCheck;

    public AArch64HotSpotReturnOp(Value result, boolean isStub, GraalHotSpotVMConfig config, Register thread, boolean requiresReservedStackAccessCheck) {
        super(TYPE, config, thread);
        this.requiresReservedStackAccessCheck = requiresReservedStackAccessCheck;
        assert (AArch64HotSpotReturnOp.validReturnValue(result));
        this.result = result;
        this.isStub = isStub;
    }

    private static boolean validReturnValue(Value result) {
        if (result.equals((Object)Value.ILLEGAL)) {
            return true;
        }
        Register reg = ValueUtil.asRegister((Value)result);
        return reg.equals((Object)AArch64.r0) || reg.equals((Object)AArch64.v0);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        boolean emitSafepoint = !this.isStub;
        this.leaveFrame(crb, masm, emitSafepoint, this.requiresReservedStackAccessCheck);
        masm.ret(AArch64.lr);
        crb.frameContext.returned(crb);
    }
}

