/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="UNWIND")
public final class AArch64HotSpotUnwindOp
extends AArch64HotSpotEpilogueOp {
    public static final LIRInstructionClass<AArch64HotSpotUnwindOp> TYPE = LIRInstructionClass.create(AArch64HotSpotUnwindOp.class);
    @LIRInstruction.Use
    protected RegisterValue exception;

    public AArch64HotSpotUnwindOp(GraalHotSpotVMConfig config, RegisterValue exception) {
        super(TYPE, config);
        this.exception = exception;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        this.leaveFrame(crb, masm, false, false);
        ForeignCallLinkage linkage = crb.foreignCalls.lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention cc = linkage.getOutgoingCallingConvention();
        assert (cc.getArgumentCount() == 2);
        assert (this.exception.equals((Object)cc.getArgument(0)));
        Register returnAddress = ValueUtil.asRegister((Value)cc.getArgument(1));
        masm.mov(64, returnAddress, AArch64.lr);
        AArch64Call.directJmp(crb, masm, linkage);
    }
}

