/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.word.Pointer;

public final class AMD64ArrayCompareToStub
extends SnippetStub {
    public static final HotSpotForeignCallDescriptor STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "byteArrayCompareToByteArray", Integer.TYPE, Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "byteArrayCompareToCharArray", Integer.TYPE, Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "charArrayCompareToByteArray", Integer.TYPE, Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "charArrayCompareToCharArray", Integer.TYPE, Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE);

    public AMD64ArrayCompareToStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    public static ForeignCallDescriptor getStub(ArrayCompareToNode arrayCompareToNode) {
        JavaKind kind1 = arrayCompareToNode.getKind1();
        JavaKind kind2 = arrayCompareToNode.getKind2();
        if (kind1 == JavaKind.Byte) {
            if (kind2 == JavaKind.Byte) {
                return STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY;
            }
            if (kind2 == JavaKind.Char) {
                return STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY;
            }
        } else if (kind1 == JavaKind.Char) {
            if (kind2 == JavaKind.Byte) {
                return STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY;
            }
            if (kind2 == JavaKind.Char) {
                return STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Snippet
    private static int byteArrayCompareToByteArray(Pointer array1, Pointer array2, int length1, int length2) {
        return ArrayCompareToNode.compareTo(array1, array2, length1, length2, JavaKind.Byte, JavaKind.Byte);
    }

    @Snippet
    private static int byteArrayCompareToCharArray(Pointer array1, Pointer array2, int length1, int length2) {
        return ArrayCompareToNode.compareTo(array1, array2, length1, length2, JavaKind.Byte, JavaKind.Char);
    }

    @Snippet
    private static int charArrayCompareToByteArray(Pointer array1, Pointer array2, int length1, int length2) {
        return ArrayCompareToNode.compareTo(array1, array2, length1, length2, JavaKind.Char, JavaKind.Byte);
    }

    @Snippet
    private static int charArrayCompareToCharArray(Pointer array1, Pointer array2, int length1, int length2) {
        return ArrayCompareToNode.compareTo(array1, array2, length1, length2, JavaKind.Char, JavaKind.Char);
    }
}

