/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayCopyWithConversionsNode;

public final class AMD64ArrayCopyWithConversionsStub
extends SnippetStub {
    private static final HotSpotForeignCallDescriptor STUB_DYNAMIC_STRIDES = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, ArrayCopyWithConversionsNode.KILLED_LOCATIONS, "stubDynamicStrides", Void.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor[] STUBS = new HotSpotForeignCallDescriptor[]{AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS1S1"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS1S2"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS1S4"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS2S1"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS2S2"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS2S4"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS4S1"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS4S2"), AMD64ArrayCopyWithConversionsStub.foreignCallDescriptor("stubS4S4"), STUB_DYNAMIC_STRIDES};

    private static HotSpotForeignCallDescriptor foreignCallDescriptor(String name) {
        return new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, ArrayCopyWithConversionsNode.KILLED_LOCATIONS, name, Void.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    }

    public static HotSpotForeignCallDescriptor getStub(ArrayCopyWithConversionsNode node) {
        int directCallIndex = node.getDirectStubCallIndex();
        if (directCallIndex < 0) {
            return STUB_DYNAMIC_STRIDES;
        }
        return STUBS[directCallIndex];
    }

    public AMD64ArrayCopyWithConversionsStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    @Snippet
    private static void stubS1S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S1, StrideUtil.S1);
    }

    @Snippet
    private static void stubS1S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S1, StrideUtil.S2);
    }

    @Snippet
    private static void stubS1S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S1, StrideUtil.S4);
    }

    @Snippet
    private static void stubS2S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S2, StrideUtil.S1);
    }

    @Snippet
    private static void stubS2S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S2, StrideUtil.S2);
    }

    @Snippet
    private static void stubS2S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S2, StrideUtil.S4);
    }

    @Snippet
    private static void stubS4S1(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S4, StrideUtil.S1);
    }

    @Snippet
    private static void stubS4S2(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S4, StrideUtil.S2);
    }

    @Snippet
    private static void stubS4S4(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, StrideUtil.S4, StrideUtil.S4);
    }

    @Snippet
    private static void stubDynamicStrides(Object arraySrc, long offsetSrc, Object arrayDst, long offsetDst, int length, int dynamicStrides) {
        ArrayCopyWithConversionsNode.arrayCopy(arraySrc, offsetSrc, arrayDst, offsetDst, length, dynamicStrides);
    }
}

