/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.lir.amd64.AMD64ArrayEqualsOp;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.word.Pointer;

public final class AMD64ArrayEqualsStub
extends SnippetStub {
    private static final HotSpotForeignCallDescriptor STUB_BOOLEAN_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "booleanArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_BYTE_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "byteArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CHAR_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "charArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_SHORT_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "shortArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_INT_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "intArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_LONG_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "longArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_FLOAT_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "floatArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_DOUBLE_ARRAY_EQUALS = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "doubleArraysEquals", Boolean.TYPE, Pointer.class, Pointer.class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_DYNAMIC_STRIDES = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsDynamicStrides", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor[] STUBS = new HotSpotForeignCallDescriptor[]{AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS1S1"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS1S2"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS1S4"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS2S1"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS2S2"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS2S4"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS4S1"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS4S2"), AMD64ArrayEqualsStub.foreignCallDescriptor("arrayRegionEqualsS4S4"), STUB_REGION_EQUALS_DYNAMIC_STRIDES, STUB_BOOLEAN_ARRAY_EQUALS, STUB_BYTE_ARRAY_EQUALS, STUB_CHAR_ARRAY_EQUALS, STUB_SHORT_ARRAY_EQUALS, STUB_INT_ARRAY_EQUALS, STUB_LONG_ARRAY_EQUALS, STUB_FLOAT_ARRAY_EQUALS, STUB_DOUBLE_ARRAY_EQUALS};

    private static HotSpotForeignCallDescriptor foreignCallDescriptor(String name) {
        return new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, name, Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    }

    public static ForeignCallDescriptor getArrayEqualsStub(ArrayEqualsNode arrayEqualsNode, AMD64HotSpotLIRGenerator gen) {
        JavaKind stride = arrayEqualsNode.getKind();
        ValueNode length = arrayEqualsNode.getLength();
        if (length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), stride, stride, length.asJavaConstant().asInt(), gen.getMaxVectorSize())) {
            return null;
        }
        switch (stride) {
            case Boolean: {
                return STUB_BOOLEAN_ARRAY_EQUALS;
            }
            case Byte: {
                return STUB_BYTE_ARRAY_EQUALS;
            }
            case Char: {
                return STUB_CHAR_ARRAY_EQUALS;
            }
            case Short: {
                return STUB_SHORT_ARRAY_EQUALS;
            }
            case Int: {
                return STUB_INT_ARRAY_EQUALS;
            }
            case Long: {
                return STUB_LONG_ARRAY_EQUALS;
            }
            case Float: {
                return STUB_FLOAT_ARRAY_EQUALS;
            }
            case Double: {
                return STUB_DOUBLE_ARRAY_EQUALS;
            }
        }
        return null;
    }

    public static ForeignCallDescriptor getRegionEqualsStub(ArrayRegionEqualsNode regionEqualsNode, AMD64HotSpotLIRGenerator gen) {
        int directStubCallIndex = regionEqualsNode.getDirectStubCallIndex();
        GraalError.guarantee(-1 <= directStubCallIndex && directStubCallIndex < 9, "invalid direct stub call index");
        ValueNode length = regionEqualsNode.getLength();
        if (directStubCallIndex >= 0 && length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex), length.asJavaConstant().asInt(), gen.getMaxVectorSize())) {
            return null;
        }
        return directStubCallIndex < 0 ? STUB_REGION_EQUALS_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
    }

    public AMD64ArrayEqualsStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    @Snippet
    private static boolean booleanArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Boolean);
    }

    @Snippet
    private static boolean byteArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Byte);
    }

    @Snippet
    private static boolean charArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Char);
    }

    @Snippet
    private static boolean shortArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Short);
    }

    @Snippet
    private static boolean intArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Int);
    }

    @Snippet
    private static boolean longArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Long);
    }

    @Snippet
    private static boolean floatArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Float);
    }

    @Snippet
    private static boolean doubleArraysEquals(Pointer array1, Pointer array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Double);
    }

    @Snippet
    private static boolean arrayRegionEqualsDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S4);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S1);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S2);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionEqualsNode.regionEquals(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S4);
    }
}

