/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.lir.amd64.AMD64ArrayEqualsOp;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayRegionEqualsWithMaskNode;

public final class AMD64ArrayEqualsWithMaskStub
extends SnippetStub {
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S1_S1_S1 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS1S1S1", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S1_S2_S1 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS1S2S1", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S1_S2_S2 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS1S2S2", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S2_S1_S1 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS2S1S1", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S2_S2_S1 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS2S2S1", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_B_S2_S2_S2 = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsBS2S2S2", Boolean.TYPE, byte[].class, Long.TYPE, byte[].class, Long.TYPE, byte[].class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_C = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsC", Boolean.TYPE, char[].class, Long.TYPE, char[].class, Long.TYPE, char[].class, Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_REGION_EQUALS_DYNAMIC_STRIDES = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "arrayRegionEqualsDynamicStrides", Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor[] STUBS = new HotSpotForeignCallDescriptor[]{AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS1S1"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS1S2"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS1S4"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS2S1"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS2S2"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS2S4"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS4S1"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS4S2"), AMD64ArrayEqualsWithMaskStub.foreignCallDescriptor("arrayRegionEqualsS4S4"), STUB_REGION_EQUALS_DYNAMIC_STRIDES, STUB_REGION_EQUALS_B_S1_S1_S1, STUB_REGION_EQUALS_B_S1_S2_S1, STUB_REGION_EQUALS_B_S1_S2_S2, STUB_REGION_EQUALS_B_S2_S1_S1, STUB_REGION_EQUALS_B_S2_S2_S1, STUB_REGION_EQUALS_B_S2_S2_S2, STUB_REGION_EQUALS_C};

    private static HotSpotForeignCallDescriptor foreignCallDescriptor(String name) {
        return new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, name, Boolean.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, byte[].class, Integer.TYPE);
    }

    public static HotSpotForeignCallDescriptor getStub(AMD64ArrayRegionEqualsWithMaskNode node, AMD64HotSpotLIRGenerator gen) {
        JavaKind strideA = node.getStrideA();
        JavaKind strideB = node.getStrideB();
        JavaKind strideM = node.getStrideMask();
        ValueNode length = node.getLength();
        int directStubCallIndex = node.getDirectStubCallIndex();
        GraalError.guarantee(-1 <= directStubCallIndex && directStubCallIndex < 9, "invalid direct stub call index");
        if (directStubCallIndex >= 0 && length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex), length.asJavaConstant().asInt(), gen.getMaxVectorSize())) {
            return null;
        }
        switch (node.getArrayKind()) {
            case Byte: {
                switch (strideA) {
                    case Byte: {
                        switch (strideB) {
                            case Byte: {
                                GraalError.guarantee(strideM == StrideUtil.S1, "mask stride must match strideA and strideB");
                                return STUB_REGION_EQUALS_B_S1_S1_S1;
                            }
                            case Char: {
                                switch (strideM) {
                                    case Byte: {
                                        return STUB_REGION_EQUALS_B_S1_S2_S1;
                                    }
                                    case Char: {
                                        return STUB_REGION_EQUALS_B_S1_S2_S2;
                                    }
                                }
                                throw GraalError.shouldNotReachHere();
                            }
                        }
                        throw GraalError.shouldNotReachHere();
                    }
                    case Char: {
                        switch (strideB) {
                            case Byte: {
                                GraalError.guarantee(strideM == StrideUtil.S1, "mask stride must match strideA and strideB");
                                return STUB_REGION_EQUALS_B_S2_S1_S1;
                            }
                            case Char: {
                                switch (strideM) {
                                    case Byte: {
                                        return STUB_REGION_EQUALS_B_S2_S2_S1;
                                    }
                                    case Char: {
                                        return STUB_REGION_EQUALS_B_S2_S2_S2;
                                    }
                                }
                                throw GraalError.shouldNotReachHere();
                            }
                        }
                        throw GraalError.shouldNotReachHere();
                    }
                }
                throw GraalError.shouldNotReachHere();
            }
            case Char: {
                GraalError.guarantee(strideA == StrideUtil.S2 && strideB == StrideUtil.S2 && strideM == StrideUtil.S2, "only stride2 allowed for char arrays");
                return STUB_REGION_EQUALS_C;
            }
            case Void: {
                return directStubCallIndex < 0 ? STUB_REGION_EQUALS_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public AMD64ArrayEqualsWithMaskStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS1S1S1(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S1, StrideUtil.S1, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS1S2S1(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S1, StrideUtil.S2, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS1S2S2(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S1, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS2S1S1(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S2, StrideUtil.S1, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS2S2S1(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S2, StrideUtil.S2, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsBS2S2S2(byte[] arrayA, long offsetA, byte[] arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S1, StrideUtil.S2, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsC(char[] arrayA, long offsetA, char[] arrayB, long offsetB, char[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.S2, StrideUtil.S2, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S1, StrideUtil.S1, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S1, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S1, StrideUtil.S4, StrideUtil.S4, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S2, StrideUtil.S1, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S2, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S2, StrideUtil.S4, StrideUtil.S4, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S4, StrideUtil.S1, StrideUtil.S1, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S4, StrideUtil.S2, StrideUtil.S2, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(StrideUtil.NONE, StrideUtil.S4, StrideUtil.S4, StrideUtil.S4, arrayA, offsetA, arrayB, offsetB, mask, length);
    }

    @Snippet
    private static boolean arrayRegionEqualsDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, byte[] mask, int length, int dynamicStrides) {
        return AMD64ArrayRegionEqualsWithMaskNode.regionEquals(arrayA, offsetA, arrayB, offsetB, mask, length, dynamicStrides);
    }
}

