/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.ArrayRegionCompareToNode;

public final class AMD64ArrayRegionCompareToStub
extends SnippetStub {
    private static final HotSpotForeignCallDescriptor STUB_DYNAMIC_STRIDES = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "stubDynamicStrides", Integer.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
    public static final HotSpotForeignCallDescriptor[] STUBS = new HotSpotForeignCallDescriptor[]{AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS1S1"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS1S2"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS1S4"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS2S1"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS2S2"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS2S4"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS4S1"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS4S2"), AMD64ArrayRegionCompareToStub.foreignCallDescriptor("stubS4S4"), STUB_DYNAMIC_STRIDES};

    private static HotSpotForeignCallDescriptor foreignCallDescriptor(String name) {
        return new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, name, Integer.TYPE, Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE);
    }

    public AMD64ArrayRegionCompareToStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    public static ForeignCallDescriptor getStub(ArrayRegionCompareToNode node) {
        int directStubCallIndex = node.getDirectStubCallIndex();
        return directStubCallIndex < 0 ? STUB_DYNAMIC_STRIDES : STUBS[directStubCallIndex];
    }

    @Snippet
    private static int stubS1S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S1);
    }

    @Snippet
    private static int stubS1S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S2);
    }

    @Snippet
    private static int stubS1S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S1, StrideUtil.S4);
    }

    @Snippet
    private static int stubS2S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S1);
    }

    @Snippet
    private static int stubS2S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S2);
    }

    @Snippet
    private static int stubS2S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S2, StrideUtil.S4);
    }

    @Snippet
    private static int stubS4S1(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S1);
    }

    @Snippet
    private static int stubS4S2(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S2);
    }

    @Snippet
    private static int stubS4S4(Object arrayA, long offsetA, Object arrayB, long offsetB, int length) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, StrideUtil.S4, StrideUtil.S4);
    }

    @Snippet
    private static int stubDynamicStrides(Object arrayA, long offsetA, Object arrayB, long offsetB, int length, int dynamicStrides) {
        return ArrayRegionCompareToNode.compare(arrayA, offsetA, arrayB, offsetB, length, dynamicStrides);
    }
}

