/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.amd64.AMD64CalcStringAttributesNode;

public final class AMD64CalcStringAttributesStub
extends SnippetStub {
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_LATIN1 = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesLatin1", Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_BMP = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesBMP", Integer.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesUTF8Valid", Long.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesUTF8Unknown", Long.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesUTF16Valid", Long.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesUTF16Unknown", Long.TYPE);
    private static final HotSpotForeignCallDescriptor STUB_CALC_STRING_ATTRIBUTES_UTF32 = AMD64CalcStringAttributesStub.foreignCallDescriptor("calcStringAttributesUTF32", Integer.TYPE);
    public static final HotSpotForeignCallDescriptor[] STUBS = new HotSpotForeignCallDescriptor[]{STUB_CALC_STRING_ATTRIBUTES_LATIN1, STUB_CALC_STRING_ATTRIBUTES_BMP, STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID, STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN, STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID, STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN, STUB_CALC_STRING_ATTRIBUTES_UTF32};

    private static HotSpotForeignCallDescriptor foreignCallDescriptor(String name, Class<?> resultType) {
        return new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, name, resultType, Object.class, Long.TYPE, Integer.TYPE);
    }

    public static HotSpotForeignCallDescriptor getStub(AMD64CalcStringAttributesNode node) {
        switch (node.getOp()) {
            case LATIN1: {
                return STUB_CALC_STRING_ATTRIBUTES_LATIN1;
            }
            case BMP: {
                return STUB_CALC_STRING_ATTRIBUTES_BMP;
            }
            case UTF_8: {
                if (node.isAssumeValid()) {
                    return STUB_CALC_STRING_ATTRIBUTES_UTF8_VALID;
                }
                return STUB_CALC_STRING_ATTRIBUTES_UTF8_UNKNOWN;
            }
            case UTF_16: {
                if (node.isAssumeValid()) {
                    return STUB_CALC_STRING_ATTRIBUTES_UTF16_VALID;
                }
                return STUB_CALC_STRING_ATTRIBUTES_UTF16_UNKNOWN;
            }
            case UTF_32: {
                return STUB_CALC_STRING_ATTRIBUTES_UTF32;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public AMD64CalcStringAttributesStub(ForeignCallDescriptor foreignCallDescriptor, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(foreignCallDescriptor.getName(), options, providers, linkage);
    }

    @Snippet
    private static int calcStringAttributesLatin1(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.latin1Internal(array, offset, length);
    }

    @Snippet
    private static int calcStringAttributesBMP(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.bmpInternal(array, offset, length);
    }

    @Snippet
    private static long calcStringAttributesUTF8Valid(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.utf8Internal(true, array, offset, length);
    }

    @Snippet
    private static long calcStringAttributesUTF8Unknown(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.utf8Internal(false, array, offset, length);
    }

    @Snippet
    private static long calcStringAttributesUTF16Valid(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.utf16Internal(true, array, offset, length);
    }

    @Snippet
    private static long calcStringAttributesUTF16Unknown(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.utf16Internal(false, array, offset, length);
    }

    @Snippet
    private static int calcStringAttributesUTF32(Object array, long offset, int length) {
        return AMD64CalcStringAttributesNode.utf32Internal(array, offset, length);
    }
}

